/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.prolog;

import de.be4.classicalb.core.parser.util.Utils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public final class PackageName {
    private static final Pattern VALID_IDENTIFIER = Pattern.compile("([\\p{L}][\\p{L}\\p{N}_]*)");
    private final List<String> nameParts;

    public PackageName(List<String> nameParts) {
        this.nameParts = new ArrayList<String>(nameParts);
    }

    public static PackageName fromName(String name) {
        List<String> nameParts = Arrays.asList(name.split("\\."));
        for (String part : nameParts) {
            if (VALID_IDENTIFIER.matcher(part).matches()) continue;
            if (part.contains("\\") || part.contains("/")) {
                throw new IllegalArgumentException("Invalid package name " + name + ": name part " + part + " is not a valid package identifier (use dots and not slashes to specify paths)");
            }
            throw new IllegalArgumentException("Invalid package name " + name + ": name part " + part + " is not a valid package identifier");
        }
        return new PackageName(nameParts);
    }

    public static PackageName fromPossiblyQuotedName(String name) {
        if (Utils.isQuoted(name, '\"')) {
            return PackageName.fromName(Utils.removeSurroundingQuotes(name, '\"'));
        }
        return PackageName.fromName(name);
    }

    public List<String> getNameParts() {
        return Collections.unmodifiableList(this.nameParts);
    }

    public String getName() {
        return String.join((CharSequence)".", this.getNameParts());
    }

    public File getFile(File rootDirectory) {
        File f = rootDirectory;
        for (String part : this.getNameParts()) {
            f = new File(f, part);
        }
        return f;
    }

    public Path getPath(Path rootDirectory) {
        Path path = rootDirectory;
        for (String part : this.getNameParts()) {
            path = path.resolve(part);
        }
        return path;
    }

    public Path determineRootDirectory(Path packageDirectory) {
        Path dir = packageDirectory;
        for (int i = this.getNameParts().size() - 1; i >= 0; --i) {
            String name2;
            String name1 = this.getNameParts().get(i);
            if (!name1.equals(name2 = dir.getFileName().toString())) {
                throw new IllegalArgumentException(String.format("Package declaration '%s' does not match the folder structure: %s vs %s", this.getName(), name1, name2));
            }
            dir = dir.getParent();
        }
        return dir;
    }

    public File determineRootDirectory(File packageDirectory) {
        return this.determineRootDirectory(packageDirectory.toPath()).toFile();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PackageName other = (PackageName)obj;
        return this.getNameParts().equals(other.getNameParts());
    }

    public int hashCode() {
        return Objects.hash(this.getNameParts());
    }

    public String toString() {
        return this.getName();
    }
}

