/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.checking;

import de.be4.classicalb.core.parser.analysis.checking.ClausesCollector;
import de.be4.classicalb.core.parser.analysis.checking.SemanticCheck;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.AAbstractConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.AConcreteVariablesMachineClause;
import de.be4.classicalb.core.parser.node.AConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AConstraintsMachineClause;
import de.be4.classicalb.core.parser.node.ADescriptionMachineClause;
import de.be4.classicalb.core.parser.node.AImplementationMachineParseUnit;
import de.be4.classicalb.core.parser.node.AImportsMachineClause;
import de.be4.classicalb.core.parser.node.AIncludesMachineClause;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AInvariantMachineClause;
import de.be4.classicalb.core.parser.node.ALocalOperationsMachineClause;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.ARefinementMachineParseUnit;
import de.be4.classicalb.core.parser.node.AUsesMachineClause;
import de.be4.classicalb.core.parser.node.AValuesMachineClause;
import de.be4.classicalb.core.parser.node.AVariablesMachineClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClausesCheck
implements SemanticCheck {
    private static final Set<Class<? extends Node>> MACHINE_FORBIDDEN_CLAUSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(AImportsMachineClause.class, AValuesMachineClause.class)));
    private static final Set<Class<? extends Node>> REFINEMENT_FORBIDDEN_CLAUSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(AUsesMachineClause.class, AConstraintsMachineClause.class, ALocalOperationsMachineClause.class, AImportsMachineClause.class, AValuesMachineClause.class)));
    private static final Set<Class<? extends Node>> IMPLEMENTATION_FORBIDDEN_CLAUSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(AConstraintsMachineClause.class, AIncludesMachineClause.class, AUsesMachineClause.class, AAbstractConstantsMachineClause.class, AVariablesMachineClause.class)));
    private static final Map<Class<? extends Node>, String> CLAUSE_NAMES_BY_CLASS;
    private Map<Class<? extends Node>, Set<Node>> clauses;
    private final List<CheckException> exceptions = new ArrayList<CheckException>();

    @Override
    public void runChecks(Start rootNode) {
        if (!Utils.isCompleteMachine(rootNode)) {
            return;
        }
        ClausesCollector collector = new ClausesCollector();
        rootNode.apply(collector);
        this.clauses = collector.getAvailableClauses();
        this.checkDoubleClauses();
        this.checkMachineClauses(rootNode);
        this.checkRefinementClauses(rootNode);
        this.checkImplementationClauses(rootNode);
        if (!collector.isRefinement()) {
            this.checkConstantsClause();
            this.checkVariablesClauses();
            if (collector.hasScalarParameter()) {
                this.checkConstraintExistance(rootNode);
            }
        }
    }

    private void checkConstraintExistance(Start rootNode) {
        if (!this.clauses.containsKey(AConstraintsMachineClause.class)) {
            this.exceptions.add(new CheckException("Specification has formal scalar parameter and no CONSTRAINTS clause.", rootNode.getPParseUnit()));
        }
    }

    private void checkImplementationClauses(Start rootNode) {
        if (!(rootNode.getPParseUnit() instanceof AImplementationMachineParseUnit)) {
            return;
        }
        this.findForbidden(IMPLEMENTATION_FORBIDDEN_CLAUSES, "implementation machine");
    }

    private void checkRefinementClauses(Start rootNode) {
        if (!(rootNode.getPParseUnit() instanceof ARefinementMachineParseUnit)) {
            return;
        }
        this.findForbidden(REFINEMENT_FORBIDDEN_CLAUSES, "refinement machine");
    }

    private void checkMachineClauses(Start rootNode) {
        if (!(rootNode.getPParseUnit() instanceof AAbstractMachineParseUnit)) {
            return;
        }
        this.findForbidden(MACHINE_FORBIDDEN_CLAUSES, "abstract machine");
    }

    private boolean initClauseExists() {
        return this.clauses.containsKey(AInitialisationMachineClause.class) || this.clauses.containsKey(ADescriptionMachineClause.class);
    }

    private void checkVariablesClauses() {
        if (!(!this.clauses.containsKey(AVariablesMachineClause.class) && !this.clauses.containsKey(AConcreteVariablesMachineClause.class) || this.clauses.containsKey(AInvariantMachineClause.class) && this.initClauseExists())) {
            HashSet nodes = new HashSet();
            if (this.clauses.containsKey(AVariablesMachineClause.class)) {
                nodes.addAll(this.clauses.get(AVariablesMachineClause.class));
            }
            if (this.clauses.containsKey(AConcreteVariablesMachineClause.class)) {
                nodes.addAll(this.clauses.get(AConcreteVariablesMachineClause.class));
            }
            StringBuilder message = new StringBuilder("Clause(s) missing: ");
            boolean first = true;
            if (!this.clauses.containsKey(AInvariantMachineClause.class)) {
                message.append("INVARIANT");
                first = false;
            }
            if (!this.initClauseExists()) {
                if (!first) {
                    message.append(", ");
                }
                message.append("INITIALISATION");
            }
            this.exceptions.add(new CheckException(message.toString(), new ArrayList<Node>(nodes)));
        }
    }

    private void checkConstantsClause() {
        if ((this.clauses.containsKey(AConstantsMachineClause.class) || this.clauses.containsKey(AAbstractConstantsMachineClause.class)) && !this.clauses.containsKey(APropertiesMachineClause.class)) {
            HashSet nodes = new HashSet();
            if (this.clauses.containsKey(AConstantsMachineClause.class)) {
                nodes.addAll(this.clauses.get(AConstantsMachineClause.class));
            }
            if (this.clauses.containsKey(AAbstractConstantsMachineClause.class)) {
                nodes.addAll(this.clauses.get(AAbstractConstantsMachineClause.class));
            }
            this.exceptions.add(new CheckException("Clause(s) missing: PROPERTIES", new ArrayList<Node>(nodes)));
        }
    }

    private static String clauseNameFromNodeClass(Class<? extends Node> nodeClass) {
        if (CLAUSE_NAMES_BY_CLASS.containsKey(nodeClass)) {
            return CLAUSE_NAMES_BY_CLASS.get(nodeClass);
        }
        return nodeClass.getSimpleName();
    }

    private void findForbidden(Set<Class<? extends Node>> forbiddenClasses, String machineKindDescription) {
        HashSet<Class<? extends Node>> wrongClauseClasses = new HashSet<Class<? extends Node>>(this.clauses.keySet());
        wrongClauseClasses.retainAll(forbiddenClasses);
        if (!wrongClauseClasses.isEmpty()) {
            HashSet nodes = new HashSet();
            HashSet<String> wrongClauseNames = new HashSet<String>();
            for (Class clazz : wrongClauseClasses) {
                nodes.addAll(this.clauses.get(clazz));
                wrongClauseNames.add(ClausesCheck.clauseNameFromNodeClass(clazz));
            }
            this.exceptions.add(new CheckException("Clauses not allowed in " + machineKindDescription + ": " + String.join((CharSequence)", ", wrongClauseNames), new ArrayList<Node>(nodes)));
        }
    }

    private void checkDoubleClauses() {
        for (Set<Node> nodesforClause : this.clauses.values()) {
            if (nodesforClause.size() <= 1) continue;
            Node clauseNode = nodesforClause.iterator().next();
            String clauseName = ClausesCheck.clauseNameFromNodeClass(clauseNode.getClass());
            this.exceptions.add(new CheckException("Clause '" + clauseName + "' is used more than once", new ArrayList<Node>(nodesforClause)));
        }
    }

    @Override
    public List<CheckException> getCheckExceptions() {
        return this.exceptions;
    }

    static {
        HashMap<Class, String> clauseNamesByClass = new HashMap<Class, String>();
        clauseNamesByClass.put(AAbstractConstantsMachineClause.class, "ABSTRACT_CONSTANTS");
        clauseNamesByClass.put(AConstraintsMachineClause.class, "CONSTRAINTS");
        clauseNamesByClass.put(AImportsMachineClause.class, "IMPORTS");
        clauseNamesByClass.put(AIncludesMachineClause.class, "INCLUDES");
        clauseNamesByClass.put(ALocalOperationsMachineClause.class, "LOCAL_OPERATIONS");
        clauseNamesByClass.put(AUsesMachineClause.class, "USES");
        clauseNamesByClass.put(AValuesMachineClause.class, "VALUES");
        clauseNamesByClass.put(AVariablesMachineClause.class, "VARIABLES (or ABSTRACT_VARIABLES)");
        CLAUSE_NAMES_BY_CLASS = Collections.unmodifiableMap(clauseNamesByClass);
    }
}

