/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.SimulationWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.coverage.CostModelCreator;
import tlc2.tool.impl.FastTool;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.liveness.LiveCheck1;
import tlc2.tool.liveness.LiveException;
import tlc2.tool.liveness.NoOpLiveCheck;
import tlc2.util.RandomGenerator;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.value.IValue;
import util.Assert;
import util.FileUtil;
import util.FilenameToStream;

public class Simulator {
    public static boolean EXPERIMENTAL_LIVENESS_SIMULATION = Boolean.getBoolean(Simulator.class.getName() + ".experimentalLiveness");
    private final ILiveCheck liveCheck;
    private final ITool tool;
    private final Action[] invariants;
    private final boolean checkDeadlock;
    private final boolean checkLiveness;
    private final LongAdder numOfGenStates = new LongAdder();
    private final LongAdder numOfGenTraces = new LongAdder();
    private final String traceFile;
    private final long traceDepth;
    private final long traceNum;
    private int numWorkers = 1;
    private final RandomGenerator rng;
    private final long seed;
    private long aril;
    private BlockingQueue<SimulationWorker.SimulationWorkerResult> workerResultQueue = new LinkedBlockingQueue<SimulationWorker.SimulationWorkerResult>();
    private final long startTime = System.currentTimeMillis();
    private final List<SimulationWorker> workers;

    public Simulator(String specFile, String configFile, String traceFile, boolean deadlock, int traceDepth, long traceNum, RandomGenerator rng, long seed, FilenameToStream resolver, int numWorkers) throws IOException {
        int lastSep = specFile.lastIndexOf(FileUtil.separatorChar);
        String specDir = lastSep == -1 ? "" : specFile.substring(0, lastSep + 1);
        specFile = specFile.substring(lastSep + 1);
        this.tool = new FastTool(specDir, specFile, configFile, resolver);
        this.checkDeadlock = deadlock && this.tool.getModelConfig().getCheckDeadlock();
        this.checkLiveness = !this.tool.livenessIsTrue();
        this.invariants = this.tool.getInvariants();
        this.traceDepth = traceDepth != -1 ? (long)traceDepth : Long.MAX_VALUE;
        this.traceFile = traceFile;
        this.traceNum = traceNum;
        this.rng = rng;
        this.seed = seed;
        this.aril = 0L;
        if (this.checkLiveness) {
            if (EXPERIMENTAL_LIVENESS_SIMULATION) {
                String tmpDir = System.getProperty("java.io.tmpdir");
                this.liveCheck = new LiveCheck(this.tool, tmpDir, new DummyBucketStatistics());
            } else {
                this.liveCheck = new LiveCheck1(this.tool);
            }
        } else {
            this.liveCheck = new NoOpLiveCheck(this.tool, specDir);
        }
        this.numWorkers = numWorkers;
        this.workers = new ArrayList<SimulationWorker>(numWorkers);
        for (int i = 0; i < this.numWorkers; ++i) {
            this.workers.add(new SimulationWorker(i, this.tool, this.workerResultQueue, this.rng.nextLong(), this.traceDepth, this.traceNum, this.checkDeadlock, this.traceFile, this.liveCheck, this.numOfGenStates, this.numOfGenTraces));
        }
        if (TLCGlobals.isCoverageEnabled()) {
            CostModelCreator.create(this.tool);
        }
        AbstractChecker.scheduleTermination(new TimerTask(){

            @Override
            public void run() {
                Simulator.this.stop();
            }
        });
    }

    private boolean isNonContinuableError(int ec) {
        return ec == 2111 || ec == 2113 || ec == 2109;
    }

    private void shutdownAndJoinWorkers(List<SimulationWorker> workers) throws InterruptedException {
        for (SimulationWorker worker : workers) {
            worker.interrupt();
            worker.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int simulate() throws Exception {
        int res = this.tool.checkAssumptions();
        if (res != 0) {
            return res;
        }
        TLCState curState = null;
        StateVec initStates = this.tool.getInitStates();
        try {
            assert (this.numOfGenStates.longValue() == 0L);
            this.numOfGenStates.add(initStates.size());
            MP.printMessage(2269, this.numOfGenStates.toString());
            for (int i = 0; i < initStates.size(); ++i) {
                curState = initStates.elementAt(i);
                if (this.tool.isGoodState(curState)) {
                    for (int j = 0; j < this.invariants.length; ++j) {
                        if (this.tool.isValid(this.invariants[j], curState)) continue;
                        return MP.printError(2107, new String[]{this.tool.getInvNames()[j], curState.toString()});
                    }
                    continue;
                }
                return MP.printError(2106, curState.toString());
            }
        }
        catch (Exception e) {
            int errorCode = curState != null ? MP.printError(2102, new String[]{e.getMessage() == null ? e.toString() : e.getMessage(), curState.toString()}) : MP.printError(1000, e);
            this.printSummary();
            return errorCode;
        }
        if (this.numOfGenStates.longValue() == 0L) {
            return MP.printError(2118);
        }
        initStates.deepNormalize();
        ProgressReport report = new ProgressReport();
        report.start();
        this.aril = this.rng.getAril();
        HashSet<Integer> runningWorkers = new HashSet<Integer>();
        for (int i = 0; i < this.workers.size(); ++i) {
            SimulationWorker worker = this.workers.get(i);
            worker.start(initStates);
            runningWorkers.add(i);
        }
        int errorCode = 0;
        while (true) {
            SimulationWorker.SimulationWorkerResult result;
            if ((result = this.workerResultQueue.take()).isError()) {
                SimulationWorker.SimulationWorkerError error = result.error();
                if (error.exception != null) {
                    if (error.exception instanceof LiveException) {
                        this.printSummary();
                        errorCode = ((LiveException)error.exception).errorCode;
                    } else if (error.exception instanceof Assert.TLCRuntimeException) {
                        Assert.TLCRuntimeException exception = (Assert.TLCRuntimeException)error.exception;
                        this.printBehavior(exception, error.state, error.stateTrace);
                        errorCode = exception.errorCode;
                    } else {
                        this.printBehavior(1000, new String[]{MP.ECGeneralMsg("", error.exception)}, error.state, error.stateTrace);
                        errorCode = 1000;
                    }
                    break;
                }
                this.printBehavior(error);
                if (this.isNonContinuableError(error.errorCode)) {
                    errorCode = error.errorCode;
                    break;
                }
                if (!TLCGlobals.continuation) {
                    errorCode = error.errorCode;
                    break;
                }
                if (errorCode != 0) continue;
                errorCode = 1000;
                continue;
            }
            runningWorkers.remove(result.workerId());
            if (runningWorkers.isEmpty()) break;
        }
        this.shutdownAndJoinWorkers(this.workers);
        report.isRunning = false;
        ProgressReport progressReport = report;
        synchronized (progressReport) {
            report.notify();
        }
        report.join();
        return errorCode;
    }

    public final void printBehavior(Assert.TLCRuntimeException exception, TLCState state, StateVec stateTrace) {
        MP.printTLCRuntimeException(exception);
        this.printBehavior(state, stateTrace);
    }

    public final void printBehavior(SimulationWorker.SimulationWorkerError error) {
        this.printBehavior(error.errorCode, error.parameters, error.state, error.stateTrace);
    }

    public final void printBehavior(int errorCode, String[] parameters, TLCState state, StateVec stateTrace) {
        MP.printError(errorCode, parameters);
        this.printBehavior(state, stateTrace);
        this.printSummary();
    }

    public final void printBehavior(TLCState state, StateVec stateTrace) {
        if (this.traceDepth == Long.MAX_VALUE) {
            MP.printMessage(2120);
            StatePrinter.printState(state);
        } else {
            if (!stateTrace.isLastElement(state)) {
                stateTrace.addElement(state);
            }
            MP.printError(2121);
            TLCState lastState = null;
            int cnt = 1;
            for (int i = 0; i < stateTrace.size(); ++i) {
                TLCState curState = stateTrace.elementAt(i);
                TLCStateInfo sinfo = lastState != null ? this.tool.getState(curState, lastState) : new TLCStateInfo(curState, "<Initial predicate>");
                if (lastState == null || curState.fingerPrint() != lastState.fingerPrint()) {
                    StatePrinter.printState(sinfo, lastState, cnt++);
                } else assert (Boolean.TRUE.booleanValue());
                lastState = curState;
            }
        }
    }

    public IValue getLocalValue(int idx) {
        Iterator<SimulationWorker> iterator = this.workers.iterator();
        if (iterator.hasNext()) {
            SimulationWorker w = iterator.next();
            return w.getLocalValue(idx);
        }
        return null;
    }

    public void setAllValues(int idx, IValue val) {
        for (SimulationWorker w : this.workers) {
            w.setLocalValue(idx, val);
        }
    }

    public final void printSummary() {
        this.reportCoverage();
        if (TLCGlobals.tool) {
            MP.printMessage(2209, String.valueOf(this.numOfGenStates.longValue()));
        }
        MP.printMessage(2210, String.valueOf(this.numOfGenStates.longValue()), String.valueOf(this.seed), String.valueOf(this.aril));
    }

    public final void reportCoverage() {
        if (TLCGlobals.isCoverageEnabled()) {
            CostModelCreator.report(this.tool, this.startTime);
        }
    }

    public void stop() {
        for (SimulationWorker worker : this.workers) {
            worker.interrupt();
        }
    }

    final class ProgressReport
    extends Thread {
        volatile boolean isRunning = true;

        ProgressReport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int count = TLCGlobals.coverageInterval / 60000;
            try {
                while (this.isRunning) {
                    ProgressReport progressReport = this;
                    synchronized (progressReport) {
                        this.wait(60000L);
                    }
                    MP.printMessage(2209, String.valueOf(Simulator.this.numOfGenStates.longValue()));
                    if (count > 1) {
                        --count;
                        continue;
                    }
                    Simulator.this.reportCoverage();
                    count = TLCGlobals.coverageInterval / 60000;
                }
            }
            catch (Exception e) {
                MP.printTLCBug(2124, null);
            }
        }
    }
}

