/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.types;

import de.be4.classicalb.core.parser.node.PExpression;
import de.tla2b.exceptions.UnificationException;
import de.tla2b.output.TypeVisitorInterface;
import de.tla2b.types.AbstractHasFollowers;
import de.tla2b.types.FunctionType;
import de.tla2b.types.IDefaultableType;
import de.tla2b.types.IntType;
import de.tla2b.types.TLAType;
import de.tla2b.types.TupleType;
import de.tla2b.types.UntypedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class TupleOrFunction
extends AbstractHasFollowers
implements IDefaultableType {
    private final Map<Integer, TLAType> types = new HashMap<Integer, TLAType>();

    private TupleOrFunction() {
        super(TUPLE_OR_FUNCTION);
    }

    public TupleOrFunction(int index, TLAType type) {
        this();
        if (index <= 0) {
            throw new IllegalArgumentException("tuples are 1-indexed");
        }
        this.types.put(index, type);
        if (type instanceof AbstractHasFollowers) {
            ((AbstractHasFollowers)type).addFollower(this);
        }
    }

    public static TLAType createTupleOrFunctionType(List<TLAType> list) {
        TupleOrFunction tOrF = new TupleOrFunction();
        for (int i = 0; i < list.size(); ++i) {
            TLAType type = list.get(i);
            tOrF.types.put(i + 1, type);
            if (!(type instanceof AbstractHasFollowers)) continue;
            ((AbstractHasFollowers)type).addFollower(tOrF);
        }
        return tOrF.update();
    }

    @Override
    public void apply(TypeVisitorInterface visitor) {
        visitor.caseTupleOrFunctionType(this);
    }

    public String toString() {
        return "TupleOrFunction(" + this.types.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> entry.getKey() + " : " + entry.getValue()).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public PExpression getBNode() {
        throw new UnsupportedOperationException("TupleOrFunction has no corresponding B node");
    }

    @Override
    public boolean compare(TLAType o) {
        if (this.contains(o) || o.contains(this)) {
            return false;
        }
        if (o.getKind() == UNTYPED) {
            return true;
        }
        if (o instanceof FunctionType) {
            FunctionType t = (FunctionType)o;
            return t.getDomain().compare(IntType.getInstance()) && this.types.values().stream().allMatch(type -> type.compare(t.getRange()));
        }
        if (o instanceof TupleType) {
            TupleType tupleType = (TupleType)o;
            List<TLAType> myTypes = this.typesAsContiguousList();
            List<TLAType> otherTypes = tupleType.getTypes();
            if (myTypes.size() > otherTypes.size()) {
                return false;
            }
            for (int i = 0; i < myTypes.size(); ++i) {
                if (myTypes.get(i).compare(otherTypes.get(i))) continue;
                return false;
            }
            return true;
        }
        if (o instanceof TupleOrFunction) {
            TupleOrFunction other = (TupleOrFunction)o;
            List<TLAType> myTypes = this.typesAsContiguousList();
            List<TLAType> otherTypes = other.typesAsContiguousList();
            for (int i = 0; i < Math.min(myTypes.size(), otherTypes.size()); ++i) {
                if (myTypes.get(i).compare(otherTypes.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(TLAType o) {
        return this.types.values().stream().anyMatch(type -> type.equals(o) || type.contains(o));
    }

    @Override
    public boolean isUntyped() {
        return true;
    }

    @Override
    public TLAType cloneTLAType() {
        TupleOrFunction res = new TupleOrFunction();
        this.types.forEach((i, type) -> {
            TLAType cloned = type.cloneTLAType();
            res.types.put((Integer)i, cloned);
            if (cloned instanceof AbstractHasFollowers) {
                ((AbstractHasFollowers)cloned).addFollower(res);
            }
        });
        return res;
    }

    @Override
    public TLAType unify(TLAType o) throws UnificationException {
        if (!this.compare(o)) {
            throw new UnificationException();
        }
        if (o instanceof UntypedType) {
            ((UntypedType)o).setFollowersTo(this);
            return this;
        }
        if (o instanceof FunctionType) {
            FunctionType funcType = (FunctionType)o;
            TLAType res = funcType.getRange();
            for (TLAType type : this.types.values()) {
                res = res.unify(type);
            }
            this.setFollowersTo(funcType);
            return funcType;
        }
        if (o instanceof TupleType) {
            TupleType tupleType = (TupleType)o;
            List<TLAType> myTypes = this.typesAsContiguousList();
            List<TLAType> otherTypes = tupleType.getTypes();
            for (int i = 0; i < myTypes.size(); ++i) {
                otherTypes.get(i).unify(myTypes.get(i));
            }
            this.setFollowersTo(tupleType);
            return tupleType;
        }
        if (o instanceof TupleOrFunction) {
            TupleOrFunction other = (TupleOrFunction)o;
            for (int otherI : new HashSet<Integer>(other.types.keySet())) {
                TLAType otherType = other.types.get(otherI);
                if (this.types.containsKey(otherI)) {
                    this.types.get(otherI).unify(otherType);
                    continue;
                }
                this.types.put(otherI, otherType);
                if (!(otherType instanceof AbstractHasFollowers)) continue;
                ((AbstractHasFollowers)otherType).addFollower(this);
            }
            other.setFollowersTo(this);
            return this.update();
        }
        throw new RuntimeException();
    }

    public void setNewType(AbstractHasFollowers oldType, TLAType newType) {
        new HashMap<Integer, TLAType>(this.types).forEach((key, value) -> {
            if (value == oldType) {
                this.types.put((Integer)key, newType);
                if (newType instanceof AbstractHasFollowers) {
                    ((AbstractHasFollowers)newType).addFollower(this);
                }
            }
        });
        this.update();
    }

    @Override
    public TLAType setToDefault() {
        List<TLAType> types = this.typesAsContiguousList();
        if (TupleOrFunction.allTypesComparableStrict(types)) {
            FunctionType func = new FunctionType(IntType.getInstance(), types.isEmpty() ? new UntypedType() : types.get(0));
            this.setFollowersTo(func);
            return func;
        }
        TupleType tuple = new TupleType(types);
        this.setFollowersTo(tuple);
        return tuple;
    }

    private TLAType update() {
        List<TLAType> types = this.typesAsContiguousList();
        if (!TupleOrFunction.allTypesComparable(types)) {
            TupleType tuple = new TupleType(types);
            this.setFollowersTo(tuple);
            return tuple;
        }
        return this;
    }

    private List<TLAType> typesAsContiguousList() {
        ArrayList<TLAType> list = new ArrayList<TLAType>();
        this.types.forEach((iBoxed, type) -> {
            if (iBoxed == null || iBoxed <= 0 || type == null) {
                throw new IllegalStateException();
            }
            int i = iBoxed - 1;
            if (i < list.size()) {
                TLAType current = (TLAType)list.get(i);
                if (!(current instanceof UntypedType) || ((AbstractHasFollowers)current).hasFollowers()) throw new IllegalStateException();
                list.set(i, (TLAType)type);
                return;
            } else {
                for (int j = list.size(); j < i; ++j) {
                    list.add(new UntypedType());
                }
                list.add((TLAType)type);
            }
        });
        return list;
    }

    private static boolean allTypesComparable(List<TLAType> typeList) {
        for (int i = 0; i < typeList.size() - 1; ++i) {
            TLAType t1 = typeList.get(i);
            for (int j = i + 1; j < typeList.size(); ++j) {
                TLAType t2 = typeList.get(j);
                if (t1.compare(t2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean allTypesComparableStrict(List<TLAType> typeList) {
        for (int i = 0; i < typeList.size() - 1; ++i) {
            TLAType t1 = typeList.get(i);
            for (int j = i + 1; j < typeList.size(); ++j) {
                TLAType t2 = typeList.get(j);
                if ((t1.isUntyped() || t2.isUntyped()) && t1 != t2) {
                    return false;
                }
                if (t1.compare(t2)) continue;
                return false;
            }
        }
        return true;
    }
}

