/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.translation;

import de.be4.classicalb.core.parser.util.Utils;
import de.tla2b.analysis.AbstractASTVisitor;
import de.tla2b.analysis.SpecAnalyser;
import de.tla2b.global.BBuiltInOPs;
import de.tla2b.util.DebugUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;

public class UsedDefinitionsFinder
extends AbstractASTVisitor {
    private final Set<OpDefNode> usedDefinitions = new HashSet<OpDefNode>();

    public UsedDefinitionsFinder(SpecAnalyser specAnalyser) {
        DebugUtils.printMsg("Finding used definitions");
        if (specAnalyser.getConfigFileEvaluator() != null) {
            Collection<OpDefNode> cons = specAnalyser.getConfigFileEvaluator().getConstantOverrides().values();
            for (OpDefNode def : cons) {
                this.visitExprNode(def.getBody());
            }
            Collection<OpDefNode> ops = specAnalyser.getConfigFileEvaluator().getOperatorOverrides().values();
            for (OpDefNode def : ops) {
                this.visitExprNode(def.getBody());
            }
            this.usedDefinitions.addAll(cons);
            this.usedDefinitions.addAll(ops);
        }
        this.visitAssumptions(specAnalyser.getModuleNode().getAssumptions());
        if (specAnalyser.getNext() != null) {
            this.visitExprNode(specAnalyser.getNext());
        }
        if (specAnalyser.getInitDef() != null) {
            this.usedDefinitions.add(specAnalyser.getInitDef());
        }
        if (specAnalyser.getInits() != null) {
            for (ExprNode init : specAnalyser.getInits()) {
                this.visitExprNode(init);
            }
        }
        if (specAnalyser.getInvariants() != null) {
            for (OpDefNode def : specAnalyser.getInvariants()) {
                this.usedDefinitions.add(def);
                this.visitExprNode(def.getBody());
            }
        }
        for (OpDefNode opDef : specAnalyser.getModuleNode().getOpDefs()) {
            String defName = opDef.getName().toString();
            if (!Utils.isProBSpecialDefinitionName(defName)) continue;
            DebugUtils.printMsg("ProB special definition: " + defName);
            this.usedDefinitions.add(opDef);
        }
    }

    public Set<OpDefNode> getUsedDefinitions() {
        return this.usedDefinitions;
    }

    @Override
    public void visitUserDefinedNode(OpApplNode n) {
        super.visitUserDefinedNode(n);
        OpDefNode def = (OpDefNode)n.getOperator();
        ModuleNode moduleNode = def.getSource().getOriginallyDefinedInModuleNode();
        if (moduleNode.getName().toString().equals("TLA2B") || BBuiltInOPs.isBBuiltInOp(def)) {
            return;
        }
        if (this.usedDefinitions.add(def)) {
            this.visitExprNode(def.getBody());
        }
    }
}

