/*
 * Decompiled with CFR 0.152.
 */
package de.tla2b.analysis;

import de.tla2b.global.BBuildIns;
import de.tla2b.global.BBuiltInOPs;
import java.util.HashMap;
import java.util.Map;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.BuiltInOPs;

public class PredicateVsExpression
extends BuiltInOPs
implements BBuildIns {
    private final Map<OpDefNode, DefinitionType> definitionsTypeMap = new HashMap<OpDefNode, DefinitionType>();

    public PredicateVsExpression(ModuleNode moduleNode) {
        for (OpDefNode def : moduleNode.getOpDefs()) {
            this.definitionsTypeMap.put(def, this.visitSemanticNode(def.getBody()));
        }
    }

    public DefinitionType getDefinitionType(OpDefNode def) {
        return this.definitionsTypeMap.get(def);
    }

    private DefinitionType visitSemanticNode(SemanticNode s) {
        switch (s.getKind()) {
            case 9: {
                return this.visitOpApplNode((OpApplNode)s);
            }
            case 10: {
                return this.visitSemanticNode(((LetInNode)s).getBody());
            }
        }
        return DefinitionType.EXPRESSION;
    }

    private DefinitionType visitOpApplNode(OpApplNode opApplNode) {
        int kind = opApplNode.getOperator().getKind();
        if (kind == 7) {
            switch (PredicateVsExpression.getOpCode(opApplNode.getOperator().getName())) {
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 27: 
                case 28: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 49: {
                    return DefinitionType.PREDICATE;
                }
                case 11: {
                    return this.visitSemanticNode(opApplNode.getArgs()[1]);
                }
                case 4: {
                    OpApplNode pair2 = (OpApplNode)opApplNode.getArgs()[0];
                    return this.visitSemanticNode(pair2.getArgs()[1]);
                }
            }
        } else if (kind == 5) {
            return this.visitUserdefinedOp(opApplNode);
        }
        return DefinitionType.EXPRESSION;
    }

    private DefinitionType visitUserdefinedOp(OpApplNode s) {
        OpDefNode def = (OpDefNode)s.getOperator();
        if (BBuiltInOPs.isBBuiltInOp(def)) {
            switch (BBuiltInOPs.getOpcode(def.getName())) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 19: {
                    return DefinitionType.PREDICATE;
                }
            }
            return DefinitionType.EXPRESSION;
        }
        return this.getDefinitionType(def);
    }

    public static enum DefinitionType {
        PREDICATE,
        EXPRESSION;

    }
}

