/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.term;

import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Objects;

public final class DotListConversion {
    private static final CompoundPrologTerm EMPTY_LIST_ATOM = new CompoundPrologTerm("[]");

    private DotListConversion() {
    }

    public static PrologTerm asListTerm(PrologTerm term) {
        Objects.requireNonNull(term, "term");
        if (term.hasFunctor("[]", 0)) {
            return ListPrologTerm.emptyList();
        }
        if (term.isList()) {
            ListPrologTerm listTerm = (ListPrologTerm)term;
            if (listTerm.isEmpty()) {
                return ListPrologTerm.emptyList();
            }
            ArrayList<PrologTerm> args = new ArrayList<PrologTerm>();
            for (PrologTerm arg : listTerm) {
                args.add(DotListConversion.asListTerm(arg));
            }
            return ListPrologTerm.fromCollection(args);
        }
        if (term.isCompound()) {
            ArrayList<PrologTerm> args = new ArrayList<PrologTerm>();
            args.add(DotListConversion.asListTerm(term.getArgument(1)));
            String functor = term.getFunctor();
            int arity = term.getArity();
            if (arity >= 2) {
                PrologTerm tail = DotListConversion.asListTerm(term.getArgument(2));
                if (arity == 2 && (".".equals(functor) || "[|]".equals(functor)) && tail.isList()) {
                    args.addAll((ListPrologTerm)tail);
                    return ListPrologTerm.fromCollection(args);
                }
                args.add(tail);
                for (int i = 3; i <= arity; ++i) {
                    args.add(DotListConversion.asListTerm(term.getArgument(i)));
                }
            }
            return CompoundPrologTerm.fromCollection(functor, args);
        }
        return term;
    }

    public static PrologTerm asListTermNonRecursive(PrologTerm term) {
        PrologTerm tail;
        Objects.requireNonNull(term, "term");
        if (term.hasFunctor("[]", 0)) {
            return ListPrologTerm.emptyList();
        }
        if ((term.hasFunctor(".", 2) || term.hasFunctor("[|]", 2)) && (tail = term.getArgument(2)).isList()) {
            ArrayList<PrologTerm> args = new ArrayList<PrologTerm>();
            args.add(term.getArgument(1));
            args.addAll((ListPrologTerm)tail);
            return ListPrologTerm.fromCollection(args);
        }
        return term;
    }

    public static PrologTerm asListConcatTerm(PrologTerm term) {
        return DotListConversion.asListConcatTerm(term, ".");
    }

    public static PrologTerm asListConcatTermSWI(PrologTerm term) {
        return DotListConversion.asListConcatTerm(term, "[|]");
    }

    public static PrologTerm asListConcatTerm(PrologTerm term, String listConcatFunctor) {
        Objects.requireNonNull(term, "term");
        Objects.requireNonNull(listConcatFunctor, "listConcatFunctor");
        if (term.hasFunctor("[]", 0)) {
            return EMPTY_LIST_ATOM;
        }
        if (term.isList()) {
            ListPrologTerm listTerm = (ListPrologTerm)term;
            CompoundPrologTerm dotTerm = EMPTY_LIST_ATOM;
            int len = listTerm.size();
            if (len > 0) {
                for (int i = len - 1; i >= 0; --i) {
                    PrologTerm head = DotListConversion.asListConcatTerm(listTerm.get(i), listConcatFunctor);
                    dotTerm = new CompoundPrologTerm(listConcatFunctor, head, dotTerm);
                }
            }
            return dotTerm;
        }
        if (term.isCompound()) {
            ArrayList<PrologTerm> args = new ArrayList<PrologTerm>();
            int arity = term.getArity();
            for (int i = 1; i <= arity; ++i) {
                args.add(DotListConversion.asListConcatTerm(term.getArgument(i), listConcatFunctor));
            }
            return CompoundPrologTerm.fromCollection(term.getFunctor(), args);
        }
        return term;
    }
}

