/*
 * Decompiled with CFR 0.152.
 */
package de.tlc4b.analysis;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AIntervalExpression;
import de.be4.classicalb.core.parser.node.AUnaryMinusExpression;
import de.be4.classicalb.core.parser.node.Node;
import de.tlc4b.TLC4BGlobals;
import de.tlc4b.analysis.MachineContext;
import de.tlc4b.exceptions.TranslationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DefinitionsAnalyser
extends DepthFirstAdapter {
    private final MachineContext machineContext;
    private final HashMap<Node, Integer> deferredSetSizeTable;

    public Integer getSize(Node node) {
        return this.deferredSetSizeTable.get(node);
    }

    public DefinitionsAnalyser(MachineContext machineContext) {
        this.machineContext = machineContext;
        this.deferredSetSizeTable = new HashMap();
        HashSet<Node> deferredSets = new HashSet<Node>(machineContext.getDeferredSets().values());
        this.findDefaultSizesInDefinitions();
        if (deferredSets.isEmpty()) {
            return;
        }
        Set<String> strings = machineContext.getDeferredSets().keySet();
        for (String string : strings) {
            AExpressionDefinitionDefinition d2;
            String s = "scope_" + string;
            Node node = machineContext.getDefinitions().get(s);
            if (null == node) continue;
            try {
                d2 = (AExpressionDefinitionDefinition)node;
                AIntervalExpression interval = (AIntervalExpression)d2.getRhs();
                AIntegerExpression left = (AIntegerExpression)interval.getLeftBorder();
                AIntegerExpression right = (AIntegerExpression)interval.getRightBorder();
                int l_int = Integer.parseInt(left.getLiteral().getText());
                int r_int = Integer.parseInt(right.getLiteral().getText());
                int size = r_int - l_int + 1;
                this.deferredSetSizeTable.put(machineContext.getDeferredSets().get(string), size);
            }
            catch (ClassCastException d2) {
                // empty catch block
            }
            try {
                d2 = (AExpressionDefinitionDefinition)node;
                AIntegerExpression sizeExpr = (AIntegerExpression)d2.getRhs();
                int size = Integer.parseInt(sizeExpr.getLiteral().getText());
                this.deferredSetSizeTable.put(machineContext.getDeferredSets().get(string), size);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    private void findDefaultSizesInDefinitions() {
        int value;
        AIntegerExpression sizeExpr;
        AExpressionDefinitionDefinition d;
        Node node = this.machineContext.getDefinitions().get("SET_PREF_DEFAULT_SETSIZE");
        if (null != node) {
            try {
                d = (AExpressionDefinitionDefinition)node;
                sizeExpr = (AIntegerExpression)d.getRhs();
                value = Integer.parseInt(sizeExpr.getLiteral().getText());
                TLC4BGlobals.setDEFERRED_SET_SIZE(value);
            }
            catch (ClassCastException e) {
                throw new TranslationException("Unable to determine the default set size from definition SET_PREF_DEFAULT_SETSIZE: " + node.getEndPos(), e);
            }
        }
        if (null != (node = this.machineContext.getDefinitions().get("SET_PREF_MAXINT"))) {
            try {
                d = (AExpressionDefinitionDefinition)node;
                sizeExpr = (AIntegerExpression)d.getRhs();
                value = Integer.parseInt(sizeExpr.getLiteral().getText());
                TLC4BGlobals.setMAX_INT(value);
            }
            catch (ClassCastException e) {
                throw new TranslationException("Unable to determine MAXINT from definition SET_PREF_MAXINT: " + node.getEndPos(), e);
            }
        }
        if (null != (node = this.machineContext.getDefinitions().get("SET_PREF_MININT"))) {
            try {
                d = (AExpressionDefinitionDefinition)node;
                if (d.getRhs() instanceof AUnaryMinusExpression) {
                    AUnaryMinusExpression minus = (AUnaryMinusExpression)d.getRhs();
                    sizeExpr = (AIntegerExpression)minus.getExpression();
                    value = -Integer.parseInt(sizeExpr.getLiteral().getText());
                } else {
                    sizeExpr = (AIntegerExpression)d.getRhs();
                    value = Integer.parseInt(sizeExpr.getLiteral().getText());
                }
                TLC4BGlobals.setMIN_INT(value);
            }
            catch (ClassCastException e) {
                throw new TranslationException("Unable to determine the MININT from definition SET_PREF_MININT: " + node.getEndPos(), e);
            }
        }
    }

    @Override
    public void caseAIdentifierExpression(AIdentifierExpression node) {
        Node ref_node = this.machineContext.getReferences().get(node);
        if (this.deferredSetSizeTable.containsKey(ref_node)) {
            try {
                ACardExpression cardNode = (ACardExpression)node.parent();
                AEqualPredicate equalsNode = (AEqualPredicate)cardNode.parent();
                AIntegerExpression integer = equalsNode.getLeft() == cardNode ? (AIntegerExpression)equalsNode.getRight() : (AIntegerExpression)equalsNode.getLeft();
                String intString = integer.getLiteral().getText();
                this.deferredSetSizeTable.put(ref_node, Integer.parseInt(intString));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

