/*
 * Decompiled with CFR 0.152.
 */
package de.prob.prolog.output;

import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class PrologTermOutput
implements IPrologTermOutput {
    private final Writer out;
    private final boolean useIndentation;
    private int indentLevel = 0;
    private int ignoreIndentationLevel = 0;
    private int termCount = 0;
    private int listCount = 0;
    private boolean commaNeeded = false;
    private boolean lazyParenthesis = false;

    public PrologTermOutput(Writer out, boolean useIndentation) {
        this.out = Objects.requireNonNull(out, "out");
        this.useIndentation = useIndentation;
    }

    public PrologTermOutput(PrintWriter out, boolean useIndentation) {
        this((Writer)out, useIndentation);
    }

    public PrologTermOutput(PrintWriter out) {
        this(out, true);
    }

    public PrologTermOutput(OutputStream out, boolean useIndentation) {
        this(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)), useIndentation);
    }

    public PrologTermOutput(OutputStream out) {
        this(out, true);
    }

    private static boolean isInvalidPrologIdentifierChar(char c) {
        return !(c == '_' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9');
    }

    public static boolean isValidPrologVariable(String name) {
        if (name == null) {
            return false;
        }
        int len = name.length();
        if (len == 0) {
            return false;
        }
        char first = name.charAt(0);
        if (first != '_' && (first > 'Z' || 'A' > first)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (!PrologTermOutput.isInvalidPrologIdentifierChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnquotedPrologAtom(String name) {
        if (name == null) {
            return false;
        }
        int len = name.length();
        if (len == 0) {
            return false;
        }
        char first = name.charAt(0);
        if ('a' > first || first > 'z') {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (!PrologTermOutput.isInvalidPrologIdentifierChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void writeEscapedString(String input) throws IOException {
        int len = input.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\n': {
                    this.out.write(92);
                    this.out.write(110);
                    continue block5;
                }
                case '\"': 
                case '\\': 
                case '`': {
                    this.out.write(92);
                    this.out.write(c);
                    continue block5;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    this.out.write(c);
                    continue block5;
                }
                default: {
                    this.out.write(92);
                    this.out.write(Integer.toOctalString(c));
                    this.out.write(92);
                }
            }
        }
    }

    private void writeEscapedAtom(String input) throws IOException {
        int len = input.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\n': {
                    this.out.write(92);
                    this.out.write(110);
                    continue block5;
                }
                case '\'': 
                case '\\': 
                case '`': {
                    this.out.write(92);
                    this.out.write(c);
                    continue block5;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    this.out.write(c);
                    continue block5;
                }
                default: {
                    this.out.write(92);
                    this.out.write(Integer.toOctalString(c));
                    this.out.write(92);
                }
            }
        }
    }

    private void printIndentation() throws IOException {
        if (this.useIndentation && this.ignoreIndentationLevel == 0) {
            this.out.write(System.lineSeparator());
            int lvl = this.indentLevel;
            for (int i = 0; i < lvl; ++i) {
                this.out.write(32);
            }
        }
    }

    private void printCommaIfNeeded() throws IOException {
        if (this.lazyParenthesis) {
            this.out.write(40);
            this.lazyParenthesis = false;
        }
        if (this.commaNeeded) {
            this.out.write(44);
            this.printIndentation();
        }
    }

    @Override
    public IPrologTermOutput openTerm(String functor, boolean ignoreIndentation) {
        Objects.requireNonNull(functor, "Functor is null");
        ++this.termCount;
        this.printAtom(functor);
        this.lazyParenthesis = true;
        this.commaNeeded = false;
        this.indentLevel += 2;
        if (this.ignoreIndentationLevel > 0) {
            ++this.ignoreIndentationLevel;
        } else if (ignoreIndentation) {
            this.ignoreIndentationLevel = 1;
        }
        return this;
    }

    @Override
    public IPrologTermOutput closeTerm() {
        --this.termCount;
        if (this.termCount < 0) {
            throw new IllegalStateException("Tried to close a term that has not been opened.");
        }
        if (this.lazyParenthesis) {
            this.lazyParenthesis = false;
        } else {
            try {
                this.out.write(41);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }
        this.commaNeeded = true;
        this.indentLevel -= 2;
        if (this.ignoreIndentationLevel > 0) {
            --this.ignoreIndentationLevel;
        }
        return this;
    }

    @Override
    public IPrologTermOutput printAtom(String content) {
        Objects.requireNonNull(content, "Atom value is null");
        try {
            this.printCommaIfNeeded();
            if (PrologTermOutput.isUnquotedPrologAtom(content)) {
                this.out.write(content);
            } else {
                this.out.write(39);
                this.writeEscapedAtom(content);
                this.out.write(39);
            }
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = true;
        return this;
    }

    @Override
    public IPrologTermOutput printString(String content) {
        Objects.requireNonNull(content, "String value is null");
        try {
            this.printCommaIfNeeded();
            this.out.write(34);
            this.writeEscapedString(content);
            this.out.write(34);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = true;
        return this;
    }

    @Override
    public IPrologTermOutput printNumber(long number) {
        try {
            this.printCommaIfNeeded();
            this.out.write(Long.toString(number));
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = true;
        return this;
    }

    @Override
    public IPrologTermOutput printNumber(BigInteger number) {
        Objects.requireNonNull(number, "Number is null");
        try {
            this.printCommaIfNeeded();
            this.out.write(number.toString());
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = true;
        return this;
    }

    @Override
    public IPrologTermOutput printNumber(double number) {
        try {
            this.printCommaIfNeeded();
            this.out.write(Double.toString(number));
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = true;
        return this;
    }

    @Override
    public IPrologTermOutput openList() {
        ++this.listCount;
        try {
            this.printCommaIfNeeded();
            this.out.write(91);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = false;
        ++this.indentLevel;
        return this;
    }

    @Override
    public IPrologTermOutput closeList() {
        --this.listCount;
        if (this.listCount < 0) {
            throw new IllegalStateException("Tried to close a list that has not been opened.");
        }
        try {
            this.out.write(93);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = true;
        --this.indentLevel;
        return this;
    }

    @Override
    public IPrologTermOutput tailSeparator() {
        try {
            this.out.write(124);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = false;
        return this;
    }

    @Override
    public IPrologTermOutput printVariable(String var) {
        Objects.requireNonNull(var, "Variable name is null");
        if (!PrologTermOutput.isValidPrologVariable(var)) {
            throw new IllegalArgumentException("Invalid name for Prolog variable '" + var + "'");
        }
        try {
            this.printCommaIfNeeded();
            this.out.write(var);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = true;
        return this;
    }

    @Override
    public IPrologTermOutput flush() {
        try {
            this.out.flush();
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        return this;
    }

    @Override
    public IPrologTermOutput fullstop() {
        if (this.listCount != 0) {
            throw new IllegalStateException("Number of openList and closeList do not match. openList Counter is " + this.listCount);
        }
        if (this.termCount != 0) {
            throw new IllegalStateException("Number of openTerm and closeTerm do not match. openTerm Counter is " + this.termCount);
        }
        try {
            this.out.write(46);
            this.out.write(System.lineSeparator());
            this.out.flush();
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.commaNeeded = false;
        return this;
    }

    @Override
    public IPrologTermOutput printTerm(PrologTerm term) {
        term.toTermOutput(this);
        return this;
    }
}

