/*
 * Decompiled with CFR 0.152.
 */
package de.be4.ltl.core.parser.internal;

import de.be4.ltl.core.parser.internal.PrologGeneratorHelper;
import de.be4.ltl.core.parser.internal.UniversalToken;
import de.be4.ltl.core.pctlparser.analysis.DepthFirstAdapter;
import de.be4.ltl.core.pctlparser.node.ACurrentPctlState;
import de.be4.ltl.core.pctlparser.node.ADeadlockPctlState;
import de.be4.ltl.core.pctlparser.node.ADetOutputPctlState;
import de.be4.ltl.core.pctlparser.node.ADigitExpression;
import de.be4.ltl.core.pctlparser.node.AErrorPctlState;
import de.be4.ltl.core.pctlparser.node.AGoalPctlState;
import de.be4.ltl.core.pctlparser.node.ANonDetPctlState;
import de.be4.ltl.core.pctlparser.node.AProbFormulaPctlState;
import de.be4.ltl.core.pctlparser.node.ASinkPctlState;
import de.be4.ltl.core.pctlparser.node.AUnparsedPctlState;
import de.be4.ltl.core.pctlparser.node.Node;
import de.be4.ltl.core.pctlparser.node.Start;
import de.be4.ltl.core.pctlparser.node.TAtomicPropositionBegin;
import de.prob.parserbase.ProBParserBase;
import de.prob.prolog.output.IPrologTermOutput;

public class PrologPctlGenerator
extends DepthFirstAdapter {
    private final IPrologTermOutput p;
    private final PrologGeneratorHelper helper;

    public PrologPctlGenerator(IPrologTermOutput pto, String currentStateID, ProBParserBase specParser) {
        this.p = pto;
        this.helper = new PrologGeneratorHelper(pto, currentStateID, specParser);
    }

    @Override
    public void defaultOut(Node node) {
        this.helper.defaultOut();
    }

    @Override
    public void defaultIn(Node node) {
        this.helper.defaultIn(node.getClass());
    }

    @Override
    public void caseAUnparsedPctlState(AUnparsedPctlState node) {
        TAtomicPropositionBegin token = node.getPredicate();
        this.helper.caseUnparsed(UniversalToken.createToken(token));
    }

    @Override
    public void caseADigitExpression(ADigitExpression node) {
        int n = Integer.parseInt(node.getNumber().getText());
        this.p.printNumber(n);
    }

    @Override
    public void caseAProbFormulaPctlState(AProbFormulaPctlState node) {
        this.inAProbFormulaPctlState(node);
        if (node.getOp() != null) {
            node.getOp().apply(this);
        }
        TAtomicPropositionBegin token = node.getProbability();
        this.helper.caseUnparsedExpression(UniversalToken.createToken(token), false);
        if (node.getCont() != null) {
            node.getCont().apply(this);
        }
        this.outAProbFormulaPctlState(node);
    }

    @Override
    public void caseASinkPctlState(ASinkPctlState node) {
        this.helper.sink();
    }

    @Override
    public void caseAGoalPctlState(AGoalPctlState node) {
        this.helper.goal();
    }

    @Override
    public void caseADetOutputPctlState(ADetOutputPctlState node) {
        this.helper.detOutput();
    }

    @Override
    public void caseANonDetPctlState(ANonDetPctlState node) {
        this.helper.nonDet();
    }

    @Override
    public void caseAErrorPctlState(AErrorPctlState node) {
        this.helper.stateError();
    }

    @Override
    public void caseADeadlockPctlState(ADeadlockPctlState node) {
        this.helper.deadlock();
    }

    @Override
    public void caseACurrentPctlState(ACurrentPctlState node) {
        this.helper.current();
    }

    @Override
    public void inStart(Start node) {
    }

    @Override
    public void outStart(Start node) {
    }
}

