/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.rules;

import de.be4.classicalb.core.parser.analysis.DepthFirstAdapter;
import de.be4.classicalb.core.parser.node.AAbstractConstantsMachineClause;
import de.be4.classicalb.core.parser.node.AAbstractMachineParseUnit;
import de.be4.classicalb.core.parser.node.AAssertionsMachineClause;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConstantsMachineClause;
import de.be4.classicalb.core.parser.node.ADefinitionsMachineClause;
import de.be4.classicalb.core.parser.node.AExpressionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AFreetypesMachineClause;
import de.be4.classicalb.core.parser.node.AInitialisationMachineClause;
import de.be4.classicalb.core.parser.node.AInvariantMachineClause;
import de.be4.classicalb.core.parser.node.AOperationsMachineClause;
import de.be4.classicalb.core.parser.node.APredicateDefinitionDefinition;
import de.be4.classicalb.core.parser.node.APropertiesMachineClause;
import de.be4.classicalb.core.parser.node.ASequenceSubstitution;
import de.be4.classicalb.core.parser.node.ASetsMachineClause;
import de.be4.classicalb.core.parser.node.ASubstitutionDefinitionDefinition;
import de.be4.classicalb.core.parser.node.AVariablesMachineClause;
import de.be4.classicalb.core.parser.node.PDefinition;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PFreetype;
import de.be4.classicalb.core.parser.node.PMachineClause;
import de.be4.classicalb.core.parser.node.PSet;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.Start;
import de.be4.classicalb.core.parser.node.TDefLiteralPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class MachineInjector
extends DepthFirstAdapter {
    AAbstractMachineParseUnit abstractMachineParseUnit;
    List<PMachineClause> clausesList;
    AAbstractConstantsMachineClause abstractConstantsClause;
    ASetsMachineClause setsClause;
    AFreetypesMachineClause freetypesClause;
    AConstantsMachineClause constantsClause;
    APropertiesMachineClause propertiesClause;
    AVariablesMachineClause variablesClause;
    AInvariantMachineClause invariantClause;
    AAssertionsMachineClause assertionsClause;
    AInitialisationMachineClause initialisationClause;
    AOperationsMachineClause operationClause;
    ADefinitionsMachineClause definitionsClause;
    final HashSet<String> definitionNames = new HashSet();
    private APredicateDefinitionDefinition goalDefinition;
    private List<PDefinition> mainMachineDefinitions;

    public MachineInjector(Start start) {
        start.apply(this);
    }

    public void injectMachine(Start otherMachine) {
        ClauseFinder finder = new ClauseFinder();
        otherMachine.apply(finder);
    }

    public APredicateDefinitionDefinition getGoalDefinition() {
        return this.goalDefinition;
    }

    public List<PDefinition> getMainMachineDefinitions() {
        return this.mainMachineDefinitions;
    }

    @Override
    public void inAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
        this.abstractMachineParseUnit = node;
        this.clausesList = node.getMachineClauses();
    }

    @Override
    public void inASetsMachineClause(ASetsMachineClause node) {
        this.setsClause = node;
    }

    @Override
    public void inAFreetypesMachineClause(AFreetypesMachineClause node) {
        this.freetypesClause = node;
    }

    @Override
    public void inAAbstractConstantsMachineClause(AAbstractConstantsMachineClause node) {
        this.abstractConstantsClause = node;
    }

    @Override
    public void inAConstantsMachineClause(AConstantsMachineClause node) {
        this.constantsClause = node;
    }

    @Override
    public void inAPropertiesMachineClause(APropertiesMachineClause node) {
        this.propertiesClause = node;
    }

    @Override
    public void inADefinitionsMachineClause(ADefinitionsMachineClause node) {
        this.definitionsClause = node;
    }

    @Override
    public void inAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
        this.definitionNames.add(node.getName().getText());
    }

    @Override
    public void inASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
        this.definitionNames.add(node.getName().getText());
    }

    @Override
    public void inAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
        this.definitionNames.add(node.getName().getText());
    }

    @Override
    public void caseAVariablesMachineClause(AVariablesMachineClause node) {
        this.variablesClause = node;
    }

    @Override
    public void caseAInvariantMachineClause(AInvariantMachineClause node) {
        this.invariantClause = node;
    }

    @Override
    public void caseAAssertionsMachineClause(AAssertionsMachineClause node) {
        this.assertionsClause = node;
    }

    @Override
    public void caseAInitialisationMachineClause(AInitialisationMachineClause node) {
        this.initialisationClause = node;
    }

    @Override
    public void caseAOperationsMachineClause(AOperationsMachineClause node) {
        this.operationClause = node;
    }

    class ClauseFinder
    extends DepthFirstAdapter {
        ClauseFinder() {
        }

        @Override
        public void outAAbstractMachineParseUnit(AAbstractMachineParseUnit node) {
            node.setMachineClauses(Collections.emptyList());
        }

        @Override
        public void inASetsMachineClause(ASetsMachineClause node) {
            if (MachineInjector.this.setsClause == null) {
                MachineInjector.this.setsClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                LinkedList<PSet> sets = MachineInjector.this.setsClause.getSetDefinitions();
                sets.addAll(node.getSetDefinitions());
            }
        }

        @Override
        public void inAFreetypesMachineClause(AFreetypesMachineClause node) {
            if (MachineInjector.this.freetypesClause == null) {
                MachineInjector.this.freetypesClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                LinkedList<PFreetype> freetypes = MachineInjector.this.freetypesClause.getFreetypes();
                freetypes.addAll(node.getFreetypes());
            }
        }

        @Override
        public void inAConstantsMachineClause(AConstantsMachineClause node) {
            if (MachineInjector.this.constantsClause == null) {
                MachineInjector.this.constantsClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                LinkedList<PExpression> identifiers = MachineInjector.this.constantsClause.getIdentifiers();
                identifiers.addAll(node.getIdentifiers());
            }
        }

        @Override
        public void inAAbstractConstantsMachineClause(AAbstractConstantsMachineClause node) {
            if (MachineInjector.this.abstractConstantsClause == null) {
                MachineInjector.this.abstractConstantsClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                LinkedList<PExpression> identifiers = MachineInjector.this.abstractConstantsClause.getIdentifiers();
                identifiers.addAll(node.getIdentifiers());
            }
        }

        @Override
        public void inAPropertiesMachineClause(APropertiesMachineClause node) {
            if (MachineInjector.this.propertiesClause == null) {
                MachineInjector.this.propertiesClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                AConjunctPredicate con = new AConjunctPredicate(MachineInjector.this.propertiesClause.getPredicates(), node.getPredicates());
                MachineInjector.this.propertiesClause.setPredicates(con);
            }
        }

        @Override
        public void inAVariablesMachineClause(AVariablesMachineClause node) {
            if (MachineInjector.this.variablesClause == null) {
                MachineInjector.this.variablesClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                LinkedList<PExpression> identifiers = MachineInjector.this.variablesClause.getIdentifiers();
                identifiers.addAll(node.getIdentifiers());
            }
            MachineInjector.this.variablesClause.getIdentifiers().sort(Comparator.comparing(Object::toString));
        }

        @Override
        public void inAInvariantMachineClause(AInvariantMachineClause node) {
            if (MachineInjector.this.invariantClause == null) {
                MachineInjector.this.invariantClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                AConjunctPredicate con = new AConjunctPredicate(MachineInjector.this.invariantClause.getPredicates(), node.getPredicates());
                MachineInjector.this.invariantClause.setPredicates(con);
            }
        }

        @Override
        public void inAAssertionsMachineClause(AAssertionsMachineClause node) {
            if (MachineInjector.this.assertionsClause == null) {
                MachineInjector.this.assertionsClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                MachineInjector.this.assertionsClause.getPredicates().addAll(node.getPredicates());
            }
        }

        @Override
        public void inAInitialisationMachineClause(AInitialisationMachineClause node) {
            if (MachineInjector.this.initialisationClause == null) {
                MachineInjector.this.initialisationClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                ArrayList<PSubstitution> list = new ArrayList<PSubstitution>();
                list.add(MachineInjector.this.initialisationClause.getSubstitutions());
                list.add(node.getSubstitutions());
                ASequenceSubstitution seq = new ASequenceSubstitution(list);
                MachineInjector.this.initialisationClause.setSubstitutions(seq);
            }
        }

        @Override
        public void inAOperationsMachineClause(AOperationsMachineClause node) {
            if (MachineInjector.this.operationClause == null) {
                MachineInjector.this.operationClause = node;
                MachineInjector.this.clausesList.add(node);
            } else {
                MachineInjector.this.operationClause.getOperations().addAll(0, node.getOperations());
            }
        }

        @Override
        public void caseADefinitionsMachineClause(ADefinitionsMachineClause node) {
            if (MachineInjector.this.definitionsClause == null) {
                MachineInjector.this.definitionsClause = new ADefinitionsMachineClause(new ArrayList<PDefinition>());
                MachineInjector.this.clausesList.add(MachineInjector.this.definitionsClause);
            }
            boolean first = false;
            if (MachineInjector.this.mainMachineDefinitions == null) {
                first = true;
                MachineInjector.this.mainMachineDefinitions = new ArrayList();
            }
            for (PDefinition def : node.getDefinitions()) {
                TDefLiteralPredicate name;
                def.apply(this);
                if (def instanceof APredicateDefinitionDefinition && MachineInjector.this.goalDefinition == null && "GOAL".equals((name = ((APredicateDefinitionDefinition)def).getName()).getText())) {
                    MachineInjector.this.goalDefinition = (APredicateDefinitionDefinition)def;
                }
                if (!first) continue;
                MachineInjector.this.mainMachineDefinitions.add(def);
            }
        }

        @Override
        public void inAPredicateDefinitionDefinition(APredicateDefinitionDefinition node) {
            String name = node.getName().getText();
            if (!MachineInjector.this.definitionNames.contains(name)) {
                MachineInjector.this.definitionNames.add(name);
                MachineInjector.this.definitionsClause.getDefinitions().add(node);
            }
        }

        @Override
        public void inASubstitutionDefinitionDefinition(ASubstitutionDefinitionDefinition node) {
            String name = node.getName().getText();
            if (!MachineInjector.this.definitionNames.contains(name)) {
                MachineInjector.this.definitionNames.add(name);
                MachineInjector.this.definitionsClause.getDefinitions().add(node);
            }
        }

        @Override
        public void inAExpressionDefinitionDefinition(AExpressionDefinitionDefinition node) {
            String name = node.getName().getText();
            if (!MachineInjector.this.definitionNames.contains(name)) {
                MachineInjector.this.definitionNames.add(name);
                MachineInjector.this.definitionsClause.getDefinitions().add(node);
            }
        }
    }
}

