/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.prolog;

import de.be4.classicalb.core.parser.analysis.prolog.INodeIds;
import de.be4.classicalb.core.parser.analysis.prolog.PositionPrinter;
import de.be4.classicalb.core.parser.node.AIfElsifSubstitution;
import de.be4.classicalb.core.parser.node.ASelectWhenSubstitution;
import de.be4.classicalb.core.parser.node.Node;
import de.prob.prolog.output.IPrologTermOutput;

public class ClassicalPositionPrinter
implements PositionPrinter {
    private IPrologTermOutput pout;
    private final INodeIds nodeIds;
    private boolean printSourcePositions = false;
    private boolean compactPositions = false;
    private int lineOffset = 0;
    private int columnOffset = 0;
    private static final int NO_LINE_OR_COLUMN_VALUE = 0;

    public ClassicalPositionPrinter(INodeIds nodeIds) {
        this.nodeIds = nodeIds;
    }

    public void setPrintSourcePositions(boolean b, boolean compact) {
        this.printSourcePositions = b;
        this.compactPositions = compact;
    }

    private static boolean uselessPositionInfo(Node node) {
        if (node instanceof AIfElsifSubstitution) {
            return true;
        }
        return node instanceof ASelectWhenSubstitution;
    }

    @Override
    public void printPosition(Node node) {
        this.printPositionRange(node, node);
    }

    @Override
    public void printPositionRange(Node startNode, Node endNode) {
        if (!this.printSourcePositions || ClassicalPositionPrinter.uselessPositionInfo(startNode)) {
            this.pout.printAtom("none");
        } else {
            int fileNr = this.nodeIds.lookupFileNumber(startNode);
            if (fileNr == -1 && startNode.getStartPos() == null && endNode.getEndPos() == null) {
                this.pout.printAtom("none");
                return;
            }
            int startLine = this.getStartLine(startNode);
            int endLine = this.getEndLine(endNode);
            if (!this.compactPositions) {
                this.pout.openTerm("pos", true);
                this.pout.printNumber(-1L);
                this.pout.printNumber(fileNr);
                this.pout.printNumber(startLine);
                this.pout.printNumber(this.getStartColumn(startNode));
                this.pout.printNumber(endLine);
            } else if (fileNr == 1 && startLine == endLine) {
                this.pout.openTerm("p3", true);
                this.pout.printNumber(startLine);
                this.pout.printNumber(this.getStartColumn(startNode));
            } else if (startLine == endLine) {
                this.pout.openTerm("p4", true);
                this.pout.printNumber(fileNr);
                this.pout.printNumber(startLine);
                this.pout.printNumber(this.getStartColumn(startNode));
            } else {
                this.pout.openTerm("p5", true);
                this.pout.printNumber(fileNr);
                this.pout.printNumber(startLine);
                this.pout.printNumber(this.getStartColumn(startNode));
                this.pout.printNumber(endLine);
            }
            this.pout.printNumber(this.getEndColumn(endNode));
            this.pout.closeTerm();
        }
    }

    private int getStartLine(Node node) {
        if (node.getStartPos() != null) {
            return node.getStartPos().getLine() + this.lineOffset;
        }
        return 0;
    }

    private int getStartColumn(Node node) {
        if (node.getStartPos() != null) {
            return node.getStartPos().getPos() + this.columnOffset;
        }
        return 0;
    }

    private int getEndLine(Node node) {
        if (node.getEndPos() != null) {
            return node.getEndPos().getLine() + this.lineOffset;
        }
        return 0;
    }

    private int getEndColumn(Node node) {
        if (node.getEndPos() != null) {
            return node.getEndPos().getPos() + this.columnOffset;
        }
        return 0;
    }

    @Override
    public void setPrologTermOutput(IPrologTermOutput pout) {
        this.pout = pout;
    }
}

