/*
 * Decompiled with CFR 0.152.
 */
package de.be4.classicalb.core.parser.analysis.checking;

import de.be4.classicalb.core.parser.analysis.MachineClauseAdapter;
import de.be4.classicalb.core.parser.analysis.checking.SemanticCheck;
import de.be4.classicalb.core.parser.exceptions.CheckException;
import de.be4.classicalb.core.parser.node.ALocalOperationsMachineClause;
import de.be4.classicalb.core.parser.node.AOperationsMachineClause;
import de.be4.classicalb.core.parser.node.ARefinedOperation;
import de.be4.classicalb.core.parser.node.POperation;
import de.be4.classicalb.core.parser.node.Start;
import java.util.ArrayList;
import java.util.List;

public class RefinedOperationCheck
extends MachineClauseAdapter
implements SemanticCheck {
    private final List<CheckException> exceptions = new ArrayList<CheckException>();

    @Override
    public void runChecks(Start rootNode) {
        rootNode.apply(this);
    }

    @Override
    public List<CheckException> getCheckExceptions() {
        return this.exceptions;
    }

    private void checkRefKeywords(List<POperation> operations) {
        for (POperation operation : operations) {
            ARefinedOperation node;
            if (!(operation instanceof ARefinedOperation) || (node = (ARefinedOperation)operation).getRefKw().getText().equals("ref")) continue;
            this.exceptions.add(new CheckException("Expect 'ref' key word in operation definition.", node.getRefKw()));
        }
    }

    @Override
    public void caseAOperationsMachineClause(AOperationsMachineClause node) {
        this.checkRefKeywords(node.getOperations());
    }

    @Override
    public void caseALocalOperationsMachineClause(ALocalOperationsMachineClause node) {
        this.checkRefKeywords(node.getOperations());
    }
}

