/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.be4.ltl.core.ctlparser.parser;

import de.be4.ltl.core.ctlparser.lexer.*;
import de.be4.ltl.core.ctlparser.node.*;
import de.be4.ltl.core.ctlparser.analysis.*;
import java.util.*;
import de.hhu.stups.sablecc.patch.*;


import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings({"rawtypes","unchecked","unused"})
public class Parser implements IParser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;
    
    private ArrayList firstPopped = null;
    private ArrayList lastPopped = null;
    private ITokenListContainer lex;

    public Parser(  Lexer lexer)
    {
        this.lexer = lexer;
        this.lex = lexer; 
    }
    
     
    private Map<PositionedNode, SourcecodeRange> mapping = new HashMap<PositionedNode, SourcecodeRange>();    
    public Map<PositionedNode, SourcecodeRange> getMapping() { 	return this.mapping; }

   private void checkResult(Object elementToCheck) {
       checkResult(elementToCheck, false);
   }

	 
	private void checkResult(Object elementToCheck, boolean slurp) {
		// nodes with no tokens or sub nodes at all may exist
		if (this.firstPopped == null) {
			return;
		}

		if (elementToCheck instanceof LinkedList) {
			/*
			 * special case: this is a list of nodes, for example an identifier
			 * list, so we don't want to check the list but the last element
			 * added to it
			 */
			final LinkedList nodeList = (LinkedList) elementToCheck;

			if (nodeList.size() > 0) {
				elementToCheck = nodeList.get(nodeList.size() - 1);
			} else {
				// no positions for empty lists...
				return;
			}
		}

		if (!(elementToCheck instanceof PositionedNode)) {
			throw new Error(
					"Unexpected elementToCheck (not instanceof PositionedNode): "
							+ elementToCheck.getClass().getSimpleName() + "/"
							+ elementToCheck);
		}

		if (!this.getMapping().containsKey(elementToCheck) || slurp ) {
			final PositionedNode node = (PositionedNode) elementToCheck;

			// dealing with a one-token element
			if (this.lastPopped == null) {
				this.lastPopped = this.firstPopped;
			}

			final int begin = findBeginPos(this.lastPopped, node);
			int end = findEndPos(this.firstPopped);
			if (end == -1) end = begin;
			final SourcecodeRange range = new SourcecodeRange(begin, end);

			this.getMapping().put(node, range);

			node.setStartPos(createBeginPos(begin));
			node.setEndPos(createEndPos(end));
		}
	}
	
	 
	private int findBeginPos(final ArrayList list,
			PositionedNode n) {
		Object first = list.get(0);
		if (!(first instanceof PositionedNode) && !(first instanceof IToken)) {
			List list2 = (List) first;

			if (list2.size() > 0) {
				first = list2.get(0);
			} else {
				/*
				 * Sometimes (haven't found out why) we get empty list here. In
				 * the only observed cases we were looking for the source range
				 * of the whole parse unit. Then the index is 0.
				 */
				return 0;
			}
		}

		if (first instanceof IToken) {
			return findIndex((IToken) first);
		}

		final PositionedNode node = (PositionedNode) first;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null){
			System.err.println(n.getClass().getSimpleName() + " / " + node.getClass().getSimpleName() + ": " + node);
		}
		return item.getBeginIndex();
	}

	 
	private int findEndPos(final ArrayList list) {
		Object last = list.get(list.size() - 1);
		if (!(last instanceof PositionedNode) && !(last instanceof IToken)) {
			final List list2 = (List) last;
			last = list2.get(list2.size() - 1);
		}

		if (last instanceof IToken) {
			return findIndex((IToken) last);
		}

		final PositionedNode node = (PositionedNode) last;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null)
			return -1;
		return item.getEndIndex();
	}

	private int findIndex(final IToken token) {
		final List<IToken> list = this.lex.getTokenList();

		for (int i = list.size() - 1; i >= 0; i--) {
			if (list.get(i) == token) {
				return i;
			}
		}

		return -1;
	}

	private SourcePosition createBeginPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos());
	}

	private SourcePosition createEndPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos()
				+ token.getText().length());
	}
	     
    private void push(int numstate, ArrayList listNode) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
    	ArrayList list = ((State) this.stack.previous()).nodes; 
		if (this.firstPopped == null) {
			this.firstPopped = list;
		} else {
			this.lastPopped = list;
		}
        return list;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

     
    public Start parse() throws ParserException, LexerException, IOException
    {
    	this.getMapping().clear();
    
        push(0, null);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce AImplicationCtlFormula */
		    {
			ArrayList list = new0();
			push(goTo(0), list);
		    }
		    break;
                    case 1: /* reduce ACtlFormula */
		    {
			ArrayList list = new1();
			push(goTo(0), list);
		    }
		    break;
                    case 2: /* reduce AAndCtlFormula2 */
		    {
			ArrayList list = new2();
			push(goTo(1), list);
		    }
		    break;
                    case 3: /* reduce AOrCtlFormula2 */
		    {
			ArrayList list = new3();
			push(goTo(1), list);
		    }
		    break;
                    case 4: /* reduce ACtlFormula2 */
		    {
			ArrayList list = new4();
			push(goTo(1), list);
		    }
		    break;
                    case 5: /* reduce AEuCtlFormula3 */
		    {
			ArrayList list = new5();
			push(goTo(2), list);
		    }
		    break;
                    case 6: /* reduce ACtlFormula3 */
		    {
			ArrayList list = new6();
			push(goTo(2), list);
		    }
		    break;
                    case 7: /* reduce ANotCtlFormula4 */
		    {
			ArrayList list = new7();
			push(goTo(3), list);
		    }
		    break;
                    case 8: /* reduce AParCtlFormula4 */
		    {
			ArrayList list = new8();
			push(goTo(3), list);
		    }
		    break;
                    case 9: /* reduce ATrueCtlFormula4 */
		    {
			ArrayList list = new9();
			push(goTo(3), list);
		    }
		    break;
                    case 10: /* reduce AFalseCtlFormula4 */
		    {
			ArrayList list = new10();
			push(goTo(3), list);
		    }
		    break;
                    case 11: /* reduce AEnaCtlFormula4 */
		    {
			ArrayList list = new11();
			push(goTo(3), list);
		    }
		    break;
                    case 12: /* reduce AEnCtlFormula4 */
		    {
			ArrayList list = new12();
			push(goTo(3), list);
		    }
		    break;
                    case 13: /* reduce AAnCtlFormula4 */
		    {
			ArrayList list = new13();
			push(goTo(3), list);
		    }
		    break;
                    case 14: /* reduce AEgCtlFormula4 */
		    {
			ArrayList list = new14();
			push(goTo(3), list);
		    }
		    break;
                    case 15: /* reduce AEfCtlFormula4 */
		    {
			ArrayList list = new15();
			push(goTo(3), list);
		    }
		    break;
                    case 16: /* reduce AAgCtlFormula4 */
		    {
			ArrayList list = new16();
			push(goTo(3), list);
		    }
		    break;
                    case 17: /* reduce AAfCtlFormula4 */
		    {
			ArrayList list = new17();
			push(goTo(3), list);
		    }
		    break;
                    case 18: /* reduce AUnparsedCtlFormula4 */
		    {
			ArrayList list = new18();
			push(goTo(3), list);
		    }
		    break;
                    case 19: /* reduce AEnabledCtlFormula4 */
		    {
			ArrayList list = new19();
			push(goTo(3), list);
		    }
		    break;
                    case 20: /* reduce AActionCtlFormula4 */
		    {
			ArrayList list = new20();
			push(goTo(3), list);
		    }
		    break;
                    case 21: /* reduce ASinkCtlFormula4 */
		    {
			ArrayList list = new21();
			push(goTo(3), list);
		    }
		    break;
                    case 22: /* reduce ADeadlockCtlFormula4 */
		    {
			ArrayList list = new22();
			push(goTo(3), list);
		    }
		    break;
                    case 23: /* reduce ACurrentCtlFormula4 */
		    {
			ArrayList list = new23();
			push(goTo(3), list);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PCtl node1 = (PCtl) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " ,
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



     
    ArrayList new0() /* reduce AImplicationCtlFormula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        PCtl pctlNode3;
        pctlNode2 = (PCtl)nodeArrayList1.get(0);
        pctlNode3 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AImpliesCtl(pctlNode2, pctlNode3);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new1() /* reduce ACtlFormula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        pctlNode1 = (PCtl)nodeArrayList1.get(0);
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new2() /* reduce AAndCtlFormula2 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        PCtl pctlNode3;
        pctlNode2 = (PCtl)nodeArrayList1.get(0);
        pctlNode3 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AAndCtl(pctlNode2, pctlNode3);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new3() /* reduce AOrCtlFormula2 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        PCtl pctlNode3;
        pctlNode2 = (PCtl)nodeArrayList1.get(0);
        pctlNode3 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AOrCtl(pctlNode2, pctlNode3);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new4() /* reduce ACtlFormula2 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        pctlNode1 = (PCtl)nodeArrayList1.get(0);
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new5() /* reduce AEuCtlFormula3 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        PCtl pctlNode3;
        pctlNode2 = (PCtl)nodeArrayList2.get(0);
        pctlNode3 = (PCtl)nodeArrayList4.get(0);

        pctlNode1 = new AEuCtl(pctlNode2, pctlNode3);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new6() /* reduce ACtlFormula3 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        pctlNode1 = (PCtl)nodeArrayList1.get(0);
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new7() /* reduce ANotCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        pctlNode2 = (PCtl)nodeArrayList2.get(0);

        pctlNode1 = new ANotCtl(pctlNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new8() /* reduce AParCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        pctlNode1 = (PCtl)nodeArrayList2.get(0);
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new9() /* reduce ATrueCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block

        pctlNode1 = new ATrueCtl();
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new10() /* reduce AFalseCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block

        pctlNode1 = new AFalseCtl();
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new11() /* reduce AEnaCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        TLSq tlsqNode2;
        PCtl pctlNode3;
        tlsqNode2 = (TLSq)nodeArrayList3.get(0);
        pctlNode3 = (PCtl)nodeArrayList4.get(0);

        pctlNode1 = new AEnaCtl(tlsqNode2, pctlNode3);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new12() /* reduce AEnCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        pctlNode2 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AEnCtl(pctlNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new13() /* reduce AAnCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        pctlNode2 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AAnCtl(pctlNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new14() /* reduce AEgCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        pctlNode2 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AEgCtl(pctlNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new15() /* reduce AEfCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        pctlNode2 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AEfCtl(pctlNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new16() /* reduce AAgCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        pctlNode2 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AAgCtl(pctlNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new17() /* reduce AAfCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        PCtl pctlNode2;
        pctlNode2 = (PCtl)nodeArrayList3.get(0);

        pctlNode1 = new AAfCtl(pctlNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new18() /* reduce AUnparsedCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        TAtomicPropositionBegin tatomicpropositionbeginNode2;
        tatomicpropositionbeginNode2 = (TAtomicPropositionBegin)nodeArrayList1.get(0);

        pctlNode1 = new AUnparsedCtl(tatomicpropositionbeginNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new19() /* reduce AEnabledCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        TEnabled tenabledNode2;
        tenabledNode2 = (TEnabled)nodeArrayList1.get(0);

        pctlNode1 = new AEnabledCtl(tenabledNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new20() /* reduce AActionCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block
        TLSq tlsqNode2;
        tlsqNode2 = (TLSq)nodeArrayList1.get(0);

        pctlNode1 = new AActionCtl(tlsqNode2);
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new21() /* reduce ASinkCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block

        pctlNode1 = new ASinkCtl();
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new22() /* reduce ADeadlockCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block

        pctlNode1 = new ADeadlockCtl();
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new23() /* reduce ACurrentCtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PCtl pctlNode1;
        {
            // Block

        pctlNode1 = new ACurrentCtl();
        }
	nodeList.add(pctlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 11}, {20, SHIFT, 12}, },
			{{-1, REDUCE, 9}, },
			{{-1, REDUCE, 10}, },
			{{-1, REDUCE, 21}, },
			{{-1, REDUCE, 22}, },
			{{-1, REDUCE, 23}, },
			{{-1, ERROR, 6}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 11}, {20, SHIFT, 12}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 19}, },
			{{-1, REDUCE, 18}, },
			{{-1, ERROR, 10}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, ERROR, 11}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 11}, {20, SHIFT, 12}, {22, SHIFT, 20}, {23, SHIFT, 21}, {24, SHIFT, 22}, },
			{{-1, ERROR, 12}, {22, SHIFT, 24}, {23, SHIFT, 25}, {24, SHIFT, 26}, },
			{{-1, ERROR, 13}, {15, SHIFT, 27}, {25, ACCEPT, -1}, },
			{{-1, REDUCE, 1}, {16, SHIFT, 28}, {17, SHIFT, 29}, },
			{{-1, REDUCE, 4}, },
			{{-1, REDUCE, 6}, },
			{{-1, ERROR, 17}, {6, SHIFT, 30}, {15, SHIFT, 27}, },
			{{-1, ERROR, 18}, {22, SHIFT, 20}, {23, SHIFT, 21}, {24, SHIFT, 22}, },
			{{-1, REDUCE, 7}, },
			{{-1, ERROR, 20}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, ERROR, 21}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, ERROR, 22}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 33}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, ERROR, 23}, {21, SHIFT, 35}, },
			{{-1, ERROR, 24}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, ERROR, 25}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, ERROR, 26}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, ERROR, 27}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 11}, {20, SHIFT, 12}, },
			{{-1, ERROR, 28}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 11}, {20, SHIFT, 12}, },
			{{-1, ERROR, 29}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 11}, {20, SHIFT, 12}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 14}, },
			{{-1, REDUCE, 15}, },
			{{-1, REDUCE, 20}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, REDUCE, 12}, },
			{{-1, ERROR, 35}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {7, SHIFT, 7}, {8, SHIFT, 8}, {9, SHIFT, 9}, {18, SHIFT, 10}, {19, SHIFT, 18}, {20, SHIFT, 12}, },
			{{-1, REDUCE, 16}, },
			{{-1, REDUCE, 17}, },
			{{-1, REDUCE, 13}, },
			{{-1, REDUCE, 0}, {16, SHIFT, 28}, {17, SHIFT, 29}, },
			{{-1, REDUCE, 2}, },
			{{-1, REDUCE, 3}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 5}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 13}, {6, 17}, },
			{{-1, 14}, {27, 39}, },
			{{-1, 15}, {11, 23}, {28, 40}, {29, 41}, },
			{{-1, 16}, {10, 19}, {20, 31}, {21, 32}, {22, 34}, {24, 36}, {25, 37}, {26, 38}, {33, 42}, {35, 43}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: 'true', 'false', 'sink', 'deadlock', 'current', l par, l sq, enabled, atomic proposition begin, 'not', 'E', 'A'",
			"expecting: r par, '=>', '&', 'or', 'U', EOF",
			"expecting: 'true', 'false', 'sink', 'deadlock', 'current', l par, l sq, enabled, atomic proposition begin, 'not', 'E', 'A', 'G', 'F', 'X'",
			"expecting: 'G', 'F', 'X'",
			"expecting: '=>', EOF",
			"expecting: r par, '=>', '&', 'or', EOF",
			"expecting: r par, '=>'",
			"expecting: 'U'",
			"expecting: 'true', 'false', 'sink', 'deadlock', 'current', l par, r par, l sq, enabled, atomic proposition begin, '=>', '&', 'or', 'not', 'E', 'A', 'U', EOF",
        };*/
    private static int[] errors;
/*      {
			0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 2, 3, 4, 5, 5, 1, 6, 3, 1, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 1, 1, 1, 8, 1, 0, 1, 1, 1, 5, 5, 5, 1, 1, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
