/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.be4.ltl.core.parser.parser;

import de.be4.ltl.core.parser.lexer.*;
import de.be4.ltl.core.parser.node.*;
import de.be4.ltl.core.parser.analysis.*;
import java.util.*;
import de.hhu.stups.sablecc.patch.*;


import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings({"rawtypes","unchecked","unused"})
public class Parser implements IParser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;
    
    private ArrayList firstPopped = null;
    private ArrayList lastPopped = null;
    private ITokenListContainer lex;

    public Parser(  Lexer lexer)
    {
        this.lexer = lexer;
        this.lex = lexer; 
    }
    
     
    private Map<PositionedNode, SourcecodeRange> mapping = new HashMap<PositionedNode, SourcecodeRange>();    
    public Map<PositionedNode, SourcecodeRange> getMapping() { 	return this.mapping; }

   private void checkResult(Object elementToCheck) {
       checkResult(elementToCheck, false);
   }

	 
	private void checkResult(Object elementToCheck, boolean slurp) {
		// nodes with no tokens or sub nodes at all may exist
		if (this.firstPopped == null) {
			return;
		}

		if (elementToCheck instanceof LinkedList) {
			/*
			 * special case: this is a list of nodes, for example an identifier
			 * list, so we don't want to check the list but the last element
			 * added to it
			 */
			final LinkedList nodeList = (LinkedList) elementToCheck;

			if (nodeList.size() > 0) {
				elementToCheck = nodeList.get(nodeList.size() - 1);
			} else {
				// no positions for empty lists...
				return;
			}
		}

		if (!(elementToCheck instanceof PositionedNode)) {
			throw new Error(
					"Unexpected elementToCheck (not instanceof PositionedNode): "
							+ elementToCheck.getClass().getSimpleName() + "/"
							+ elementToCheck);
		}

		if (!this.getMapping().containsKey(elementToCheck) || slurp ) {
			final PositionedNode node = (PositionedNode) elementToCheck;

			// dealing with a one-token element
			if (this.lastPopped == null) {
				this.lastPopped = this.firstPopped;
			}

			final int begin = findBeginPos(this.lastPopped, node);
			int end = findEndPos(this.firstPopped);
			if (end == -1) end = begin;
			final SourcecodeRange range = new SourcecodeRange(begin, end);

			this.getMapping().put(node, range);

			node.setStartPos(createBeginPos(begin));
			node.setEndPos(createEndPos(end));
		}
	}
	
	 
	private int findBeginPos(final ArrayList list,
			PositionedNode n) {
		Object first = list.get(0);
		if (!(first instanceof PositionedNode) && !(first instanceof IToken)) {
			List list2 = (List) first;

			if (list2.size() > 0) {
				first = list2.get(0);
			} else {
				/*
				 * Sometimes (haven't found out why) we get empty list here. In
				 * the only observed cases we were looking for the source range
				 * of the whole parse unit. Then the index is 0.
				 */
				return 0;
			}
		}

		if (first instanceof IToken) {
			return findIndex((IToken) first);
		}

		final PositionedNode node = (PositionedNode) first;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null){
			System.err.println(n.getClass().getSimpleName() + " / " + node.getClass().getSimpleName() + ": " + node);
		}
		return item.getBeginIndex();
	}

	 
	private int findEndPos(final ArrayList list) {
		Object last = list.get(list.size() - 1);
		if (!(last instanceof PositionedNode) && !(last instanceof IToken)) {
			final List list2 = (List) last;
			last = list2.get(list2.size() - 1);
		}

		if (last instanceof IToken) {
			return findIndex((IToken) last);
		}

		final PositionedNode node = (PositionedNode) last;
		final SourcecodeRange item = this.getMapping().get(node);
		if (item == null)
			return -1;
		return item.getEndIndex();
	}

	private int findIndex(final IToken token) {
		final List<IToken> list = this.lex.getTokenList();

		for (int i = list.size() - 1; i >= 0; i--) {
			if (list.get(i) == token) {
				return i;
			}
		}

		return -1;
	}

	private SourcePosition createBeginPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos());
	}

	private SourcePosition createEndPos(final int index) {
		final List<IToken> list = this.lex.getTokenList();
		final IToken token = list.get(index);
		return new SourcePosition(token.getLine(), token.getPos()
				+ token.getText().length());
	}
	     
    private void push(int numstate, ArrayList listNode) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
    	ArrayList list = ((State) this.stack.previous()).nodes; 
		if (this.firstPopped == null) {
			this.firstPopped = list;
		} else {
			this.lastPopped = list;
		}
        return list;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

     
    public Start parse() throws ParserException, LexerException, IOException
    {
    	this.getMapping().clear();
    
        push(0, null);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce AFairnessImplicationLtlFormula */
		    {
			ArrayList list = new0();
			push(goTo(0), list);
		    }
		    break;
                    case 1: /* reduce ALtlFormula */
		    {
			ArrayList list = new1();
			push(goTo(0), list);
		    }
		    break;
                    case 2: /* reduce AImplicationLtlFormula1 */
		    {
			ArrayList list = new2();
			push(goTo(1), list);
		    }
		    break;
                    case 3: /* reduce ALtlFormula1 */
		    {
			ArrayList list = new3();
			push(goTo(1), list);
		    }
		    break;
                    case 4: /* reduce AAndLtlFormula2 */
		    {
			ArrayList list = new4();
			push(goTo(2), list);
		    }
		    break;
                    case 5: /* reduce AOrLtlFormula2 */
		    {
			ArrayList list = new5();
			push(goTo(2), list);
		    }
		    break;
                    case 6: /* reduce ALtlFormula2 */
		    {
			ArrayList list = new6();
			push(goTo(2), list);
		    }
		    break;
                    case 7: /* reduce AUntilLtlFormula3 */
		    {
			ArrayList list = new7();
			push(goTo(3), list);
		    }
		    break;
                    case 8: /* reduce AWeakuntilLtlFormula3 */
		    {
			ArrayList list = new8();
			push(goTo(3), list);
		    }
		    break;
                    case 9: /* reduce AReleaseLtlFormula3 */
		    {
			ArrayList list = new9();
			push(goTo(3), list);
		    }
		    break;
                    case 10: /* reduce ASinceLtlFormula3 */
		    {
			ArrayList list = new10();
			push(goTo(3), list);
		    }
		    break;
                    case 11: /* reduce ATriggerLtlFormula3 */
		    {
			ArrayList list = new11();
			push(goTo(3), list);
		    }
		    break;
                    case 12: /* reduce ALtlFormula3 */
		    {
			ArrayList list = new12();
			push(goTo(3), list);
		    }
		    break;
                    case 13: /* reduce ANotLtlFormula4 */
		    {
			ArrayList list = new13();
			push(goTo(4), list);
		    }
		    break;
                    case 14: /* reduce AParLtlFormula4 */
		    {
			ArrayList list = new14();
			push(goTo(4), list);
		    }
		    break;
                    case 15: /* reduce ATrueLtlFormula4 */
		    {
			ArrayList list = new15();
			push(goTo(4), list);
		    }
		    break;
                    case 16: /* reduce AFalseLtlFormula4 */
		    {
			ArrayList list = new16();
			push(goTo(4), list);
		    }
		    break;
                    case 17: /* reduce AGloballyLtlFormula4 */
		    {
			ArrayList list = new17();
			push(goTo(4), list);
		    }
		    break;
                    case 18: /* reduce AFinallyLtlFormula4 */
		    {
			ArrayList list = new18();
			push(goTo(4), list);
		    }
		    break;
                    case 19: /* reduce ANextLtlFormula4 */
		    {
			ArrayList list = new19();
			push(goTo(4), list);
		    }
		    break;
                    case 20: /* reduce AHistoricallyLtlFormula4 */
		    {
			ArrayList list = new20();
			push(goTo(4), list);
		    }
		    break;
                    case 21: /* reduce AOnceLtlFormula4 */
		    {
			ArrayList list = new21();
			push(goTo(4), list);
		    }
		    break;
                    case 22: /* reduce AYesterdayLtlFormula4 */
		    {
			ArrayList list = new22();
			push(goTo(4), list);
		    }
		    break;
                    case 23: /* reduce AEnabledLtlFormula4 */
		    {
			ArrayList list = new23();
			push(goTo(4), list);
		    }
		    break;
                    case 24: /* reduce AAvailableLtlFormula4 */
		    {
			ArrayList list = new24();
			push(goTo(4), list);
		    }
		    break;
                    case 25: /* reduce AActionLtlFormula4 */
		    {
			ArrayList list = new25();
			push(goTo(4), list);
		    }
		    break;
                    case 26: /* reduce ASinkLtlFormula4 */
		    {
			ArrayList list = new26();
			push(goTo(4), list);
		    }
		    break;
                    case 27: /* reduce ADeadlockLtlFormula4 */
		    {
			ArrayList list = new27();
			push(goTo(4), list);
		    }
		    break;
                    case 28: /* reduce ACurrentLtlFormula4 */
		    {
			ArrayList list = new28();
			push(goTo(4), list);
		    }
		    break;
                    case 29: /* reduce AExistsLtlFormula4 */
		    {
			ArrayList list = new29();
			push(goTo(4), list);
		    }
		    break;
                    case 30: /* reduce AForallLtlFormula4 */
		    {
			ArrayList list = new30();
			push(goTo(4), list);
		    }
		    break;
                    case 31: /* reduce ADlkLtlFormula4 */
		    {
			ArrayList list = new31();
			push(goTo(4), list);
		    }
		    break;
                    case 32: /* reduce ADetLtlFormula4 */
		    {
			ArrayList list = new32();
			push(goTo(4), list);
		    }
		    break;
                    case 33: /* reduce ACtrlLtlFormula4 */
		    {
			ArrayList list = new33();
			push(goTo(4), list);
		    }
		    break;
                    case 34: /* reduce AUnparsedLtlFormula4 */
		    {
			ArrayList list = new34();
			push(goTo(4), list);
		    }
		    break;
                    case 35: /* reduce ASingleArgList */
		    {
			ArrayList list = new35();
			push(goTo(5), list);
		    }
		    break;
                    case 36: /* reduce AMultipleArgList */
		    {
			ArrayList list = new36();
			push(goTo(5), list);
		    }
		    break;
                    case 37: /* reduce AOpArg */
		    {
			ArrayList list = new37();
			push(goTo(6), list);
		    }
		    break;
                    case 38: /* reduce AAndFair1$StrongFairAll1$WeakFairAll1LtlFairness */
		    {
			ArrayList list = new38();
			push(goTo(7), list);
		    }
		    break;
                    case 39: /* reduce AAndFair1$StrongFairAll1$1LtlFairness */
		    {
			ArrayList list = new39();
			push(goTo(7), list);
		    }
		    break;
                    case 40: /* reduce AAndFair1$1$WeakFairAll1LtlFairness */
		    {
			ArrayList list = new40();
			push(goTo(7), list);
		    }
		    break;
                    case 41: /* reduce AAndFair1$1$1LtlFairness */
		    {
			ArrayList list = new41();
			push(goTo(7), list);
		    }
		    break;
                    case 42: /* reduce AAndFair2$StrongFairAll1$WeakFairAll1LtlFairness */
		    {
			ArrayList list = new42();
			push(goTo(7), list);
		    }
		    break;
                    case 43: /* reduce AAndFair2$StrongFairAll1$1LtlFairness */
		    {
			ArrayList list = new43();
			push(goTo(7), list);
		    }
		    break;
                    case 44: /* reduce AAndFair2$1$WeakFairAll1LtlFairness */
		    {
			ArrayList list = new44();
			push(goTo(7), list);
		    }
		    break;
                    case 45: /* reduce AAndFair2$1$1LtlFairness */
		    {
			ArrayList list = new45();
			push(goTo(7), list);
		    }
		    break;
                    case 46: /* reduce AStrongAssumptions$StrongFairAll1LtlFairness */
		    {
			ArrayList list = new46();
			push(goTo(7), list);
		    }
		    break;
                    case 47: /* reduce AStrongAssumptions$1LtlFairness */
		    {
			ArrayList list = new47();
			push(goTo(7), list);
		    }
		    break;
                    case 48: /* reduce AWeakAssumptions$WeakFairAll1LtlFairness */
		    {
			ArrayList list = new48();
			push(goTo(7), list);
		    }
		    break;
                    case 49: /* reduce AWeakAssumptions$1LtlFairness */
		    {
			ArrayList list = new49();
			push(goTo(7), list);
		    }
		    break;
                    case 50: /* reduce AAndLtlStrongFairness */
		    {
			ArrayList list = new50();
			push(goTo(8), list);
		    }
		    break;
                    case 51: /* reduce AOrLtlStrongFairness */
		    {
			ArrayList list = new51();
			push(goTo(8), list);
		    }
		    break;
                    case 52: /* reduce ALtlStrongFairness */
		    {
			ArrayList list = new52();
			push(goTo(8), list);
		    }
		    break;
                    case 53: /* reduce AStrongFairLtlStrongArg */
		    {
			ArrayList list = new53();
			push(goTo(9), list);
		    }
		    break;
                    case 54: /* reduce AParLtlStrongArg */
		    {
			ArrayList list = new54();
			push(goTo(9), list);
		    }
		    break;
                    case 55: /* reduce AAndLtlWeakFairness */
		    {
			ArrayList list = new55();
			push(goTo(10), list);
		    }
		    break;
                    case 56: /* reduce AOrLtlWeakFairness */
		    {
			ArrayList list = new56();
			push(goTo(10), list);
		    }
		    break;
                    case 57: /* reduce ALtlWeakFairness */
		    {
			ArrayList list = new57();
			push(goTo(10), list);
		    }
		    break;
                    case 58: /* reduce AWeakFairLtlWeakArg */
		    {
			ArrayList list = new58();
			push(goTo(11), list);
		    }
		    break;
                    case 59: /* reduce AParLtlWeakArg */
		    {
			ArrayList list = new59();
			push(goTo(11), list);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PLtl node1 = (PLtl) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " ,
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



     
    ArrayList new0() /* reduce AFairnessImplicationLtlFormula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AFairnessImplicationLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new1() /* reduce ALtlFormula */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList1.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new2() /* reduce AImplicationLtlFormula1 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AImpliesLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new3() /* reduce ALtlFormula1 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList1.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new4() /* reduce AAndLtlFormula2 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AAndLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new5() /* reduce AOrLtlFormula2 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AOrLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new6() /* reduce ALtlFormula2 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList1.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new7() /* reduce AUntilLtlFormula3 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AUntilLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new8() /* reduce AWeakuntilLtlFormula3 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AWeakuntilLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new9() /* reduce AReleaseLtlFormula3 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AReleaseLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new10() /* reduce ASinceLtlFormula3 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new ASinceLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new11() /* reduce ATriggerLtlFormula3 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new ATriggerLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new12() /* reduce ALtlFormula3 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList1.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new13() /* reduce ANotLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList2.get(0);

        pltlNode1 = new ANotLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new14() /* reduce AParLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList2.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new15() /* reduce ATrueLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block

        pltlNode1 = new ATrueLtl();
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new16() /* reduce AFalseLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block

        pltlNode1 = new AFalseLtl();
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new17() /* reduce AGloballyLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList2.get(0);

        pltlNode1 = new AGloballyLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new18() /* reduce AFinallyLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList2.get(0);

        pltlNode1 = new AFinallyLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new19() /* reduce ANextLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList2.get(0);

        pltlNode1 = new ANextLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new20() /* reduce AHistoricallyLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList2.get(0);

        pltlNode1 = new AHistoricallyLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new21() /* reduce AOnceLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList2.get(0);

        pltlNode1 = new AOnceLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new22() /* reduce AYesterdayLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList2.get(0);

        pltlNode1 = new AYesterdayLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new23() /* reduce AEnabledLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        TEnabled tenabledNode2;
        tenabledNode2 = (TEnabled)nodeArrayList1.get(0);

        pltlNode1 = new AEnabledLtl(tenabledNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new24() /* reduce AAvailableLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        TAvailable tavailableNode2;
        tavailableNode2 = (TAvailable)nodeArrayList1.get(0);

        pltlNode1 = new AAvailableLtl(tavailableNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new25() /* reduce AActionLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        TLSq tlsqNode2;
        tlsqNode2 = (TLSq)nodeArrayList1.get(0);

        pltlNode1 = new AActionLtl(tlsqNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new26() /* reduce ASinkLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block

        pltlNode1 = new ASinkLtl();
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new27() /* reduce ADeadlockLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block

        pltlNode1 = new ADeadlockLtl();
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new28() /* reduce ACurrentLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block

        pltlNode1 = new ACurrentLtl();
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new29() /* reduce AExistsLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        TExistsIdentifier texistsidentifierNode2;
        TAtomicPropositionBegin tatomicpropositionbeginNode3;
        PLtl pltlNode4;
        texistsidentifierNode2 = (TExistsIdentifier)nodeArrayList1.get(0);
        tatomicpropositionbeginNode3 = (TAtomicPropositionBegin)nodeArrayList3.get(0);
        pltlNode4 = (PLtl)nodeArrayList5.get(0);

        pltlNode1 = new AExistsLtl(texistsidentifierNode2, tatomicpropositionbeginNode3, pltlNode4);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new30() /* reduce AForallLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList6 = pop();
          ArrayList nodeArrayList5 = pop();
          ArrayList nodeArrayList4 = pop();
          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        TForallIdentifier tforallidentifierNode2;
        TAtomicPropositionBegin tatomicpropositionbeginNode3;
        PLtl pltlNode4;
        tforallidentifierNode2 = (TForallIdentifier)nodeArrayList1.get(0);
        tatomicpropositionbeginNode3 = (TAtomicPropositionBegin)nodeArrayList3.get(0);
        pltlNode4 = (PLtl)nodeArrayList5.get(0);

        pltlNode1 = new AForallLtl(tforallidentifierNode2, tatomicpropositionbeginNode3, pltlNode4);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new31() /* reduce ADlkLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList2.get(0);
	if(listNode2 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode2);
  	  //listNode3 = listNode2;
	}
        }

        pltlNode1 = new ADlkLtl(listNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new32() /* reduce ADetLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList2.get(0);
	if(listNode2 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode2);
  	  //listNode3 = listNode2;
	}
        }

        pltlNode1 = new ADetLtl(listNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new33() /* reduce ACtrlLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList2.get(0);
	if(listNode2 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode2);
  	  //listNode3 = listNode2;
	}
        }

        pltlNode1 = new ACtrlLtl(listNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new34() /* reduce AUnparsedLtlFormula4 */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        TAtomicPropositionBegin tatomicpropositionbeginNode2;
        tatomicpropositionbeginNode2 = (TAtomicPropositionBegin)nodeArrayList1.get(0);

        pltlNode1 = new AUnparsedLtl(tatomicpropositionbeginNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new35() /* reduce ASingleArgList */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PActions pactionsNode1;
        pactionsNode1 = (PActions)nodeArrayList1.get(0);
	if(pactionsNode1 != null)
	{
	  listNode2.add(pactionsNode1);
	}
        }
	nodeList.add(listNode2);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new36() /* reduce AMultipleArgList */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        PActions pactionsNode1;
        LinkedList listNode2 = new LinkedList();
        pactionsNode1 = (PActions)nodeArrayList1.get(0);
        listNode2 = (LinkedList)nodeArrayList2.get(0);
	if(pactionsNode1 != null)
	{
	  listNode3.add(pactionsNode1);
	}
	if(listNode2 != null) //Macro:ParserTypedLinkedListAddAll
	{
      listNode3.addAll(listNode2);
  	  //listNode3 = listNode2;
	}
        }
	nodeList.add(listNode3);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new37() /* reduce AOpArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PActions pactionsNode1;
        {
            // Block
        TActionChar tactioncharNode2;
        tactioncharNode2 = (TActionChar)nodeArrayList1.get(0);

        pactionsNode1 = new AOpActions(tactioncharNode2);
        }
	nodeList.add(pactionsNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new38() /* reduce AAndFair1$StrongFairAll1$WeakFairAll1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        {
            // Block

        pltlNode2 = new AStrongFairAllLtl();
        }
        {
            // Block

        pltlNode3 = new AWeakFairAllLtl();
        }

        pltlNode1 = new AAndFair1Ltl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new39() /* reduce AAndFair1$StrongFairAll1$1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        {
            // Block

        pltlNode2 = new AStrongFairAllLtl();
        }
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AAndFair1Ltl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new40() /* reduce AAndFair1$1$WeakFairAll1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        {
            // Block

        pltlNode3 = new AWeakFairAllLtl();
        }

        pltlNode1 = new AAndFair1Ltl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new41() /* reduce AAndFair1$1$1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AAndFair1Ltl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new42() /* reduce AAndFair2$StrongFairAll1$WeakFairAll1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        {
            // Block

        pltlNode2 = new AWeakFairAllLtl();
        }
        {
            // Block

        pltlNode3 = new AStrongFairAllLtl();
        }

        pltlNode1 = new AAndFair2Ltl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new43() /* reduce AAndFair2$StrongFairAll1$1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        {
            // Block

        pltlNode3 = new AStrongFairAllLtl();
        }

        pltlNode1 = new AAndFair2Ltl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new44() /* reduce AAndFair2$1$WeakFairAll1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        {
            // Block

        pltlNode2 = new AWeakFairAllLtl();
        }
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AAndFair2Ltl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new45() /* reduce AAndFair2$1$1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AAndFair2Ltl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new46() /* reduce AStrongAssumptions$StrongFairAll1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        {
            // Block

        pltlNode2 = new AStrongFairAllLtl();
        }

        pltlNode1 = new AStrongAssumptionsLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new47() /* reduce AStrongAssumptions$1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);

        pltlNode1 = new AStrongAssumptionsLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new48() /* reduce AWeakAssumptions$WeakFairAll1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        {
            // Block

        pltlNode2 = new AWeakFairAllLtl();
        }

        pltlNode1 = new AWeakAssumptionsLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new49() /* reduce AWeakAssumptions$1LtlFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);

        pltlNode1 = new AWeakAssumptionsLtl(pltlNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new50() /* reduce AAndLtlStrongFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AAndLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new51() /* reduce AOrLtlStrongFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AOrLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new52() /* reduce ALtlStrongFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList1.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new53() /* reduce AStrongFairLtlStrongArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        TStrongFair tstrongfairNode2;
        tstrongfairNode2 = (TStrongFair)nodeArrayList1.get(0);

        pltlNode1 = new AStrongFairLtl(tstrongfairNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new54() /* reduce AParLtlStrongArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList2.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new55() /* reduce AAndLtlWeakFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AAndLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new56() /* reduce AOrLtlWeakFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        PLtl pltlNode2;
        PLtl pltlNode3;
        pltlNode2 = (PLtl)nodeArrayList1.get(0);
        pltlNode3 = (PLtl)nodeArrayList3.get(0);

        pltlNode1 = new AOrLtl(pltlNode2, pltlNode3);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new57() /* reduce ALtlWeakFairness */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList1.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new58() /* reduce AWeakFairLtlWeakArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        {
            // Block
        TWeakFair tweakfairNode2;
        tweakfairNode2 = (TWeakFair)nodeArrayList1.get(0);

        pltlNode1 = new AWeakFairLtl(tweakfairNode2);
        }
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


     
    ArrayList new59() /* reduce AParLtlWeakArg */
    {
        this.firstPopped = null;
        this.lastPopped = null;
          ArrayList nodeList = new ArrayList();

          ArrayList nodeArrayList3 = pop();
          ArrayList nodeArrayList2 = pop();
          ArrayList nodeArrayList1 = pop();
        PLtl pltlNode1;
        pltlNode1 = (PLtl)nodeArrayList2.get(0);
	nodeList.add(pltlNode1);
        // return nodeList;
        final ArrayList containerList = nodeList;
        Object elementToCheck = containerList.get(0);
        checkResult(elementToCheck);
        
        return containerList;
    }


    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 9}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, {40, SHIFT, 23}, {41, SHIFT, 24}, {42, SHIFT, 25}, {43, SHIFT, 26}, },
			{{-1, REDUCE, 15}, },
			{{-1, REDUCE, 16}, },
			{{-1, ERROR, 3}, {24, SHIFT, 37}, },
			{{-1, ERROR, 4}, {24, SHIFT, 37}, },
			{{-1, ERROR, 5}, {24, SHIFT, 37}, },
			{{-1, REDUCE, 26}, },
			{{-1, REDUCE, 27}, },
			{{-1, REDUCE, 28}, },
			{{-1, ERROR, 9}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 9}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, {40, SHIFT, 23}, {41, SHIFT, 24}, {42, SHIFT, 25}, {43, SHIFT, 26}, },
			{{-1, REDUCE, 25}, },
			{{-1, REDUCE, 23}, },
			{{-1, REDUCE, 24}, },
			{{-1, REDUCE, 34}, },
			{{-1, ERROR, 14}, {8, SHIFT, 45}, },
			{{-1, ERROR, 15}, {8, SHIFT, 46}, },
			{{-1, ERROR, 16}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 17}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 18}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 19}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 20}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 21}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 22}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, REDUCE, 46}, {26, SHIFT, 55}, },
			{{-1, REDUCE, 48}, {26, SHIFT, 56}, },
			{{-1, REDUCE, 53}, },
			{{-1, REDUCE, 58}, },
			{{-1, ERROR, 27}, {44, ACCEPT, -1}, },
			{{-1, REDUCE, 1}, {25, SHIFT, 57}, },
			{{-1, REDUCE, 3}, {26, SHIFT, 58}, {27, SHIFT, 59}, },
			{{-1, REDUCE, 6}, {29, SHIFT, 60}, {30, SHIFT, 61}, {31, SHIFT, 62}, {35, SHIFT, 63}, {36, SHIFT, 64}, },
			{{-1, REDUCE, 12}, },
			{{-1, ERROR, 32}, {25, SHIFT, 65}, },
			{{-1, REDUCE, 47}, {26, SHIFT, 66}, {27, SHIFT, 67}, },
			{{-1, REDUCE, 52}, },
			{{-1, REDUCE, 49}, {26, SHIFT, 68}, {27, SHIFT, 69}, },
			{{-1, REDUCE, 57}, },
			{{-1, REDUCE, 37}, },
			{{-1, REDUCE, 31}, },
			{{-1, REDUCE, 35}, {24, SHIFT, 37}, },
			{{-1, REDUCE, 32}, },
			{{-1, REDUCE, 33}, },
			{{-1, ERROR, 42}, {9, SHIFT, 71}, },
			{{-1, REDUCE, 47}, {9, SHIFT, 72}, {26, SHIFT, 66}, {27, SHIFT, 67}, },
			{{-1, REDUCE, 49}, {9, SHIFT, 73}, {26, SHIFT, 68}, {27, SHIFT, 69}, },
			{{-1, ERROR, 45}, {13, SHIFT, 74}, },
			{{-1, ERROR, 46}, {13, SHIFT, 75}, },
			{{-1, ERROR, 47}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 9}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, {40, SHIFT, 23}, {41, SHIFT, 24}, {42, SHIFT, 25}, {43, SHIFT, 26}, },
			{{-1, REDUCE, 13}, },
			{{-1, REDUCE, 17}, },
			{{-1, REDUCE, 18}, },
			{{-1, REDUCE, 19}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 21}, },
			{{-1, REDUCE, 22}, },
			{{-1, ERROR, 55}, {8, SHIFT, 76}, {41, SHIFT, 77}, {43, SHIFT, 26}, },
			{{-1, ERROR, 56}, {8, SHIFT, 79}, {40, SHIFT, 80}, {42, SHIFT, 25}, },
			{{-1, ERROR, 57}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 58}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 59}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 60}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 61}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 62}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 63}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 64}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 65}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 47}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, },
			{{-1, ERROR, 66}, {8, SHIFT, 91}, {41, SHIFT, 92}, {42, SHIFT, 25}, {43, SHIFT, 26}, },
			{{-1, ERROR, 67}, {8, SHIFT, 79}, {42, SHIFT, 25}, },
			{{-1, ERROR, 68}, {8, SHIFT, 91}, {40, SHIFT, 96}, {42, SHIFT, 25}, {43, SHIFT, 26}, },
			{{-1, ERROR, 69}, {8, SHIFT, 76}, {43, SHIFT, 26}, },
			{{-1, REDUCE, 36}, },
			{{-1, REDUCE, 14}, },
			{{-1, REDUCE, 54}, },
			{{-1, REDUCE, 59}, },
			{{-1, ERROR, 74}, {26, SHIFT, 100}, },
			{{-1, ERROR, 75}, {25, SHIFT, 101}, },
			{{-1, ERROR, 76}, {8, SHIFT, 76}, {43, SHIFT, 26}, },
			{{-1, REDUCE, 38}, },
			{{-1, REDUCE, 39}, {26, SHIFT, 103}, {27, SHIFT, 69}, },
			{{-1, ERROR, 79}, {8, SHIFT, 79}, {42, SHIFT, 25}, },
			{{-1, REDUCE, 42}, },
			{{-1, REDUCE, 44}, {26, SHIFT, 105}, {27, SHIFT, 67}, },
			{{-1, REDUCE, 2}, {26, SHIFT, 58}, {27, SHIFT, 59}, },
			{{-1, REDUCE, 4}, {29, SHIFT, 60}, {30, SHIFT, 61}, {31, SHIFT, 62}, {35, SHIFT, 63}, {36, SHIFT, 64}, },
			{{-1, REDUCE, 5}, {29, SHIFT, 60}, {30, SHIFT, 61}, {31, SHIFT, 62}, {35, SHIFT, 63}, {36, SHIFT, 64}, },
			{{-1, REDUCE, 7}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 9}, },
			{{-1, REDUCE, 10}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 0}, {25, SHIFT, 57}, },
			{{-1, ERROR, 91}, {8, SHIFT, 91}, {42, SHIFT, 25}, {43, SHIFT, 26}, },
			{{-1, REDUCE, 40}, },
			{{-1, REDUCE, 50}, },
			{{-1, REDUCE, 41}, {26, SHIFT, 103}, {27, SHIFT, 69}, },
			{{-1, REDUCE, 51}, },
			{{-1, REDUCE, 43}, },
			{{-1, REDUCE, 45}, {26, SHIFT, 105}, {27, SHIFT, 67}, },
			{{-1, REDUCE, 55}, },
			{{-1, REDUCE, 56}, },
			{{-1, ERROR, 100}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 9}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, {40, SHIFT, 23}, {41, SHIFT, 24}, {42, SHIFT, 25}, {43, SHIFT, 26}, },
			{{-1, ERROR, 101}, {0, SHIFT, 1}, {1, SHIFT, 2}, {2, SHIFT, 3}, {3, SHIFT, 4}, {4, SHIFT, 5}, {5, SHIFT, 6}, {6, SHIFT, 7}, {7, SHIFT, 8}, {8, SHIFT, 9}, {10, SHIFT, 10}, {11, SHIFT, 11}, {12, SHIFT, 12}, {13, SHIFT, 13}, {19, SHIFT, 14}, {20, SHIFT, 15}, {28, SHIFT, 16}, {32, SHIFT, 17}, {33, SHIFT, 18}, {34, SHIFT, 19}, {37, SHIFT, 20}, {38, SHIFT, 21}, {39, SHIFT, 22}, {40, SHIFT, 23}, {41, SHIFT, 24}, {42, SHIFT, 25}, {43, SHIFT, 26}, },
			{{-1, ERROR, 102}, {9, SHIFT, 73}, {26, SHIFT, 103}, {27, SHIFT, 69}, },
			{{-1, ERROR, 103}, {8, SHIFT, 76}, {43, SHIFT, 26}, },
			{{-1, ERROR, 104}, {9, SHIFT, 72}, {26, SHIFT, 105}, {27, SHIFT, 67}, },
			{{-1, ERROR, 105}, {8, SHIFT, 79}, {42, SHIFT, 25}, },
			{{-1, ERROR, 106}, {9, SHIFT, 108}, },
			{{-1, ERROR, 107}, {9, SHIFT, 109}, },
			{{-1, REDUCE, 29}, },
			{{-1, REDUCE, 30}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 42}, {0, 27}, {100, 106}, {101, 107}, },
			{{-1, 28}, {65, 90}, },
			{{-1, 29}, {57, 82}, },
			{{-1, 30}, {58, 83}, {59, 84}, },
			{{-1, 31}, {16, 48}, {17, 49}, {18, 50}, {19, 51}, {20, 52}, {21, 53}, {22, 54}, {60, 85}, {61, 86}, {62, 87}, {63, 88}, {64, 89}, },
			{{-1, 38}, {4, 40}, {5, 41}, {39, 70}, },
			{{-1, 39}, },
			{{-1, 32}, },
			{{-1, 33}, {9, 43}, {56, 81}, {68, 97}, {79, 104}, {91, 104}, },
			{{-1, 34}, {66, 93}, {67, 95}, {105, 93}, },
			{{-1, 35}, {9, 44}, {55, 78}, {66, 94}, {76, 102}, {91, 102}, },
			{{-1, 36}, {68, 98}, {69, 99}, {103, 98}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: 'true', 'false', dlk, det, ctrl, 'sink', 'deadlock', 'current', l par, l sq, enabled, available, atomic proposition begin, exists identifier, forall identifier, 'not', 'G', 'F', 'X', 'H', 'O', 'Y', strong fair everything, weak fair everything, strong fair, weak fair",
			"expecting: r par, '=>', '&', 'or', 'U', 'W', 'R', 'S', 'T', EOF",
			"expecting: action char",
			"expecting: l par",
			"expecting: 'true', 'false', dlk, det, ctrl, 'sink', 'deadlock', 'current', l par, l sq, enabled, available, atomic proposition begin, exists identifier, forall identifier, 'not', 'G', 'F', 'X', 'H', 'O', 'Y'",
			"expecting: '=>', '&'",
			"expecting: r par, '=>', '&', 'or'",
			"expecting: EOF",
			"expecting: r par, '=>', EOF",
			"expecting: r par, '=>', '&', 'or', EOF",
			"expecting: '=>'",
			"expecting: '=>', '&', 'or'",
			"expecting: r par, action char, '=>', '&', 'or', 'U', 'W', 'R', 'S', 'T', EOF",
			"expecting: r par",
			"expecting: atomic proposition begin",
			"expecting: l par, weak fair everything, weak fair",
			"expecting: l par, strong fair everything, strong fair",
			"expecting: l par, weak fair everything, strong fair, weak fair",
			"expecting: l par, strong fair",
			"expecting: l par, strong fair everything, strong fair, weak fair",
			"expecting: l par, weak fair",
			"expecting: '&'",
			"expecting: l par, strong fair, weak fair",
			"expecting: r par, '&', 'or'",
        };*/
    private static int[] errors;
/*      {
			0, 1, 1, 2, 2, 2, 1, 1, 1, 0, 1, 1, 1, 1, 3, 3, 4, 4, 4, 4, 4, 4, 4, 5, 5, 6, 6, 7, 8, 9, 1, 1, 10, 11, 6, 11, 6, 12, 1, 12, 1, 1, 13, 6, 6, 14, 14, 0, 1, 1, 1, 1, 1, 1, 1, 15, 16, 4, 4, 4, 4, 4, 4, 4, 4, 4, 17, 18, 19, 20, 1, 1, 6, 6, 21, 10, 20, 10, 11, 18, 10, 11, 9, 1, 1, 1, 1, 1, 1, 1, 8, 22, 10, 6, 11, 6, 10, 11, 6, 6, 0, 0, 23, 20, 23, 18, 13, 13, 1, 1, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
