/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.be4.ltl.core.ctlparser.lexer;

import java.io.*;
import java.util.*;
import de.be4.ltl.core.ctlparser.node.*;
import de.hhu.stups.sablecc.patch.*;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.CTL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;
    private final Queue<IToken> nextList = new LinkedBlockingQueue<IToken>();

	private IToken tok;

    public Queue<IToken> getNextList() {
        return nextList;
    }

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
              nextList.add(token);
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return (Token) nextList.peek();
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = (Token) nextList.poll();
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.ATOMIC; break;
                                case 0: state = State.ATOMIC; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.ATOMIC; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.ATOMIC; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 14:
                        {
                              Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.ACTION; break;
                            }
                            return token;
                        }
                    case 15:
                        {
                              Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 16:
                        {
                              Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 17:
                        {
                              Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 18:
                        {
                              Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 19:
                        {
                              Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 20:
                        {
                              Token token = new20(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 21:
                        {
                              Token token = new21(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 22:
                        {
                              Token token = new22(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 23:
                        {
                              Token token = new23(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 24:
                        {
                              Token token = new24(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.CTL; break;
                            }
                            return token;
                        }
                    case 25:
                        {
                              Token token = new25(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  int line,   int pos) { return new TTrue(line, pos); }
    Token new1(  int line,   int pos) { return new TFalse(line, pos); }
    Token new2(  int line,   int pos) { return new TSink(line, pos); }
    Token new3(  int line,   int pos) { return new TDeadlock(line, pos); }
    Token new4(  int line,   int pos) { return new TCurrent(line, pos); }
    Token new5(  String text,   int line,   int pos) { return new TLPar(text, line, pos); }
    Token new6(  String text,   int line,   int pos) { return new TRPar(text, line, pos); }
    Token new7(  String text,   int line,   int pos) { return new TLSq(text, line, pos); }
    Token new8(  String text,   int line,   int pos) { return new TEnabled(text, line, pos); }
    Token new9(  String text,   int line,   int pos) { return new TAtomicPropositionBegin(text, line, pos); }
    Token new10(  String text,   int line,   int pos) { return new TAtomicPropositionEnd(text, line, pos); }
    Token new11(  String text,   int line,   int pos) { return new TApChar(text, line, pos); }
    Token new12(  String text,   int line,   int pos) { return new TActionEnd(text, line, pos); }
    Token new13(  String text,   int line,   int pos) { return new TActionBegin(text, line, pos); }
    Token new14(  String text,   int line,   int pos) { return new TTpChar(text, line, pos); }
    Token new15(  int line,   int pos) { return new TImplies(line, pos); }
    Token new16(  int line,   int pos) { return new TAnd(line, pos); }
    Token new17(  int line,   int pos) { return new TOr(line, pos); }
    Token new18(  int line,   int pos) { return new TNot(line, pos); }
    Token new19(  int line,   int pos) { return new TExists(line, pos); }
    Token new20(  int line,   int pos) { return new TForall(line, pos); }
    Token new21(  int line,   int pos) { return new TUntil(line, pos); }
    Token new22(  int line,   int pos) { return new TGlobally(line, pos); }
    Token new23(  int line,   int pos) { return new TFinally(line, pos); }
    Token new24(  int line,   int pos) { return new TNext(line, pos); }
    Token new25(  String text,   int line,   int pos) { return new TWhiteSpace(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // CTL
            {{0, 9, 1}, {10, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 32, 1}, {38, 38, 3}, {40, 40, 4}, {41, 41, 5}, {61, 61, 6}, {65, 65, 7}, {69, 69, 8}, {70, 70, 9}, {71, 71, 10}, {85, 85, 11}, {88, 88, 12}, {91, 91, 13}, {99, 99, 14}, {100, 100, 15}, {101, 101, 16}, {102, 102, 17}, {110, 110, 18}, {111, 111, 19}, {115, 115, 20}, {116, 116, 21}, {123, 123, 22}, {127, 160, 1}, {8206, 8207, 1}, {8232, 8233, 1}, },
            {{0, 9, 1}, {11, 12, 1}, {14, 32, 1}, {127, 8233, -2}, },
            {},
            {},
            {},
            {},
            {{62, 62, 23}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{117, 117, 24}, },
            {{101, 101, 25}, },
            {{40, 40, 26}, },
            {{97, 97, 27}, },
            {{111, 111, 28}, },
            {{114, 114, 29}, },
            {{105, 105, 30}, },
            {{114, 114, 31}, },
            {},
            {},
            {{114, 114, 32}, },
            {{97, 97, 33}, },
            {},
            {{108, 108, 34}, },
            {{116, 116, 35}, },
            {},
            {{110, 110, 36}, },
            {{117, 117, 37}, },
            {{114, 114, 38}, },
            {{100, 100, 39}, },
            {{115, 115, 40}, },
            {},
            {{107, 107, 41}, },
            {{101, 101, 42}, },
            {{101, 101, 43}, },
            {{108, 108, 44}, },
            {{101, 101, 45}, },
            {},
            {},
            {{110, 110, 46}, },
            {{111, 111, 47}, },
            {},
            {{116, 116, 48}, },
            {{99, 99, 49}, },
            {},
            {{107, 107, 50}, },
            {},
        }
        { // ATOMIC
            {{0, 9, 1}, {10, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 32, 1}, {33, 122, 3}, {123, 123, 4}, {124, 124, 3}, {125, 125, 5}, {126, 126, 3}, {127, 160, 1}, {161, 8205, 3}, {8206, 8207, 1}, {8208, 8231, 3}, {8232, 8233, 1}, {8234, 65535, 3}, },
            {{0, 9, 6}, {11, 12, 6}, {14, 32, 6}, {127, 160, 6}, {8206, 8207, 6}, {8232, 8233, 6}, },
            {},
            {},
            {},
            {},
            {{0, 8233, -3}, },
        }
        { // ACTION
            {{0, 9, 1}, {10, 10, 2}, {11, 12, 1}, {13, 13, 2}, {14, 32, 1}, {33, 39, 3}, {40, 40, 4}, {41, 41, 5}, {42, 90, 3}, {91, 91, 4}, {92, 92, 3}, {93, 93, 5}, {94, 126, 3}, {127, 160, 1}, {161, 8205, 3}, {8206, 8207, 1}, {8208, 8231, 3}, {8232, 8233, 1}, {8234, 65535, 3}, },
            {{0, 9, 6}, {11, 12, 6}, {14, 32, 6}, {127, 160, 6}, {8206, 8207, 6}, {8232, 8233, 6}, },
            {},
            {},
            {},
            {},
            {{0, 8233, -3}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // CTL
        {-1, 25, 25, 16, 5, 6, -1, 20, 19, 23, 22, 21, 24, 7, -1, -1, -1, -1, -1, -1, -1, -1, 9, 15, -1, -1, 8, -1, -1, 17, -1, -1, -1, -1, -1, 18, -1, -1, -1, -1, -1, 2, 0, -1, -1, 1, -1, -1, 4, -1, 3, },
        // ATOMIC
        {-1, 11, 11, 11, 9, 10, 25, },
        // ACTION
        {-1, 14, 14, 14, 13, 12, 25, },

    };*/

    public static class State
    {
        public final static State CTL = new State(0);
        public final static State ATOMIC = new State(1);
        public final static State ACTION = new State(2);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
