/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.be4.classicalb.core.preparser.lexer;

import java.io.*;
import java.util.*;
import de.be4.classicalb.core.preparser.node.*;
import de.hhu.stups.sablecc.patch.*;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.NORMAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;
    private final Queue<IToken> nextList = new LinkedBlockingQueue<IToken>();

	private IToken tok;

    public Queue<IToken> getNextList() {
        return nextList;
    }

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
              nextList.add(token);
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return (Token) nextList.peek();
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = (Token) nextList.poll();
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.COMMENT; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NO_DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 4: state = State.NO_DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 14:
                        {
                              Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 15:
                        {
                              Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 16:
                        {
                              Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 17:
                        {
                              Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 18:
                        {
                              Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITIONS; break;
                                case 2: state = State.DEFINITIONS_RHS; break;
                            }
                            return token;
                        }
                    case 19:
                        {
                              Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.DEFINITION_FILE; break;
                                case 3: state = State.DEFINITIONS; break;
                            }
                            return token;
                        }
                    case 20:
                        {
                              Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.DEFINITION_FILE; break;
                            }
                            return token;
                        }
                    case 21:
                        {
                              Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 22:
                        {
                              Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  String text,   int line,   int pos) { return new TComment(text, line, pos); }
    Token new1(  String text,   int line,   int pos) { return new TCommentEnd(text, line, pos); }
    Token new2(  String text,   int line,   int pos) { return new TCommentContent(text, line, pos); }
    Token new3(  int line,   int pos) { return new TDefinitions(line, pos); }
    Token new4(  String text,   int line,   int pos) { return new TOtherClauseBegin(text, line, pos); }
    Token new5(  String text,   int line,   int pos) { return new TEndMachine(text, line, pos); }
    Token new6(  int line,   int pos) { return new TKwDefinitions(line, pos); }
    Token new7(  String text,   int line,   int pos) { return new TKwPrefix(text, line, pos); }
    Token new8(  String text,   int line,   int pos) { return new TNoDefSomething(text, line, pos); }
    Token new9(  String text,   int line,   int pos) { return new TIdentifierLiteral(text, line, pos); }
    Token new10(  int line,   int pos) { return new TLeftPar(line, pos); }
    Token new11(  int line,   int pos) { return new TRightPar(line, pos); }
    Token new12(  int line,   int pos) { return new TComma(line, pos); }
    Token new13(  int line,   int pos) { return new TBeginDefBody(line, pos); }
    Token new14(  String text,   int line,   int pos) { return new TRhsBody(text, line, pos); }
    Token new15(  String text,   int line,   int pos) { return new TBeginNesting(text, line, pos); }
    Token new16(  String text,   int line,   int pos) { return new TEndNesting(text, line, pos); }
    Token new17(  String text,   int line,   int pos) { return new TRhsIdentifier(text, line, pos); }
    Token new18(  String text,   int line,   int pos) { return new TSemicolon(text, line, pos); }
    Token new19(  String text,   int line,   int pos) { return new TDoubleQuotation(text, line, pos); }
    Token new20(  String text,   int line,   int pos) { return new TFilename(text, line, pos); }
    Token new21(  String text,   int line,   int pos) { return new TSomething(text, line, pos); }
    Token new22(  String text,   int line,   int pos) { return new TWhiteSpace(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // NORMAL
            {{0, 32, 1}, {33, 34, 2}, {35, 35, 3}, {36, 46, 2}, {47, 47, 4}, {48, 64, 2}, {65, 65, 5}, {66, 66, 2}, {67, 67, 6}, {68, 68, 7}, {69, 69, 8}, {70, 72, 2}, {73, 73, 9}, {74, 75, 2}, {76, 76, 10}, {77, 77, 11}, {78, 78, 2}, {79, 79, 12}, {80, 80, 13}, {81, 81, 2}, {82, 82, 14}, {83, 83, 15}, {84, 84, 2}, {85, 85, 16}, {86, 86, 17}, {87, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 18}, {127, 160, 18}, {8206, 8207, 18}, {8232, 8233, 18}, },
            {},
            {{65, 65, 19}, {67, 67, 20}, {68, 68, 21}, {69, 69, 22}, {73, 73, 23}, {76, 76, 24}, {79, 79, 25}, {80, 80, 26}, {82, 82, 27}, {83, 83, 28}, {85, 85, 29}, {86, 86, 30}, },
            {{42, 42, 31}, },
            {{66, 66, 32}, {83, 83, 33}, },
            {{79, 79, 34}, },
            {{69, 69, 35}, },
            {{78, 78, 36}, {86, 86, 37}, {88, 88, 38}, },
            {{77, 77, 39}, {78, 78, 40}, },
            {{79, 79, 41}, },
            {{65, 65, 42}, {79, 79, 43}, },
            {{80, 80, 44}, },
            {{82, 82, 45}, },
            {{69, 69, 46}, },
            {{69, 69, 47}, {89, 89, 48}, },
            {{83, 83, 49}, },
            {{65, 65, 50}, },
            {{0, 8233, -3}, },
            {{66, 66, 51}, {83, 83, 52}, },
            {{79, 79, 53}, },
            {{69, 69, 54}, },
            {{86, 86, 55}, {88, 88, 56}, },
            {{77, 77, 57}, {78, 78, 58}, },
            {{79, 79, 59}, },
            {{80, 80, 60}, },
            {{82, 82, 61}, },
            {{69, 69, 62}, },
            {{69, 69, 63}, {85, 85, 64}, },
            {{83, 83, 65}, },
            {{65, 65, 66}, },
            {},
            {{83, 83, 67}, },
            {{83, 83, 68}, },
            {{78, 78, 69}, },
            {{70, 70, 70}, },
            {{68, 68, 71}, },
            {{69, 69, 72}, },
            {{84, 84, 73}, },
            {{80, 80, 74}, },
            {{67, 67, 75}, {73, 73, 76}, {86, 86, 77}, },
            {{67, 67, 78}, },
            {{67, 67, 79}, },
            {{68, 68, 80}, },
            {{69, 69, 81}, },
            {{79, 79, 82}, },
            {{70, 70, 83}, },
            {{69, 69, 84}, {84, 84, 85}, },
            {{83, 83, 86}, },
            {{69, 69, 87}, },
            {{76, 76, 88}, {82, 82, 89}, },
            {{83, 83, 90}, },
            {{83, 83, 91}, },
            {{78, 78, 92}, },
            {{70, 70, 93}, },
            {{69, 69, 94}, },
            {{80, 80, 95}, },
            {{80, 80, 96}, },
            {{67, 67, 97}, {73, 73, 98}, {86, 86, 99}, },
            {{67, 67, 100}, },
            {{69, 69, 101}, },
            {{69, 69, 102}, {79, 79, 103}, },
            {{70, 70, 104}, },
            {{69, 69, 105}, {84, 84, 106}, },
            {{66, 66, 107}, },
            {{69, 69, 108}, },
            {{76, 76, 109}, {82, 82, 110}, },
            {{84, 84, 111}, },
            {{69, 69, 112}, },
            {{67, 67, 113}, {83, 83, 114}, },
            {{73, 73, 115}, },
            {},
            {{78, 78, 116}, },
            {{69, 69, 117}, },
            {{76, 76, 118}, {79, 79, 119}, },
            {{76, 76, 120}, },
            {{84, 84, 121}, },
            {{65, 65, 122}, },
            {{65, 65, 123}, },
            {{72, 72, 124}, },
            {{69, 69, 125}, },
            {{82, 82, 126}, },
            {{77, 77, 127}, {80, 80, 128}, },
            {{73, 73, 129}, },
            {{83, 83, 130}, },
            {{83, 83, 131}, },
            {{84, 84, 132}, },
            {{83, 83, 133}, },
            {{85, 85, 134}, },
            {{73, 73, 135}, },
            {{84, 84, 136}, },
            {{69, 69, 137}, },
            {{67, 67, 138}, {83, 83, 139}, },
            {{73, 73, 140}, },
            {{78, 78, 141}, },
            {{82, 82, 142}, },
            {{76, 76, 143}, {79, 79, 144}, },
            {{76, 76, 145}, },
            {{84, 84, 146}, },
            {{65, 65, 147}, },
            {{65, 65, 148}, },
            {{82, 82, 149}, },
            {{68, 68, 150}, },
            {{77, 77, 151}, {80, 80, 152}, },
            {{73, 73, 153}, },
            {{83, 83, 154}, },
            {{83, 83, 155}, },
            {{83, 83, 156}, },
            {{83, 83, 157}, },
            {{85, 85, 158}, },
            {{73, 73, 159}, },
            {{82, 82, 160}, },
            {{82, 82, 161}, },
            {{82, 82, 162}, },
            {{84, 84, 163}, },
            {{78, 78, 164}, },
            {{84, 84, 165}, },
            {{78, 78, 166}, },
            {{69, 69, 167}, },
            {{82, 82, 168}, },
            {{85, 85, 169}, },
            {{73, 73, 170}, },
            {{82, 82, 171}, },
            {{76, 76, 172}, },
            {{73, 73, 173}, },
            {{76, 76, 174}, },
            {{65, 65, 175}, },
            {{79, 79, 176}, },
            {{69, 69, 177}, },
            {{78, 78, 178}, },
            {},
            {},
            {{69, 69, 179}, },
            {},
            {{69, 69, 180}, },
            {{65, 65, 181}, },
            {{82, 82, 182}, },
            {{82, 82, 183}, },
            {{82, 82, 184}, },
            {{84, 84, 185}, },
            {{78, 78, 186}, },
            {{84, 84, 187}, },
            {{69, 69, 188}, },
            {{69, 69, 189}, },
            {{82, 82, 190}, },
            {{85, 85, 191}, },
            {{73, 73, 192}, },
            {{82, 82, 193}, },
            {{76, 76, 194}, },
            {{65, 65, 195}, },
            {{73, 73, 196}, },
            {{79, 79, 197}, },
            {{69, 69, 198}, },
            {{78, 78, 199}, },
            {},
            {},
            {{84, 84, 200}, },
            {},
            {{69, 69, 201}, },
            {{65, 65, 202}, },
            {{65, 65, 203}, },
            {{84, 84, 204}, },
            {{69, 69, 205}, },
            {{65, 65, 206}, {82, 82, 207}, },
            {{73, 73, 208}, },
            {{83, 83, 209}, },
            {{68, 68, 210}, },
            {{77, 77, 211}, },
            {{84, 84, 212}, },
            {{68, 68, 213}, },
            {{65, 65, 214}, },
            {{73, 73, 215}, },
            {{95, 95, 216}, },
            {{78, 78, 217}, },
            {},
            {{84, 84, 218}, },
            {{84, 84, 219}, },
            {{82, 82, 220}, },
            {{69, 69, 221}, },
            {{77, 77, 222}, },
            {{83, 83, 223}, },
            {{66, 66, 224}, },
            {{65, 65, 225}, },
            {{84, 84, 226}, },
            {{69, 69, 227}, },
            {{65, 65, 228}, {82, 82, 229}, },
            {{73, 73, 230}, },
            {{83, 83, 231}, },
            {{83, 83, 232}, },
            {{77, 77, 233}, },
            {{84, 84, 234}, },
            {{68, 68, 235}, },
            {{65, 65, 236}, },
            {{73, 73, 237}, },
            {{95, 95, 238}, },
            {{84, 84, 239}, },
            {{67, 67, 240}, },
            {{84, 84, 241}, },
            {{82, 82, 242}, },
            {{69, 69, 243}, },
            {{73, 73, 244}, },
            {{83, 83, 245}, },
            {{66, 66, 246}, },
            {{67, 67, 247}, },
            {{73, 73, 248}, },
            {{84, 84, 249}, },
            {{78, 78, 250}, },
            {{65, 65, 251}, },
            {{84, 84, 252}, },
            {},
            {{83, 83, 253}, },
            {{69, 69, 254}, },
            {{83, 83, 255}, },
            {{69, 69, 256}, },
            {{76, 76, 257}, },
            {{65, 65, 258}, },
            {{79, 79, 259}, },
            {{69, 69, 260}, },
            {{73, 73, 261}, },
            {{69, 69, 262}, },
            {{84, 84, 263}, },
            {{77, 77, 264}, {83, 83, 265}, },
            {},
            {},
            {{76, 76, 266}, },
            {{67, 67, 267}, },
            {{73, 73, 268}, },
            {{84, 84, 269}, },
            {{78, 78, 270}, },
            {{65, 65, 271}, },
            {{84, 84, 272}, },
            {},
            {{83, 83, 273}, },
            {{69, 69, 274}, },
            {{83, 83, 275}, },
            {{69, 69, 276}, },
            {{76, 76, 277}, },
            {{65, 65, 278}, },
            {{79, 79, 279}, },
            {{73, 73, 280}, },
            {{65, 65, 281}, },
            {{69, 69, 282}, },
            {{84, 84, 283}, },
            {{83, 83, 284}, },
            {{84, 84, 285}, },
            {},
            {{76, 76, 286}, },
            {{84, 84, 287}, },
            {{79, 79, 288}, },
            {{69, 69, 289}, },
            {{84, 84, 290}, },
            {{73, 73, 291}, },
            {{73, 73, 292}, },
            {},
            {{78, 78, 293}, },
            {},
            {{83, 83, 294}, },
            {{73, 73, 295}, },
            {{78, 78, 296}, },
            {{80, 80, 297}, },
            {},
            {{79, 79, 298}, },
            {{83, 83, 299}, },
            {{73, 73, 300}, },
            {{69, 69, 301}, },
            {},
            {{69, 69, 302}, },
            {{84, 84, 303}, },
            {{79, 79, 304}, },
            {{69, 69, 305}, },
            {{84, 84, 306}, },
            {{73, 73, 307}, },
            {{73, 73, 308}, },
            {{73, 73, 309}, },
            {{78, 78, 310}, },
            {},
            {{83, 83, 311}, },
            {{73, 73, 312}, },
            {{78, 78, 313}, },
            {{80, 80, 314}, },
            {{79, 79, 315}, },
            {{84, 84, 316}, },
            {{83, 83, 317}, },
            {{73, 73, 318}, },
            {},
            {{85, 85, 319}, },
            {{69, 69, 320}, },
            {{95, 95, 321}, },
            {{78, 78, 322}, },
            {{95, 95, 323}, },
            {{83, 83, 324}, },
            {{78, 78, 325}, },
            {{79, 79, 326}, },
            {{84, 84, 327}, },
            {},
            {{83, 83, 328}, {90, 90, 329}, },
            {{84, 84, 330}, },
            {{69, 69, 331}, },
            {{78, 78, 332}, },
            {},
            {{69, 69, 333}, },
            {{78, 78, 334}, },
            {{83, 83, 335}, },
            {{95, 95, 336}, },
            {{78, 78, 337}, },
            {{95, 95, 338}, },
            {{83, 83, 339}, },
            {{78, 78, 340}, },
            {{79, 79, 341}, },
            {{79, 79, 342}, },
            {{84, 84, 343}, },
            {},
            {{83, 83, 344}, {90, 90, 345}, },
            {{84, 84, 346}, },
            {{69, 69, 347}, },
            {{78, 78, 348}, },
            {{69, 69, 349}, },
            {},
            {{69, 69, 350}, },
            {{84, 84, 351}, },
            {{83, 83, 352}, },
            {{67, 67, 353}, {86, 86, 354}, },
            {{83, 83, 355}, },
            {{67, 67, 356}, {86, 86, 357}, },
            {},
            {{84, 84, 358}, },
            {{78, 78, 359}, },
            {{65, 65, 360}, },
            {{65, 65, 361}, },
            {{65, 65, 362}, },
            {},
            {{82, 82, 363}, },
            {{83, 83, 364}, },
            {{83, 83, 365}, },
            {{84, 84, 366}, },
            {},
            {{67, 67, 367}, {86, 86, 368}, },
            {{83, 83, 369}, },
            {{67, 67, 370}, {86, 86, 371}, },
            {},
            {{84, 84, 372}, },
            {{78, 78, 373}, },
            {{78, 78, 374}, },
            {{65, 65, 375}, },
            {{65, 65, 376}, },
            {{65, 65, 377}, },
            {},
            {{82, 82, 378}, },
            {{83, 83, 379}, },
            {},
            {{83, 83, 380}, },
            {{73, 73, 381}, },
            {},
            {{79, 79, 382}, },
            {{65, 65, 383}, },
            {},
            {{79, 79, 384}, },
            {{65, 65, 385}, },
            {{83, 83, 386}, },
            {{83, 83, 387}, },
            {{84, 84, 388}, },
            {{84, 84, 389}, },
            {{84, 84, 390}, },
            {{65, 65, 391}, },
            {},
            {},
            {},
            {{79, 79, 392}, },
            {{65, 65, 393}, },
            {},
            {{79, 79, 394}, },
            {{65, 65, 395}, },
            {{83, 83, 396}, },
            {{83, 83, 397}, },
            {},
            {{84, 84, 398}, },
            {{84, 84, 399}, },
            {{84, 84, 400}, },
            {{65, 65, 401}, },
            {},
            {},
            {{79, 79, 402}, },
            {{78, 78, 403}, },
            {{82, 82, 404}, },
            {{78, 78, 405}, },
            {{82, 82, 406}, },
            {},
            {},
            {{73, 73, 407}, },
            {{73, 73, 408}, },
            {{73, 73, 409}, },
            {{84, 84, 410}, },
            {{78, 78, 411}, },
            {{82, 82, 412}, },
            {{78, 78, 413}, },
            {{82, 82, 414}, },
            {},
            {},
            {{73, 73, 415}, },
            {{73, 73, 416}, },
            {{73, 73, 417}, },
            {{84, 84, 418}, },
            {{78, 78, 419}, },
            {{83, 83, 420}, },
            {{73, 73, 421}, },
            {{83, 83, 422}, },
            {{73, 73, 423}, },
            {{79, 79, 424}, },
            {{79, 79, 425}, },
            {{79, 79, 426}, },
            {{73, 73, 427}, },
            {{83, 83, 428}, },
            {{73, 73, 429}, },
            {{83, 83, 430}, },
            {{73, 73, 431}, },
            {{79, 79, 432}, },
            {{79, 79, 433}, },
            {{79, 79, 434}, },
            {{73, 73, 435}, },
            {},
            {{84, 84, 436}, },
            {{65, 65, 437}, },
            {{84, 84, 438}, },
            {{65, 65, 439}, },
            {{78, 78, 440}, },
            {{78, 78, 441}, },
            {{78, 78, 442}, },
            {{79, 79, 443}, },
            {{84, 84, 444}, },
            {{65, 65, 445}, },
            {{84, 84, 446}, },
            {{65, 65, 447}, },
            {{78, 78, 448}, },
            {{78, 78, 449}, },
            {{78, 78, 450}, },
            {{79, 79, 451}, },
            {{65, 65, 452}, },
            {{66, 66, 453}, },
            {{65, 65, 454}, },
            {{66, 66, 455}, },
            {},
            {},
            {},
            {{78, 78, 456}, },
            {{65, 65, 457}, },
            {{66, 66, 458}, },
            {{65, 65, 459}, },
            {{66, 66, 460}, },
            {},
            {},
            {},
            {{78, 78, 461}, },
            {{78, 78, 462}, },
            {{76, 76, 463}, },
            {{78, 78, 464}, },
            {{76, 76, 465}, },
            {{83, 83, 466}, },
            {{78, 78, 467}, },
            {{76, 76, 468}, },
            {{78, 78, 469}, },
            {{76, 76, 470}, },
            {{83, 83, 471}, },
            {{84, 84, 472}, },
            {{69, 69, 473}, },
            {{84, 84, 474}, },
            {{69, 69, 475}, },
            {},
            {{84, 84, 476}, },
            {{69, 69, 477}, },
            {{84, 84, 478}, },
            {{69, 69, 479}, },
            {},
            {{83, 83, 480}, },
            {{83, 83, 481}, },
            {{83, 83, 482}, },
            {{83, 83, 483}, },
            {{83, 83, 484}, },
            {{83, 83, 485}, },
            {{83, 83, 486}, },
            {{83, 83, 487}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {},
        }
        { // DEFINITIONS
            {{0, 32, 1}, {34, 34, 2}, {40, 40, 3}, {41, 41, 4}, {44, 44, 5}, {47, 47, 6}, {59, 59, 7}, {61, 61, 8}, {65, 65, 9}, {66, 66, 10}, {67, 67, 11}, {68, 68, 10}, {69, 69, 12}, {70, 72, 10}, {73, 73, 13}, {74, 75, 10}, {76, 76, 14}, {77, 77, 15}, {78, 78, 10}, {79, 79, 16}, {80, 80, 17}, {81, 81, 10}, {82, 82, 18}, {83, 83, 19}, {84, 84, 10}, {85, 85, 20}, {86, 86, 21}, {87, 90, 10}, {97, 122, 22}, {127, 160, 1}, {8206, 8207, 1}, {8232, 8233, 1}, },
            {{0, 32, 1}, {127, 8233, -2}, },
            {},
            {},
            {},
            {},
            {{42, 42, 23}, },
            {},
            {{61, 61, 24}, },
            {{48, 57, 25}, {65, 65, 26}, {66, 66, 27}, {67, 82, 26}, {83, 83, 28}, {84, 90, 26}, {95, 95, 29}, {97, 122, 30}, },
            {{48, 57, 25}, {65, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 78, 26}, {79, 79, 31}, {80, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 77, 26}, {78, 78, 32}, {79, 85, 26}, {86, 86, 33}, {87, 87, 26}, {88, 88, 34}, {89, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 76, 26}, {77, 77, 35}, {78, 78, 36}, {79, 90, 26}, {95, 122, -11}, },
            {{48, 78, -13}, {79, 79, 37}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 65, 38}, {66, 78, 26}, {79, 79, 39}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 79, 26}, {80, 80, 40}, {81, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 81, 26}, {82, 82, 41}, {83, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 68, 26}, {69, 69, 42}, {70, 90, 26}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 43}, {70, 88, 26}, {89, 89, 44}, {90, 90, 26}, {95, 122, -11}, },
            {{48, 57, 25}, {65, 82, 26}, {83, 83, 45}, {84, 122, -11}, },
            {{48, 57, 25}, {65, 65, 46}, {66, 90, 26}, {95, 122, -11}, },
            {{48, 122, -12}, },
            {},
            {},
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 47}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 48}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 49}, {79, 122, -15}, },
            {{48, 57, 25}, {65, 67, 26}, {68, 68, 50}, {69, 90, 26}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 51}, {70, 122, -20}, },
            {{48, 57, 25}, {65, 83, 26}, {84, 84, 52}, {85, 90, 26}, {95, 122, -11}, },
            {{48, 79, -18}, {80, 80, 53}, {81, 122, -18}, },
            {{48, 57, 25}, {65, 66, 26}, {67, 67, 54}, {68, 72, 26}, {73, 73, 55}, {74, 85, 26}, {86, 86, 56}, {87, 90, 26}, {95, 122, -11}, },
            {{48, 66, -38}, {67, 67, 57}, {68, 90, 26}, {95, 122, -11}, },
            {{48, 66, -38}, {67, 67, 58}, {68, 122, -39}, },
            {{48, 67, -34}, {68, 68, 59}, {69, 122, -34}, },
            {{48, 68, -20}, {69, 69, 60}, {70, 122, -20}, },
            {{48, 78, -13}, {79, 79, 61}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 69, 26}, {70, 70, 62}, {71, 90, 26}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 63}, {70, 83, 26}, {84, 84, 64}, {85, 122, -36}, },
            {{48, 82, -22}, {83, 83, 65}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 66}, {70, 122, -20}, },
            {{48, 57, 25}, {65, 75, 26}, {76, 76, 67}, {77, 81, 26}, {82, 82, 68}, {83, 122, -19}, },
            {{48, 83, -36}, {84, 84, 69}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 70}, {70, 122, -20}, },
            {{48, 66, -38}, {67, 67, 71}, {68, 82, 26}, {83, 83, 72}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 73}, {79, 122, -15}, },
            {{48, 68, -20}, {69, 69, 74}, {70, 122, -20}, },
            {{48, 75, -48}, {76, 76, 75}, {77, 78, 26}, {79, 79, 76}, {80, 122, -13}, },
            {{48, 75, -48}, {76, 76, 77}, {77, 90, 26}, {95, 122, -11}, },
            {{48, 83, -36}, {84, 84, 78}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 79}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 65, 80}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 71, 26}, {72, 72, 81}, {73, 90, 26}, {95, 122, -11}, },
            {{48, 68, -20}, {69, 69, 82}, {70, 122, -20}, },
            {{48, 81, -19}, {82, 82, 83}, {83, 122, -19}, },
            {{48, 76, -15}, {77, 77, 84}, {78, 79, 26}, {80, 80, 85}, {81, 122, -18}, },
            {{48, 57, 25}, {65, 72, 26}, {73, 73, 86}, {74, 90, 26}, {95, 122, -11}, },
            {{48, 82, -22}, {83, 83, 87}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 88}, {84, 122, -11}, },
            {{48, 83, -36}, {84, 84, 89}, {85, 122, -36}, },
            {{48, 82, -22}, {83, 83, 90}, {84, 122, -11}, },
            {{48, 57, 25}, {65, 84, 26}, {85, 85, 91}, {86, 90, 26}, {95, 122, -11}, },
            {{48, 72, -64}, {73, 73, 92}, {74, 122, -64}, },
            {{48, 81, -19}, {82, 82, 93}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 94}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 95}, {83, 122, -19}, },
            {{48, 83, -36}, {84, 84, 96}, {85, 122, -36}, },
            {{48, 83, -36}, {84, 84, 97}, {85, 122, -36}, },
            {{48, 77, -14}, {78, 78, 98}, {79, 122, -15}, },
            {{48, 68, -20}, {69, 69, 99}, {70, 122, -20}, },
            {{48, 81, -19}, {82, 82, 100}, {83, 122, -19}, },
            {{48, 84, -69}, {85, 85, 101}, {86, 122, -69}, },
            {{48, 72, -64}, {73, 73, 102}, {74, 122, -64}, },
            {{48, 81, -19}, {82, 82, 103}, {83, 122, -19}, },
            {{48, 75, -48}, {76, 76, 104}, {77, 122, -56}, },
            {{48, 72, -64}, {73, 73, 105}, {74, 122, -64}, },
            {{48, 75, -48}, {76, 76, 106}, {77, 122, -56}, },
            {{48, 57, 25}, {65, 65, 107}, {66, 122, -23}, },
            {{48, 78, -13}, {79, 79, 108}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 109}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 110}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 111}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 112}, {70, 122, -20}, },
            {{48, 57, 25}, {65, 65, 113}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 65, 114}, {66, 122, -23}, },
            {{48, 83, -36}, {84, 84, 115}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 116}, {70, 122, -20}, },
            {{48, 57, 25}, {65, 65, 117}, {66, 81, 26}, {82, 82, 118}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 119}, {84, 122, -11}, },
            {{48, 67, -34}, {68, 68, 120}, {69, 122, -34}, },
            {{48, 76, -15}, {77, 77, 121}, {78, 90, 26}, {95, 122, -11}, },
            {{48, 83, -36}, {84, 84, 122}, {85, 122, -36}, },
            {{48, 67, -34}, {68, 68, 123}, {69, 122, -34}, },
            {{48, 57, 25}, {65, 65, 124}, {66, 122, -23}, },
            {{48, 72, -64}, {73, 73, 125}, {74, 122, -64}, },
            {{48, 90, -12}, {95, 95, 126}, {97, 122, 30}, },
            {{48, 77, -14}, {78, 78, 127}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 83, -36}, {84, 84, 128}, {85, 122, -36}, },
            {{48, 83, -36}, {84, 84, 129}, {85, 122, -36}, },
            {{48, 81, -19}, {82, 82, 130}, {83, 122, -19}, },
            {{48, 68, -20}, {69, 69, 131}, {70, 122, -20}, },
            {{48, 76, -15}, {77, 77, 132}, {78, 122, -101}, },
            {{48, 82, -22}, {83, 83, 133}, {84, 122, -11}, },
            {{48, 65, -11}, {66, 66, 134}, {67, 90, 26}, {95, 122, -11}, },
            {{48, 66, -38}, {67, 67, 135}, {68, 122, -39}, },
            {{48, 72, -64}, {73, 73, 136}, {74, 122, -64}, },
            {{48, 83, -36}, {84, 84, 137}, {85, 122, -36}, },
            {{48, 77, -14}, {78, 78, 138}, {79, 122, -15}, },
            {{48, 57, 25}, {65, 65, 139}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 140}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 141}, {70, 122, -20}, },
            {{48, 82, -22}, {83, 83, 142}, {84, 122, -11}, },
            {{48, 68, -20}, {69, 69, 143}, {70, 122, -20}, },
            {{48, 75, -48}, {76, 76, 144}, {77, 122, -56}, },
            {{48, 57, 25}, {65, 65, 145}, {66, 122, -23}, },
            {{48, 78, -13}, {79, 79, 146}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 147}, {70, 122, -20}, },
            {{48, 72, -64}, {73, 73, 148}, {74, 122, -64}, },
            {{48, 68, -20}, {69, 69, 149}, {70, 122, -20}, },
            {{48, 83, -36}, {84, 84, 150}, {85, 122, -36}, },
            {{48, 76, -15}, {77, 77, 151}, {78, 82, 26}, {83, 83, 152}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 75, -48}, {76, 76, 153}, {77, 122, -56}, },
            {{48, 83, -36}, {84, 84, 154}, {85, 122, -36}, },
            {{48, 78, -13}, {79, 79, 155}, {80, 122, -13}, },
            {{48, 68, -20}, {69, 69, 156}, {70, 122, -20}, },
            {{48, 83, -36}, {84, 84, 157}, {85, 122, -36}, },
            {{48, 72, -64}, {73, 73, 158}, {74, 122, -64}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 159}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 160}, {84, 122, -11}, },
            {{48, 72, -64}, {73, 73, 161}, {74, 122, -64}, },
            {{48, 77, -14}, {78, 78, 162}, {79, 122, -15}, },
            {{48, 79, -18}, {80, 80, 163}, {81, 122, -18}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 164}, {80, 122, -13}, },
            {{48, 82, -22}, {83, 83, 165}, {84, 122, -11}, },
            {{48, 72, -64}, {73, 73, 166}, {74, 122, -64}, },
            {{48, 68, -20}, {69, 69, 167}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 168}, {70, 122, -20}, },
            {{48, 90, -12}, {95, 95, 169}, {97, 122, 30}, },
            {{48, 77, -14}, {78, 78, 170}, {79, 122, -15}, },
            {{48, 90, -12}, {95, 95, 171}, {97, 122, 30}, },
            {{48, 82, -22}, {83, 83, 172}, {84, 122, -11}, },
            {{48, 77, -14}, {78, 78, 173}, {79, 122, -15}, },
            {{48, 83, -36}, {84, 84, 174}, {85, 122, -36}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 175}, {84, 89, 26}, {90, 90, 176}, {95, 122, -11}, },
            {{48, 83, -36}, {84, 84, 177}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 178}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 179}, {79, 122, -15}, },
            {{48, 122, -12}, },
            {{48, 68, -20}, {69, 69, 180}, {70, 122, -20}, },
            {{48, 77, -14}, {78, 78, 181}, {79, 122, -15}, },
            {{48, 82, -22}, {83, 83, 182}, {84, 122, -11}, },
            {{48, 66, -38}, {67, 67, 183}, {68, 85, 26}, {86, 86, 184}, {87, 122, -38}, },
            {{48, 82, -22}, {83, 83, 185}, {84, 122, -11}, },
            {{48, 66, -38}, {67, 67, 186}, {68, 85, 26}, {86, 86, 187}, {87, 122, -38}, },
            {{48, 122, -12}, },
            {{48, 83, -36}, {84, 84, 188}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 189}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 65, 190}, {66, 122, -23}, },
            {{48, 57, 25}, {65, 65, 191}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 81, -19}, {82, 82, 192}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 193}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 194}, {84, 122, -11}, },
            {{48, 83, -36}, {84, 84, 195}, {85, 122, -36}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 196}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 65, 197}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 78, -13}, {79, 79, 198}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 65, 199}, {66, 122, -23}, },
            {{48, 82, -22}, {83, 83, 200}, {84, 122, -11}, },
            {{48, 83, -36}, {84, 84, 201}, {85, 122, -36}, },
            {{48, 83, -36}, {84, 84, 202}, {85, 122, -36}, },
            {{48, 83, -36}, {84, 84, 203}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 204}, {66, 122, -23}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 205}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 206}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 207}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 208}, {83, 122, -19}, },
            {{48, 122, -12}, },
            {{48, 72, -64}, {73, 73, 209}, {74, 122, -64}, },
            {{48, 72, -64}, {73, 73, 210}, {74, 122, -64}, },
            {{48, 72, -64}, {73, 73, 211}, {74, 122, -64}, },
            {{48, 83, -36}, {84, 84, 212}, {85, 122, -36}, },
            {{48, 82, -22}, {83, 83, 213}, {84, 122, -11}, },
            {{48, 72, -64}, {73, 73, 214}, {74, 122, -64}, },
            {{48, 82, -22}, {83, 83, 215}, {84, 122, -11}, },
            {{48, 72, -64}, {73, 73, 216}, {74, 122, -64}, },
            {{48, 78, -13}, {79, 79, 217}, {80, 122, -13}, },
            {{48, 78, -13}, {79, 79, 218}, {80, 122, -13}, },
            {{48, 78, -13}, {79, 79, 219}, {80, 122, -13}, },
            {{48, 72, -64}, {73, 73, 220}, {74, 122, -64}, },
            {{48, 83, -36}, {84, 84, 221}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 222}, {66, 122, -23}, },
            {{48, 83, -36}, {84, 84, 223}, {85, 122, -36}, },
            {{48, 57, 25}, {65, 65, 224}, {66, 122, -23}, },
            {{48, 77, -14}, {78, 78, 225}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 226}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 227}, {79, 122, -15}, },
            {{48, 78, -13}, {79, 79, 228}, {80, 122, -13}, },
            {{48, 57, 25}, {65, 65, 229}, {66, 122, -23}, },
            {{48, 65, -11}, {66, 66, 230}, {67, 122, -115}, },
            {{48, 57, 25}, {65, 65, 231}, {66, 122, -23}, },
            {{48, 65, -11}, {66, 66, 232}, {67, 122, -115}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 77, -14}, {78, 78, 233}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 234}, {79, 122, -15}, },
            {{48, 75, -48}, {76, 76, 235}, {77, 122, -56}, },
            {{48, 77, -14}, {78, 78, 236}, {79, 122, -15}, },
            {{48, 75, -48}, {76, 76, 237}, {77, 122, -56}, },
            {{48, 82, -22}, {83, 83, 238}, {84, 122, -11}, },
            {{48, 83, -36}, {84, 84, 239}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 240}, {70, 122, -20}, },
            {{48, 83, -36}, {84, 84, 241}, {85, 122, -36}, },
            {{48, 68, -20}, {69, 69, 242}, {70, 122, -20}, },
            {{48, 122, -12}, },
            {{48, 82, -22}, {83, 83, 243}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 244}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 245}, {84, 122, -11}, },
            {{48, 82, -22}, {83, 83, 246}, {84, 122, -11}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
            {{48, 122, -12}, },
        }
        { // DEFINITIONS_RHS
            {{0, 32, 1}, {33, 33, 2}, {34, 34, 3}, {35, 39, 2}, {40, 40, 4}, {41, 41, 5}, {42, 46, 2}, {47, 47, 6}, {48, 58, 2}, {59, 59, 7}, {60, 64, 2}, {65, 65, 8}, {66, 66, 9}, {67, 67, 10}, {68, 68, 11}, {69, 69, 12}, {70, 72, 11}, {73, 73, 13}, {74, 75, 11}, {76, 76, 14}, {77, 77, 15}, {78, 78, 11}, {79, 79, 16}, {80, 80, 17}, {81, 81, 11}, {82, 82, 18}, {83, 83, 19}, {84, 84, 11}, {85, 85, 20}, {86, 86, 21}, {87, 87, 22}, {88, 90, 11}, {91, 96, 2}, {97, 122, 23}, {123, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 1}, {127, 160, 1}, {8206, 8207, 1}, {8232, 8233, 1}, },
            {},
            {{0, 33, 24}, {34, 34, 25}, {35, 65535, 24}, },
            {},
            {},
            {{42, 42, 26}, },
            {},
            {{48, 57, 27}, {65, 65, 28}, {66, 66, 29}, {67, 77, 28}, {78, 78, 30}, {79, 82, 28}, {83, 83, 31}, {84, 90, 28}, {95, 95, 32}, {97, 122, 33}, },
            {{48, 57, 27}, {65, 68, 28}, {69, 69, 34}, {70, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 65, 35}, {66, 71, 28}, {72, 72, 36}, {73, 78, 28}, {79, 79, 37}, {80, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 77, 28}, {78, 78, 38}, {79, 85, 28}, {86, 86, 39}, {87, 87, 28}, {88, 88, 40}, {89, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 69, 28}, {70, 70, 41}, {71, 76, 28}, {77, 77, 42}, {78, 78, 43}, {79, 90, 28}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 44}, {70, 78, 28}, {79, 79, 45}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 65, 46}, {66, 78, 28}, {79, 79, 47}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 79, 28}, {80, 80, 48}, {81, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 81, 28}, {82, 82, 49}, {83, 90, 28}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 50}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 51}, {70, 88, 28}, {89, 89, 52}, {90, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 82, 28}, {83, 83, 53}, {84, 122, -10}, },
            {{48, 57, 27}, {65, 65, 54}, {66, 90, 28}, {95, 122, -10}, },
            {{48, 57, 27}, {65, 71, 28}, {72, 72, 55}, {73, 90, 28}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{0, 65535, -5}, },
            {},
            {},
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 56}, {84, 122, -10}, },
            {{48, 57, 27}, {65, 88, 28}, {89, 89, 57}, {90, 122, -21}, },
            {{48, 82, -22}, {83, 83, 58}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 57, 27}, {65, 70, 28}, {71, 71, 59}, {72, 90, 28}, {95, 122, -10}, },
            {{48, 82, -22}, {83, 83, 60}, {84, 122, -10}, },
            {{48, 57, 27}, {65, 78, 28}, {79, 79, 61}, {80, 122, -12}, },
            {{48, 77, -14}, {78, 78, 62}, {79, 122, -15}, },
            {{48, 57, 27}, {65, 67, 28}, {68, 68, 63}, {69, 90, 28}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 64}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 83, 28}, {84, 84, 65}, {85, 90, 28}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 79, -18}, {80, 80, 66}, {81, 122, -18}, },
            {{48, 57, 27}, {65, 66, 28}, {67, 67, 67}, {68, 72, 28}, {73, 73, 68}, {74, 85, 28}, {86, 86, 69}, {87, 90, 28}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 70}, {85, 122, -42}, },
            {{48, 66, -45}, {67, 67, 71}, {68, 90, 28}, {95, 122, -10}, },
            {{48, 66, -45}, {67, 67, 72}, {68, 122, -47}, },
            {{48, 67, -40}, {68, 68, 73}, {69, 122, -40}, },
            {{48, 68, -11}, {69, 69, 74}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 75}, {70, 78, 28}, {79, 79, 76}, {80, 122, -12}, },
            {{48, 69, -15}, {70, 70, 77}, {71, 90, 28}, {95, 122, -10}, },
            {{48, 68, -11}, {69, 69, 78}, {70, 75, 28}, {76, 76, 79}, {77, 83, 28}, {84, 84, 80}, {85, 122, -42}, },
            {{48, 82, -22}, {83, 83, 81}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 82}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 75, 28}, {76, 76, 83}, {77, 81, 28}, {82, 82, 84}, {83, 122, -19}, },
            {{48, 57, 27}, {65, 72, 28}, {73, 73, 85}, {74, 90, 28}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 86}, {85, 122, -42}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 87}, {70, 122, -11}, },
            {{48, 72, -57}, {73, 73, 88}, {74, 122, -57}, },
            {{48, 68, -11}, {69, 69, 89}, {70, 122, -11}, },
            {{48, 72, -57}, {73, 73, 90}, {74, 122, -57}, },
            {{48, 66, -45}, {67, 67, 91}, {68, 82, 28}, {83, 83, 92}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 93}, {79, 122, -15}, },
            {{48, 68, -11}, {69, 69, 94}, {70, 122, -11}, },
            {{48, 75, -56}, {76, 76, 95}, {77, 78, 28}, {79, 79, 96}, {80, 122, -12}, },
            {{48, 75, -56}, {76, 76, 97}, {77, 90, 28}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 98}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 99}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 57, 27}, {65, 65, 100}, {66, 122, -23}, },
            {{48, 71, -24}, {72, 72, 101}, {73, 122, -24}, },
            {{48, 68, -11}, {69, 69, 102}, {70, 122, -11}, },
            {{48, 81, -19}, {82, 82, 103}, {83, 122, -19}, },
            {{48, 122, -13}, },
            {{48, 57, 27}, {65, 76, 28}, {77, 77, 104}, {78, 79, 28}, {80, 80, 105}, {81, 122, -18}, },
            {{48, 72, -57}, {73, 73, 106}, {74, 122, -57}, },
            {{48, 82, -22}, {83, 83, 107}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 108}, {70, 122, -11}, },
            {{48, 82, -22}, {83, 83, 109}, {84, 122, -10}, },
            {{48, 83, -42}, {84, 84, 110}, {85, 122, -42}, },
            {{48, 82, -22}, {83, 83, 111}, {84, 122, -10}, },
            {{48, 57, 27}, {65, 84, 28}, {85, 85, 112}, {86, 90, 28}, {95, 122, -10}, },
            {{48, 72, -57}, {73, 73, 113}, {74, 122, -57}, },
            {{48, 75, -56}, {76, 76, 114}, {77, 122, -69}, },
            {{48, 81, -19}, {82, 82, 115}, {83, 122, -19}, },
            {{48, 81, -19}, {82, 82, 116}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 117}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 66, -45}, {67, 67, 118}, {68, 122, -47}, },
            {{48, 81, -19}, {82, 82, 119}, {83, 122, -19}, },
            {{48, 83, -42}, {84, 84, 120}, {85, 122, -42}, },
            {{48, 83, -42}, {84, 84, 121}, {85, 122, -42}, },
            {{48, 77, -14}, {78, 78, 122}, {79, 122, -15}, },
            {{48, 68, -11}, {69, 69, 123}, {70, 122, -11}, },
            {{48, 81, -19}, {82, 82, 124}, {83, 122, -19}, },
            {{48, 84, -85}, {85, 85, 125}, {86, 122, -85}, },
            {{48, 72, -57}, {73, 73, 126}, {74, 122, -57}, },
            {{48, 81, -19}, {82, 82, 127}, {83, 122, -19}, },
            {{48, 75, -56}, {76, 76, 128}, {77, 122, -69}, },
            {{48, 72, -57}, {73, 73, 129}, {74, 122, -57}, },
            {{48, 75, -56}, {76, 76, 130}, {77, 122, -69}, },
            {{48, 57, 27}, {65, 65, 131}, {66, 122, -23}, },
            {{48, 78, -38}, {79, 79, 132}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 133}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 134}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 66, -45}, {67, 67, 135}, {68, 122, -47}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 136}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 137}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 65, 138}, {66, 122, -23}, },
            {{48, 68, -11}, {69, 69, 139}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 65, 140}, {66, 122, -23}, },
            {{48, 83, -42}, {84, 84, 141}, {85, 122, -42}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 142}, {70, 122, -11}, },
            {{48, 68, -11}, {69, 69, 143}, {70, 122, -11}, },
            {{48, 57, 27}, {65, 65, 144}, {66, 81, 28}, {82, 82, 145}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 146}, {84, 122, -10}, },
            {{48, 67, -40}, {68, 68, 147}, {69, 122, -40}, },
            {{48, 76, -78}, {77, 77, 148}, {78, 90, 28}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 149}, {85, 122, -42}, },
            {{48, 67, -40}, {68, 68, 150}, {69, 122, -40}, },
            {{48, 57, 27}, {65, 65, 151}, {66, 122, -23}, },
            {{48, 72, -57}, {73, 73, 152}, {74, 122, -57}, },
            {{48, 90, -13}, {95, 95, 153}, {97, 122, 33}, },
            {{48, 77, -14}, {78, 78, 154}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 83, -42}, {84, 84, 155}, {85, 122, -42}, },
            {{48, 83, -42}, {84, 84, 156}, {85, 122, -42}, },
            {{48, 81, -19}, {82, 82, 157}, {83, 122, -19}, },
            {{48, 68, -11}, {69, 69, 158}, {70, 122, -11}, },
            {{48, 83, -42}, {84, 84, 159}, {85, 122, -42}, },
            {{48, 76, -78}, {77, 77, 160}, {78, 122, -125}, },
            {{48, 82, -22}, {83, 83, 161}, {84, 122, -10}, },
            {{48, 65, -10}, {66, 66, 162}, {67, 90, 28}, {95, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 66, -45}, {67, 67, 163}, {68, 122, -47}, },
            {{48, 72, -57}, {73, 73, 164}, {74, 122, -57}, },
            {{48, 122, -13}, },
            {{48, 83, -42}, {84, 84, 165}, {85, 122, -42}, },
            {{48, 77, -14}, {78, 78, 166}, {79, 122, -15}, },
            {{48, 57, 27}, {65, 65, 167}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 168}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 169}, {70, 122, -11}, },
            {{48, 82, -22}, {83, 83, 170}, {84, 122, -10}, },
            {{48, 68, -11}, {69, 69, 171}, {70, 122, -11}, },
            {{48, 75, -56}, {76, 76, 172}, {77, 122, -69}, },
            {{48, 57, 27}, {65, 65, 173}, {66, 122, -23}, },
            {{48, 78, -38}, {79, 79, 174}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 175}, {70, 122, -11}, },
            {{48, 72, -57}, {73, 73, 176}, {74, 122, -57}, },
            {{48, 68, -11}, {69, 69, 177}, {70, 122, -11}, },
            {{48, 83, -42}, {84, 84, 178}, {85, 122, -42}, },
            {{48, 76, -78}, {77, 77, 179}, {78, 82, 28}, {83, 83, 180}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 75, -56}, {76, 76, 181}, {77, 122, -69}, },
            {{48, 83, -42}, {84, 84, 182}, {85, 122, -42}, },
            {{48, 78, -38}, {79, 79, 183}, {80, 122, -12}, },
            {{48, 68, -11}, {69, 69, 184}, {70, 122, -11}, },
            {{48, 83, -42}, {84, 84, 185}, {85, 122, -42}, },
            {{48, 72, -57}, {73, 73, 186}, {74, 122, -57}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 187}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 188}, {84, 122, -10}, },
            {{48, 72, -57}, {73, 73, 189}, {74, 122, -57}, },
            {{48, 77, -14}, {78, 78, 190}, {79, 122, -15}, },
            {{48, 79, -18}, {80, 80, 191}, {81, 122, -18}, },
            {{48, 122, -13}, },
            {{48, 78, -38}, {79, 79, 192}, {80, 122, -12}, },
            {{48, 82, -22}, {83, 83, 193}, {84, 122, -10}, },
            {{48, 72, -57}, {73, 73, 194}, {74, 122, -57}, },
            {{48, 68, -11}, {69, 69, 195}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 196}, {70, 122, -11}, },
            {{48, 90, -13}, {95, 95, 197}, {97, 122, 33}, },
            {{48, 77, -14}, {78, 78, 198}, {79, 122, -15}, },
            {{48, 90, -13}, {95, 95, 199}, {97, 122, 33}, },
            {{48, 82, -22}, {83, 83, 200}, {84, 122, -10}, },
            {{48, 77, -14}, {78, 78, 201}, {79, 122, -15}, },
            {{48, 83, -42}, {84, 84, 202}, {85, 122, -42}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 203}, {84, 89, 28}, {90, 90, 204}, {95, 122, -10}, },
            {{48, 83, -42}, {84, 84, 205}, {85, 122, -42}, },
            {{48, 68, -11}, {69, 69, 206}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 207}, {79, 122, -15}, },
            {{48, 122, -13}, },
            {{48, 68, -11}, {69, 69, 208}, {70, 122, -11}, },
            {{48, 77, -14}, {78, 78, 209}, {79, 122, -15}, },
            {{48, 82, -22}, {83, 83, 210}, {84, 122, -10}, },
            {{48, 66, -45}, {67, 67, 211}, {68, 85, 28}, {86, 86, 212}, {87, 122, -45}, },
            {{48, 82, -22}, {83, 83, 213}, {84, 122, -10}, },
            {{48, 66, -45}, {67, 67, 214}, {68, 85, 28}, {86, 86, 215}, {87, 122, -45}, },
            {{48, 122, -13}, },
            {{48, 83, -42}, {84, 84, 216}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 217}, {66, 122, -23}, },
            {{48, 57, 27}, {65, 65, 218}, {66, 122, -23}, },
            {{48, 57, 27}, {65, 65, 219}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 81, -19}, {82, 82, 220}, {83, 122, -19}, },
            {{48, 82, -22}, {83, 83, 221}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 222}, {84, 122, -10}, },
            {{48, 83, -42}, {84, 84, 223}, {85, 122, -42}, },
            {{48, 122, -13}, },
            {{48, 78, -38}, {79, 79, 224}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 65, 225}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 78, -38}, {79, 79, 226}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 65, 227}, {66, 122, -23}, },
            {{48, 82, -22}, {83, 83, 228}, {84, 122, -10}, },
            {{48, 83, -42}, {84, 84, 229}, {85, 122, -42}, },
            {{48, 83, -42}, {84, 84, 230}, {85, 122, -42}, },
            {{48, 83, -42}, {84, 84, 231}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 232}, {66, 122, -23}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 233}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 234}, {83, 122, -19}, },
            {{48, 77, -14}, {78, 78, 235}, {79, 122, -15}, },
            {{48, 81, -19}, {82, 82, 236}, {83, 122, -19}, },
            {{48, 122, -13}, },
            {{48, 72, -57}, {73, 73, 237}, {74, 122, -57}, },
            {{48, 72, -57}, {73, 73, 238}, {74, 122, -57}, },
            {{48, 72, -57}, {73, 73, 239}, {74, 122, -57}, },
            {{48, 83, -42}, {84, 84, 240}, {85, 122, -42}, },
            {{48, 82, -22}, {83, 83, 241}, {84, 122, -10}, },
            {{48, 72, -57}, {73, 73, 242}, {74, 122, -57}, },
            {{48, 82, -22}, {83, 83, 243}, {84, 122, -10}, },
            {{48, 72, -57}, {73, 73, 244}, {74, 122, -57}, },
            {{48, 78, -38}, {79, 79, 245}, {80, 122, -12}, },
            {{48, 78, -38}, {79, 79, 246}, {80, 122, -12}, },
            {{48, 78, -38}, {79, 79, 247}, {80, 122, -12}, },
            {{48, 72, -57}, {73, 73, 248}, {74, 122, -57}, },
            {{48, 83, -42}, {84, 84, 249}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 250}, {66, 122, -23}, },
            {{48, 83, -42}, {84, 84, 251}, {85, 122, -42}, },
            {{48, 57, 27}, {65, 65, 252}, {66, 122, -23}, },
            {{48, 77, -14}, {78, 78, 253}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 254}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 255}, {79, 122, -15}, },
            {{48, 78, -38}, {79, 79, 256}, {80, 122, -12}, },
            {{48, 57, 27}, {65, 65, 257}, {66, 122, -23}, },
            {{48, 65, -10}, {66, 66, 258}, {67, 122, -140}, },
            {{48, 57, 27}, {65, 65, 259}, {66, 122, -23}, },
            {{48, 65, -10}, {66, 66, 260}, {67, 122, -140}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 77, -14}, {78, 78, 261}, {79, 122, -15}, },
            {{48, 77, -14}, {78, 78, 262}, {79, 122, -15}, },
            {{48, 75, -56}, {76, 76, 263}, {77, 122, -69}, },
            {{48, 77, -14}, {78, 78, 264}, {79, 122, -15}, },
            {{48, 75, -56}, {76, 76, 265}, {77, 122, -69}, },
            {{48, 82, -22}, {83, 83, 266}, {84, 122, -10}, },
            {{48, 83, -42}, {84, 84, 267}, {85, 122, -42}, },
            {{48, 68, -11}, {69, 69, 268}, {70, 122, -11}, },
            {{48, 83, -42}, {84, 84, 269}, {85, 122, -42}, },
            {{48, 68, -11}, {69, 69, 270}, {70, 122, -11}, },
            {{48, 122, -13}, },
            {{48, 82, -22}, {83, 83, 271}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 272}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 273}, {84, 122, -10}, },
            {{48, 82, -22}, {83, 83, 274}, {84, 122, -10}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
            {{48, 122, -13}, },
        }
        { // DEFINITION_FILE
            {{0, 32, 1}, {33, 33, 2}, {34, 34, 3}, {35, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 33, -2}, {35, 65535, -2}, },
            {{0, 33, 2}, {35, 65535, 2}, },
            {},
        }
        { // NO_DEFINITIONS
            {{0, 32, 1}, {33, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 65535, -2}, },
            {{0, 65535, 2}, },
        }
        { // COMMENT
            {{0, 32, 1}, {33, 41, 2}, {42, 42, 3}, {43, 126, 2}, {127, 160, 1}, {161, 8205, 2}, {8206, 8207, 1}, {8208, 8231, 2}, {8232, 8233, 1}, {8234, 65535, 2}, },
            {{0, 32, 4}, {127, 160, 4}, {8206, 8207, 4}, {8232, 8233, 4}, },
            {},
            {{47, 47, 5}, },
            {{0, 8233, -3}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // NORMAL
        {-1, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, 4, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, 7, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, 4, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, 4, -1, 4, -1, -1, -1, -1, 4, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, 4, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, 7, -1, -1, 7, -1, -1, 7, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, 4, 4, 4, -1, -1, 7, -1, -1, -1, -1, 7, -1, -1, -1, -1, 7, 7, -1, -1, -1, -1, -1, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, 4, 4, -1, -1, -1, -1, -1, 7, 7, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, 4, 4, 4, 4, 7, 7, 7, 7, },
        // DEFINITIONS
        {-1, 22, 19, 10, 11, 12, -1, 18, -1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 13, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 5, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 4, 4, 9, 4, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 4, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 4, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 4, 4, 9, 9, 9, 9, 9, 9, 4, 9, 4, 9, 9, 9, 9, 4, 9, 9, 9, 9, 4, 9, 9, 9, 9, 9, 9, 9, 4, 9, 9, 9, 9, 4, 9, 9, 9, 9, 9, 9, 4, 9, 9, 9, 9, 4, 9, 9, 9, 9, 4, 9, 9, 4, 9, 9, 9, 9, 9, 9, 9, 4, 4, 4, 9, 9, 9, 9, 4, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 4, 4, 4, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 4, 9, 9, 9, 9, 4, 4, 4, 4, },
        // DEFINITIONS_RHS
        {-1, 22, 14, 14, 10, 11, 14, 18, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, -1, 14, 0, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 15, 17, 17, 17, 17, 17, 16, 17, 17, 17, 17, 17, 17, 15, 17, 17, 17, 17, 15, 17, 17, 17, 17, 17, 17, 17, 17, 15, 17, 17, 17, 17, 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 4, 17, 4, 17, 4, 17, 17, 17, 17, 17, 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 4, 17, 17, 17, 17, 17, 17, 17, 17, 15, 17, 15, 15, 17, 17, 17, 4, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 15, 4, 4, 17, 17, 17, 17, 17, 17, 4, 17, 4, 17, 17, 17, 17, 4, 17, 17, 17, 17, 4, 17, 17, 17, 17, 17, 17, 17, 4, 17, 17, 17, 17, 4, 17, 17, 17, 17, 17, 17, 4, 17, 17, 17, 17, 4, 17, 17, 17, 17, 4, 17, 17, 4, 17, 17, 17, 17, 17, 17, 17, 4, 4, 4, 17, 17, 17, 17, 4, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 4, 4, 4, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 4, 17, 17, 17, 17, 4, 4, 4, 4, },
        // DEFINITION_FILE
        {20, 20, 20, 19, },
        // NO_DEFINITIONS
        {8, 8, 8, },
        // COMMENT
        {-1, 2, 2, 2, 22, 1, },

    };*/

    public static class State
    {
        public final static State NORMAL = new State(0);
        public final static State DEFINITIONS = new State(1);
        public final static State DEFINITIONS_RHS = new State(2);
        public final static State DEFINITION_FILE = new State(3);
        public final static State NO_DEFINITIONS = new State(4);
        public final static State COMMENT = new State(5);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
