/* An Functional Mock-up Interface Type.

 Copyright (c) 2012 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package org.ptolemy.fmi.type;

import org.w3c.dom.Element;

///////////////////////////////////////////////////////////////////
//// FMIType

/**
 * An base class for Functional Mock-up Interface types like Real.
 * 
 * <p>FMI documentation may be found at
 * <a href="http://www.modelisar.com/fmi.html">http://www.modelisar.com/fmi.html</a>.
 * </p>
 * 
 * @author Christopher Brooks
 * @version $Id: FMIType.java 63411 2012-04-23 03:58:05Z cxh $
 * @Pt.ProposedRating Red (cxh)
 * @Pt.AcceptedRating Red (cxh)
 */
public abstract class FMIType {

    /** Construct a variable.
     *  @param name The name of this variable.
     *  @param description A description of this variable.
     *  @param element The XML Element that may contain a "fixed" element.
     */
    public FMIType(String name, String description, Element element) {
        this.name = name;
        this.description = description;
        if (element.hasAttribute("fixed")) {
            fixed = Boolean.valueOf(element.getAttribute("fixed"));
        }
    }

    ///////////////////////////////////////////////////////////////////
    ////             public methods                                ////

    /** Return the string value of the base element.
     *  @return The string value.
     */
    abstract public String toString();

    ///////////////////////////////////////////////////////////////////
    ////             public fields                                 ////

    /** A description of the type. */
    public String description;

    // FIXME: describe what this means.
    /** True if the value is fixed. */
    public boolean fixed;

    /** The name of the type. */
    public String name;
}
