/* This file was generated by SableCC (http://www.sablecc.org/). */

package de.prob.core.sablecc.lexer;

import java.io.*;
import java.util.*;
import de.prob.core.sablecc.node.*;
import de.hhu.stups.sablecc.patch.*;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressWarnings({"unused"}) 
public class Lexer implements ITokenListContainer
{
    protected Token token;
    protected State state = State.INIT;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    
	private List<IToken> tokenList;
    private final Queue<IToken> nextList = new LinkedBlockingQueue<IToken>();

	private IToken tok;

    public Queue<IToken> getNextList() {
        return nextList;
    }

	public List<IToken> getTokenList() {
		return tokenList;
	}
	
	private void setToken(Token t) {
	  tok = t;
   	  token = t;	
	}
	
	
	public void setTokenList(final List<IToken> list) {
		tokenList = list;
	}

     
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    protected void filterWrap() throws LexerException, IOException
    {
       filter();
       if (token != null) {
	          getTokenList().add(token); 
              nextList.add(token);
	   }
    }


    public Lexer(  PushbackReader in)
    {
        this.in = in;
    	setTokenList(new ArrayList<IToken>());
    }
    
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        return (Token) nextList.peek();
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.setToken(getToken());
            filterWrap();
        }

        Token result = (Token) nextList.poll();
        this.setToken(null);
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

          int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
          int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                              Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.INIT; break;
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                              Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                              Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                              Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                              Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.EXCEPTION; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                              Token token = new5(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                              Token token = new6(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                              Token token = new7(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                              Token token = new8(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                              Token token = new9(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                              Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                              Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                              Token token = new12(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                              Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.EXCEPTION; break;
                            }
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                      EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(  String text,   int line,   int pos) { return new TWhiteSpace(text, line, pos); }
    Token new1(  int line,   int pos) { return new TNo(line, pos); }
    Token new2(  int line,   int pos) { return new TYes(line, pos); }
    Token new3(  int line,   int pos) { return new TInterrupted(line, pos); }
    Token new4(  int line,   int pos) { return new TException(line, pos); }
    Token new5(  String text,   int line,   int pos) { return new TComma(text, line, pos); }
    Token new6(  String text,   int line,   int pos) { return new TLPar(text, line, pos); }
    Token new7(  String text,   int line,   int pos) { return new TRPar(text, line, pos); }
    Token new8(  String text,   int line,   int pos) { return new TLSq(text, line, pos); }
    Token new9(  String text,   int line,   int pos) { return new TRSq(text, line, pos); }
    Token new10(  String text,   int line,   int pos) { return new TNumber(text, line, pos); }
    Token new11(  String text,   int line,   int pos) { return new TName(text, line, pos); }
    Token new12(  String text,   int line,   int pos) { return new TVariable(text, line, pos); }
    Token new13(  String text,   int line,   int pos) { return new TString(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(  Token token) throws IOException
    {
          String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INIT
            {{10, 10, 1}, {13, 13, 2}, {101, 101, 3}, {105, 105, 4}, {110, 110, 5}, {121, 121, 6}, },
            {{10, 13, -2}, },
            {{10, 13, -2}, },
            {{120, 120, 7}, },
            {{110, 110, 8}, },
            {{111, 111, 9}, },
            {{101, 101, 10}, },
            {{99, 99, 11}, },
            {{116, 116, 12}, },
            {},
            {{115, 115, 13}, },
            {{101, 101, 14}, },
            {{101, 101, 15}, },
            {},
            {{112, 112, 16}, },
            {{114, 114, 17}, },
            {{116, 116, 18}, },
            {{114, 114, 19}, },
            {{105, 105, 20}, },
            {{117, 117, 21}, },
            {{111, 111, 22}, },
            {{112, 112, 23}, },
            {{110, 110, 24}, },
            {{116, 116, 25}, },
            {},
            {{101, 101, 26}, },
            {{100, 100, 27}, },
            {},
        }
        { // NORMAL
            {{10, 10, 1}, {13, 13, 2}, {33, 33, 3}, {35, 35, 4}, {36, 36, 5}, {38, 38, 6}, {39, 39, 7}, {40, 40, 8}, {41, 41, 9}, {42, 42, 10}, {43, 43, 11}, {44, 44, 12}, {45, 45, 13}, {46, 46, 14}, {47, 47, 15}, {48, 57, 16}, {58, 58, 17}, {59, 59, 18}, {60, 60, 19}, {61, 61, 20}, {62, 62, 21}, {63, 63, 22}, {64, 64, 23}, {65, 90, 24}, {91, 91, 25}, {92, 92, 26}, {93, 93, 27}, {94, 94, 28}, {95, 95, 29}, {97, 122, 30}, {123, 123, 31}, {126, 126, 32}, {170, 170, 33}, {186, 186, 34}, {192, 214, 24}, {216, 222, 24}, {223, 246, 35}, {248, 255, 36}, },
            {{10, 13, -2}, },
            {{10, 13, -2}, },
            {},
            {{35, 38, -2}, {42, 43, -2}, {45, 45, 37}, {46, 47, -2}, {58, 58, 17}, {60, 64, -2}, {92, 92, 26}, {94, 94, 28}, {126, 126, 32}, },
            {{35, 126, -6}, },
            {{35, 126, -6}, },
            {{0, 38, 38}, {39, 39, 39}, {40, 91, 38}, {92, 92, 40}, {93, 65535, 38}, },
            {},
            {},
            {{35, 126, -6}, },
            {{35, 126, -6}, },
            {},
            {{35, 47, -6}, {48, 57, 41}, {58, 126, -6}, },
            {{35, 126, -6}, },
            {{35, 126, -6}, },
            {{48, 57, 16}, },
            {{35, 126, -6}, },
            {},
            {{35, 126, -6}, },
            {{35, 126, -6}, },
            {{35, 126, -6}, },
            {{35, 126, -6}, },
            {{35, 126, -6}, },
            {{48, 57, 42}, {65, 90, 43}, {95, 95, 44}, {97, 122, 45}, {170, 170, 46}, {186, 186, 47}, {192, 214, 43}, {216, 222, 43}, {223, 246, 48}, {248, 255, 49}, },
            {{93, 93, 50}, },
            {{35, 126, -6}, },
            {},
            {{35, 126, -6}, },
            {{48, 57, 51}, {65, 90, 52}, {95, 95, 53}, {97, 122, 54}, {170, 170, 55}, {186, 186, 56}, {192, 214, 52}, {216, 222, 52}, {223, 246, 57}, {248, 255, 58}, },
            {{48, 57, 59}, {65, 90, 60}, {95, 95, 61}, {97, 122, 62}, {170, 170, 63}, {186, 186, 64}, {192, 214, 60}, {216, 222, 60}, {223, 246, 65}, {248, 255, 66}, },
            {{125, 125, 67}, },
            {{35, 126, -6}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{35, 126, -6}, },
            {{0, 65535, -9}, },
            {},
            {{10, 10, 68}, {34, 34, 69}, {39, 39, 70}, {48, 55, 71}, {92, 92, 72}, {96, 96, 73}, {97, 97, 74}, {98, 98, 75}, {100, 100, 76}, {101, 101, 77}, {102, 102, 78}, {110, 110, 79}, {114, 114, 80}, {116, 116, 81}, {118, 118, 82}, {120, 120, 83}, },
            {{48, 57, 41}, },
            {{48, 255, -26}, },
            {{48, 255, -26}, },
            {{48, 255, -26}, },
            {{48, 255, -26}, },
            {{48, 255, -26}, },
            {{48, 255, -26}, },
            {{48, 255, -26}, },
            {{48, 255, -26}, },
            {},
            {{48, 255, -31}, },
            {{48, 255, -31}, },
            {{48, 255, -31}, },
            {{48, 255, -31}, },
            {{48, 255, -31}, },
            {{48, 255, -31}, },
            {{48, 255, -31}, },
            {{48, 255, -31}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {{48, 255, -32}, },
            {},
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 39, -9}, {40, 47, 38}, {48, 55, 84}, {56, 91, 38}, {92, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{0, 65535, -9}, },
            {{48, 57, 85}, {65, 70, 85}, {97, 102, 85}, },
            {{0, 65535, -73}, },
            {{48, 70, -85}, {92, 92, 86}, {97, 102, 85}, },
            {{0, 65535, -9}, },
        }
        { // EXCEPTION
            {{0, 65535, 1}, },
            {{0, 65535, 1}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INIT
        {0, 0, 0, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, 3, },
        // NORMAL
        {0, 0, 0, 11, 11, 11, 11, -1, 6, 7, 11, 11, 5, 11, 11, 11, 10, 11, 11, 11, 11, 11, 11, 11, 12, 8, 11, 9, 11, 12, 11, -1, 11, 11, 11, 11, 11, 11, -1, 11, -1, 10, 12, 12, 12, 12, 12, 12, 12, 12, 11, 12, 12, 12, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, },
        // EXCEPTION
        {13, 13, },

    };*/

    public static class State
    {
        public final static State INIT = new State(0);
        public final static State NORMAL = new State(1);
        public final static State EXCEPTION = new State(2);

        private int id;

        private State(  int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
