/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.worksheet;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import de.prob.web.WebUtils;
import de.prob.web.worksheet.BindingsSnapshot;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class VariableDetailTransformer
implements Function<Map.Entry<String, Object>, Map<String, String>> {
    private static final Set<String> processed = new HashSet<String>();
    private final BindingsSnapshot previous_snapshot;
    private final BindingsSnapshot current_snapshot;

    public static void clear() {
        processed.clear();
    }

    public VariableDetailTransformer(BindingsSnapshot previous_snapshot, BindingsSnapshot current_snapshot) {
        this.previous_snapshot = previous_snapshot;
        this.current_snapshot = current_snapshot;
    }

    public Map<String, String> apply(Map.Entry<String, Object> input) {
        Object value = input.getValue();
        Class<?> clazz = value.getClass();
        String className = clazz.getName();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", input.getKey());
        result.put("value", value.toString());
        result.put("clazz", className);
        result.put("supertype", clazz.getSuperclass().getName());
        if (!processed.contains(className)) {
            result.put("attributes", this.getAttributes(clazz));
            result.put("methods", this.getMethods(clazz));
        }
        result.put("fresh", String.valueOf(this.current_snapshot.delta(this.previous_snapshot).contains(input.getKey())));
        processed.add(className);
        return result;
    }

    private String getMethods(Class<? extends Object> clazz) {
        Method[] declaredMethods;
        Method[] methods;
        ArrayList<CMethod> result = new ArrayList<CMethod>();
        for (Method method : methods = clazz.getMethods()) {
            result.add(new CMethod(method, false));
        }
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            result.add(new CMethod(method, true));
        }
        return WebUtils.toJson(result);
    }

    private String getAttributes(Class<? extends Object> clazz) {
        Field[] fields;
        Field[] declaredFields;
        ArrayList<CAttribute> result = new ArrayList<CAttribute>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            result.add(new CAttribute(field, true));
        }
        for (Field field : fields = clazz.getFields()) {
            result.add(new CAttribute(field, false));
        }
        return WebUtils.toJson(result);
    }

    private static class CAttribute {
        public final String name;
        public final String type;
        public final boolean isAccessible;
        public final boolean isStatic;

        public CAttribute(Field f, boolean isStatic) {
            this.isStatic = isStatic;
            this.name = f.getName();
            this.type = f.getType().getSimpleName();
            this.isAccessible = f.isAccessible();
        }
    }

    private class CMethod {
        public final boolean isStatic;
        public final String name;
        public final String returntype;
        public final boolean isAccessible;
        public final Collection<String> parameterTypes;
        public final String declaringClass;
        public final Collection<String> exceptions;
        private final Function<Class<?>, String> classToSimpleNameTransformer = new Function<Class<?>, String>(){

            public String apply(Class<?> input) {
                return input.getSimpleName();
            }
        };

        public CMethod(Method m, boolean isStatic) {
            this.isStatic = isStatic;
            this.name = m.getName();
            this.returntype = m.getReturnType().getSimpleName();
            this.isAccessible = m.isAccessible();
            this.declaringClass = m.getDeclaringClass().getName();
            List<Class<?>> exc = Arrays.asList(m.getExceptionTypes());
            this.exceptions = Collections2.transform(exc, this.classToSimpleNameTransformer);
            List<Class<?>> ptc = Arrays.asList(m.getParameterTypes());
            this.parameterTypes = Collections2.transform(ptc, this.classToSimpleNameTransformer);
        }
    }
}

