/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.worksheet;

import com.google.common.io.Files;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.EvalstoreCreateByStateCommand;
import de.prob.statespace.StateSpace;
import de.prob.web.FileBrowserServlet;
import de.prob.web.worksheet.AbstractBox;
import de.prob.web.worksheet.BindingsSnapshot;
import de.prob.web.worksheet.EChangeEffect;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class LoadModel
extends AbstractBox {
    private String content;

    @Override
    public void setContent(Map<String, String[]> data) {
        this.content = data.get("text")[0];
    }

    @Override
    public List<Object> render(BindingsSnapshot snapshot) {
        File file = new File(this.content);
        if (!FileBrowserServlet.validFile(file, "prob")) {
            return this.pack(this.makeHtml(this.id, "<span class='illegal_file'> Not a valid ProB file. </span>"));
        }
        String name = this.load_file(file.getAbsolutePath());
        return this.pack(this.makeHtml(this.id, "<b>" + this.content + " has been loaded and stored in " + name + " </b>"));
    }

    private String load_file(String filename) {
        ScriptEngine groovy = this.owner.getGroovy();
        String command = "";
        String name = "statespace";
        String extension = Files.getFileExtension((String)filename);
        if (extension.equals("mch") || extension.equals("ref") || extension.equals("imp")) {
            command = "api.b_load('" + filename + "')";
        }
        if (extension.equals("eventb")) {
            command = "api.eb_load('" + filename + "')";
        }
        if (extension.equals("csp")) {
            command = "api.csp_load('" + filename + "')";
        }
        if (!command.equals("")) {
            try {
                StateSpace statespace = (StateSpace)groovy.eval(command);
                EvalstoreCreateByStateCommand c = new EvalstoreCreateByStateCommand("root");
                statespace.execute((AbstractCommand)c);
                long store = c.getEvalstoreId();
                Bindings bindings = groovy.getBindings(200);
                bindings.put(name, (Object)statespace);
                bindings.put("store", (Object)store);
                return name;
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
        return "ERROR";
    }

    @Override
    protected String getContentAsJson() {
        return this.content;
    }

    @Override
    protected String getTemplate() {
        return "/ui/worksheet/boxes/load_model.html";
    }

    @Override
    protected boolean useCodemirror() {
        return false;
    }

    @Override
    public EChangeEffect changeEffect() {
        return EChangeEffect.EVERYTHING_BELOW;
    }
}

