/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import de.prob.annotations.PublicSession;
import de.prob.web.AbstractSession;
import de.prob.web.WebUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;

@PublicSession
@Singleton
public class Shoutbox
extends AbstractSession {
    private final List<Shout> texts = new ArrayList<Shout>();

    @Inject
    public Shoutbox() {
        this.incrementalUpdate = false;
    }

    public Object addText(Map<String, String[]> params) {
        String text = params.get("text")[0];
        Shout shout = new Shout(text);
        this.texts.add(shout);
        return WebUtils.wrap("cmd", "Shoutbox.append", "line", WebUtils.toJson(shout));
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/shoutbox/index.html");
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        Map<String, String> wrap = WebUtils.wrap("cmd", "Shoutbox.setText", "texts", WebUtils.toJson(this.texts));
        this.submit(wrap);
    }

    private static class Shout {
        public final String text;
        public final Date time;

        public Shout(String text) {
            this.text = text;
            this.time = Calendar.getInstance().getTime();
        }
    }
}

