/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import de.prob.animator.domainobjects.StateError;
import de.prob.annotations.OneToOne;
import de.prob.annotations.PublicSession;
import de.prob.model.eventb.Event;
import de.prob.model.eventb.EventParameter;
import de.prob.model.representation.AbstractElement;
import de.prob.model.representation.AbstractModel;
import de.prob.model.representation.BEvent;
import de.prob.model.representation.Machine;
import de.prob.model.representation.ModelElementList;
import de.prob.scripting.ScriptEngineProvider;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.State;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.WebUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.servlet.AsyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSession
@OneToOne
public class Events
extends AbstractAnimationBasedView {
    Logger logger = LoggerFactory.getLogger(Events.class);
    Trace currentTrace;
    AbstractModel currentModel;
    List<String> opNames = new ArrayList<String>();
    Map<String, List<String>> opToParams = new HashMap<String, List<String>>();
    Comparator<Operation> sorter = new ModelOrder(new ArrayList<String>());
    List<Operation> events = new ArrayList<Operation>();
    private String filter = "";
    boolean hide = false;
    private final ScriptEngine groovy;

    @Inject
    public Events(AnimationSelector selector, ScriptEngineProvider sep) {
        super(selector);
        this.groovy = sep.get();
        this.incrementalUpdate = false;
        this.animationsRegistry.registerAnimationChangeListener((IAnimationChangeListener)this);
    }

    @Override
    public void performTraceChange(Trace trace) {
        if (trace == null) {
            this.currentTrace = null;
            this.currentModel = null;
            this.opNames = new ArrayList<String>();
            if (this.sorter instanceof ModelOrder) {
                this.sorter = new ModelOrder(this.opNames);
            }
            Map<String, String> wrap = WebUtils.wrap("cmd", "Events.newTrace", "ops", WebUtils.toJson(this.opNames), "canGoBack", false, "canGoForward", false, "errors", "[]");
            this.submit(wrap);
            return;
        }
        if (trace.getModel() != this.currentModel) {
            this.updateModel(trace);
        }
        this.currentTrace = trace;
        Set ops = this.currentTrace.getNextTransitions(true);
        this.events = new ArrayList<Operation>(ops.size());
        HashSet<String> notEnabled = new HashSet<String>(this.opNames);
        Set tWT = this.currentTrace.getCurrentState().getTransitionsWithTimeout();
        for (Transition opInfo : ops) {
            String name = this.extractPrettyName(opInfo.getName());
            notEnabled.remove(name);
            Operation o = new Operation(opInfo.getId(), name, opInfo.getParams(), true, tWT.contains(name));
            this.events.add(o);
        }
        for (String s : notEnabled) {
            if (s.equals("INITIALISATION")) continue;
            this.events.add(new Operation(s, s, this.opToParams.get(s), false, tWT.contains(s)));
        }
        try {
            Collections.sort(this.events, this.sorter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Error> errors = this.extractErrors(this.currentTrace.getCurrentState());
        String json = WebUtils.toJson(this.applyFilter(this.filter));
        String stringErrors = WebUtils.toJson(errors);
        Map<String, String> wrap = WebUtils.wrap("cmd", "Events.newTrace", "ops", json, "canGoBack", this.currentTrace.canGoBack(), "canGoForward", this.currentTrace.canGoForward(), "errors", stringErrors);
        this.submit(wrap);
    }

    private List<Error> extractErrors(State state) {
        ArrayList<Error> errors = new ArrayList<Error>();
        if (!state.isInvariantOk()) {
            errors.add(new Error("Invariant Violation", "One of the invariants was violated. See the State Inspector for more details."));
        }
        if (state.isTimeoutOccurred()) {
            errors.add(new Error("Timeout Occurred", "A time out occurred for the current state."));
        }
        if (state.isMaxTransitionsCalculated()) {
            errors.add(new Error("Max Transitions Reached", "It is possible that not all possible transitions were calculated for the given state. If you would like to calculate more transitions, increase the MAX_OPERATIONS preference."));
        }
        for (StateError e : state.getStateErrors()) {
            errors.add(new Error(e.getShortDescription(), "For event " + e.getEvent() + " the following error occurred: " + e.getLongDescription()));
        }
        return errors;
    }

    private String extractPrettyName(String name) {
        if ("$setup_constants".equals(name)) {
            return "SETUP_CONSTANTS";
        }
        if ("$initialise_machine".equals(name)) {
            return "INITIALISATION";
        }
        return name;
    }

    private void updateModel(Trace trace) {
        this.currentModel = trace.getModel();
        AbstractElement mainComponent = trace.getStateSpace().getMainComponent();
        this.opNames = new ArrayList<String>();
        this.opToParams = new HashMap<String, List<String>>();
        if (mainComponent instanceof Machine) {
            ModelElementList events = mainComponent.getChildrenOfType(BEvent.class);
            for (BEvent e : events) {
                this.opNames.add(e.getName());
                ArrayList<String> pList = new ArrayList<String>();
                if (e instanceof Event) {
                    for (EventParameter eP : ((Event)e).getParameters()) {
                        pList.add(eP.getName());
                    }
                } else if (e instanceof de.prob.model.classicalb.Operation) {
                    pList.addAll(((de.prob.model.classicalb.Operation)e).getParameters());
                }
                this.opToParams.put(e.getName(), pList);
            }
        }
        if (this.sorter instanceof ModelOrder) {
            this.sorter = new ModelOrder(this.opNames);
        }
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/eventview/index.html");
    }

    public Object execute(Map<String, String[]> params) {
        String id = params.get("id")[0];
        this.animationsRegistry.traceChange(this.currentTrace.add(id));
        return null;
    }

    public Object executeEvent(Map<String, String[]> params) {
        String event = params.get("event")[0];
        String code = "t = animations.getCurrentTrace();t1 = execTrace(t) { " + event + "};" + "animations.replaceTrace(t,t1)";
        try {
            this.groovy.eval(code);
        }
        catch (ScriptException e) {
            this.logger.error("Not able to execute event " + event + " for current trace. " + e.getMessage());
        }
        return null;
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        Map<String, String> wrap = WebUtils.wrap("cmd", "Events.setView", "ops", WebUtils.toJson(this.events), "canGoBack", this.currentTrace == null ? false : this.currentTrace.canGoBack(), "canGoForward", this.currentTrace == null ? false : this.currentTrace.canGoForward(), "sortMode", this.getSortMode(), "hide", this.hide, "errors", this.currentTrace == null ? "[]" : WebUtils.toJson(this.extractErrors(this.currentTrace.getCurrentState())));
        this.submit(wrap);
    }

    public Object random(Map<String, String[]> params) {
        int num = Integer.parseInt(params.get("num")[0]);
        this.animationsRegistry.traceChange(this.currentTrace.randomAnimation(num));
        return null;
    }

    public Object back(Map<String, String[]> params) {
        this.animationsRegistry.traceChange(this.currentTrace.back());
        return null;
    }

    public Object forward(Map<String, String[]> params) {
        this.animationsRegistry.traceChange(this.currentTrace.forward());
        return null;
    }

    public Object sort(Map<String, String[]> params) {
        String mode = params.get("sortMode")[0];
        if ("normal".equals(mode)) {
            this.sorter = new ModelOrder(this.opNames);
        } else if ("aToZ".equals(mode)) {
            this.sorter = new AtoZ();
        } else if ("zToA".equals(mode)) {
            this.sorter = new ZtoA();
        }
        Collections.sort(this.events, this.sorter);
        return WebUtils.wrap("cmd", "Events.setContent", "ops", WebUtils.toJson(this.applyFilter(this.filter)));
    }

    public String getSortMode() {
        if (this.sorter instanceof ModelOrder) {
            return "normal";
        }
        if (this.sorter instanceof AtoZ) {
            return "aToZ";
        }
        if (this.sorter instanceof ZtoA) {
            return "zToA";
        }
        return "other";
    }

    public Object filter(Map<String, String[]> params) {
        this.filter = params.get("filter")[0];
        List<Operation> filteredEvents = this.applyFilter(this.filter);
        return WebUtils.wrap("cmd", "Events.setContent", "ops", WebUtils.toJson(filteredEvents));
    }

    public Object hide(Map<String, String[]> params) {
        this.hide = Boolean.valueOf(params.get("hidden")[0]);
        return null;
    }

    private List<Operation> applyFilter(String filter) {
        ArrayList<Operation> newOps = new ArrayList<Operation>();
        for (Operation op : this.events) {
            if (!op.name.startsWith(filter)) continue;
            newOps.add(op);
        }
        return newOps;
    }

    public void animatorStatus(boolean busy) {
        if (busy) {
            this.submit(WebUtils.wrap("cmd", "Events.disable"));
        } else {
            this.submit(WebUtils.wrap("cmd", "Events.enable"));
        }
    }

    private class ZtoA
    extends EventComparator
    implements Comparator<Operation> {
        private ZtoA() {
        }

        @Override
        public int compare(Operation o1, Operation o2) {
            if (o1.name.compareTo(o2.name) == 0) {
                return this.compareParams(o1.params, o2.params);
            }
            return -1 * o1.name.compareTo(o2.name);
        }
    }

    private class AtoZ
    extends EventComparator
    implements Comparator<Operation> {
        private AtoZ() {
        }

        @Override
        public int compare(Operation o1, Operation o2) {
            if (o1.name.compareTo(o2.name) == 0) {
                return this.compareParams(o1.params, o2.params);
            }
            return o1.name.compareTo(o2.name);
        }
    }

    private class ModelOrder
    extends EventComparator
    implements Comparator<Operation> {
        private final List<String> ops;

        public ModelOrder(List<String> ops) {
            this.ops = ops;
        }

        @Override
        public int compare(Operation o1, Operation o2) {
            if (this.ops.contains(o1.name) && this.ops.contains(o2.name) && this.ops.indexOf(o1.name) == this.ops.indexOf(o2.name)) {
                return this.compareParams(o1.params, o2.params);
            }
            return this.ops.indexOf(o1.name) - this.ops.indexOf(o2.name);
        }
    }

    private class EventComparator {
        private EventComparator() {
        }

        private String stripString(String param) {
            return param.replaceAll("\\{", "").replaceAll("\\}", "");
        }

        public int compareParams(List<String> params1, List<String> params2) {
            for (int i = 0; i < params1.size(); ++i) {
                String p2;
                String p1 = this.stripString(params1.get(i));
                if (p1.compareTo(p2 = this.stripString(params2.get(i))) == 0) continue;
                return p1.compareTo(p2);
            }
            return 0;
        }
    }

    private static class Error {
        public final String shortMsg;
        public final String longMsg;

        public Error(String shortMsg, String longMsg) {
            this.shortMsg = shortMsg;
            this.longMsg = longMsg;
        }
    }

    private static class Operation {
        public final String name;
        public final List<String> params;
        public final String id;
        public final String enablement;

        public Operation(String id, String name, List<String> params, boolean isEnabled, boolean hasTimeout) {
            this.id = id;
            this.name = name;
            this.params = params;
            this.enablement = isEnabled ? "enabled" : (hasTimeout ? "timeout" : "notEnabled");
        }
    }
}

