/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import de.prob.annotations.OneToOne;
import de.prob.annotations.PublicSession;
import de.prob.servlet.Main;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.IModelChangedListener;
import de.prob.web.AbstractAnimationBasedView;
import de.prob.web.ISession;
import de.prob.web.data.SessionResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReflectionServlet
extends HttpServlet {
    public static final String URL_PATTERN = "/sessions/";
    Logger logger = LoggerFactory.getLogger(ReflectionServlet.class);
    private final Map<Class<ISession>, Map<String, ISession>> instanceCache = new HashMap<Class<ISession>, Map<String, ISession>>();
    private final LoadingCache<String, ISession> sessions;
    private final ExecutorService taskExecutor = Executors.newFixedThreadPool(3);
    private final CompletionService<SessionResult> taskCompletionService = new ExecutorCompletionService<SessionResult>(this.taskExecutor);
    private static final String FQN = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private final AnimationSelector animations;

    @Inject
    public ReflectionServlet(AnimationSelector animations) {
        this.animations = animations;
        this.sessions = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemoveSessionListener()).build((CacheLoader)new CacheLoader<String, ISession>(){

            public ISession load(String key) throws Exception {
                return this.load(key);
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            SessionResult res;
                            Future message;
                            if ((message = ReflectionServlet.this.taskCompletionService.take()) == null || (res = (SessionResult)message.get()) == null || res.result == null || res.result.length <= 0) {
                                continue;
                            }
                            ReflectionServlet.this.logger.trace("Got Result in Queue: {}", res.result);
                            res.session.submit(res.result);
                        }
                    }
                    catch (Throwable e) {
                        ReflectionServlet.this.logger.error("Exception in result handling loop. Ignoring", e);
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getRequestURI();
        PartList parts = new PartList(uri.split("/"));
        String className = (String)parts.get(2);
        String session = (String)parts.get(3);
        boolean isUuid = this.isUUID(session);
        ISession sess = (ISession)this.sessions.getIfPresent((Object)session);
        if (!isUuid || sess == null) {
            Class<ISession> clazz = this.getClass(className);
            if (clazz == null) {
                resp.sendError(404);
                return;
            }
            this.logger.trace("Instantiating");
            ISession obj = this.instantiate(clazz, isUuid ? UUID.fromString(session) : null);
            this.logger.trace("Got the object");
            String id = obj.getSessionUUID().toString();
            if (this.sessions.getIfPresent((Object)id) == null) {
                this.sessions.put((Object)id, (Object)obj);
            }
            String rest = this.prepareExtraParameters(req);
            resp.sendRedirect(URL_PATTERN + className + "/" + id + rest);
            return;
        }
        this.delegateToSession(req, resp, sess);
    }

    private void delegateToSession(HttpServletRequest req, HttpServletResponse resp, ISession session) throws IOException {
        String mode = req.getParameter("mode");
        Map parameterMap = req.getParameterMap();
        if ("update".equals(mode)) {
            int lastinfo = Integer.parseInt(req.getParameter("lastinfo"));
            String client = req.getParameter("client");
            session.sendPendingUpdates(client, lastinfo, req.startAsync());
        } else if ("command".equals(mode)) {
            Callable<SessionResult> command = session.command(parameterMap);
            this.send(resp, "submitted");
            this.submit(command);
        } else {
            String id = UUID.randomUUID().toString();
            this.send(resp, session.html(id, parameterMap));
        }
    }

    public void submit(Callable<SessionResult> command) {
        this.taskCompletionService.submit(command);
    }

    private void send(HttpServletResponse resp, String html) throws IOException {
        PrintWriter writer = resp.getWriter();
        writer.write(html);
        writer.flush();
        writer.close();
    }

    private boolean isUUID(String arg) {
        if (arg == null) {
            return false;
        }
        try {
            UUID.fromString(arg);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private String prepareExtraParameters(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer("?");
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String name = (String)parameters.nextElement();
            String value = request.getParameter(name);
            sb.append(name);
            sb.append("=");
            sb.append(value);
            sb.append("&");
        }
        String rest = sb.substring(0, sb.length() - 1);
        return rest;
    }

    private ISession instantiate(Class<ISession> clazz, UUID uuid) throws IOException {
        Annotation[] annotations;
        boolean publicSession = false;
        boolean oneToOne = false;
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            if (annotation instanceof PublicSession) {
                publicSession = true;
            }
            if (!(annotation instanceof OneToOne)) continue;
            oneToOne = true;
        }
        ISession obj = null;
        if (!Main.restricted || publicSession) {
            if (oneToOne) {
                if (!this.instanceCache.containsKey(clazz)) {
                    this.instanceCache.put(clazz, new HashMap());
                }
                String key = null;
                key = Main.multianimation && uuid != null ? uuid.toString() : "DEFAULT";
                ISession iSession = this.instanceCache.get(clazz).get(key);
                if (iSession != null) {
                    return iSession;
                }
                obj = (ISession)Main.getInjector().getInstance(clazz);
                this.instanceCache.get(clazz).put(key, obj);
                if (Main.multianimation && obj instanceof AbstractAnimationBasedView && uuid != null) {
                    ((AbstractAnimationBasedView)obj).setAnimationOfInterest(uuid);
                }
            } else {
                obj = (ISession)Main.getInjector().getInstance(clazz);
            }
        }
        return obj;
    }

    private Class<ISession> getClass(String servletName) {
        if (!servletName.matches(FQN)) {
            servletName = "de.prob.web.views." + servletName;
        }
        Class<ISession> clazz = null;
        try {
            clazz = Class.forName(servletName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private class PartList
    extends ArrayList<String> {
        private static final long serialVersionUID = -5668244262489304794L;

        public PartList(String[] split) {
            super(Arrays.asList(split));
        }

        @Override
        public String get(int index) {
            if (index >= this.size()) {
                return "";
            }
            return (String)super.get(index);
        }
    }

    private class RemoveSessionListener
    implements RemovalListener<String, ISession> {
        private RemoveSessionListener() {
        }

        public void onRemoval(RemovalNotification<String, ISession> notification) {
            ISession session = (ISession)notification.getValue();
            if (session != null) {
                if (session instanceof IAnimationChangeListener) {
                    ReflectionServlet.this.animations.deregisterAnimationChangeListener((IAnimationChangeListener)session);
                }
                if (session instanceof IModelChangedListener) {
                    ReflectionServlet.this.animations.deregisterModelChangedListeners((IModelChangedListener)session);
                }
            }
        }
    }
}

