/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web;

import com.google.inject.Inject;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.Trace;
import de.prob.web.AbstractSession;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnimationBasedView
extends AbstractSession
implements IAnimationChangeListener {
    Logger logger = LoggerFactory.getLogger(AbstractAnimationBasedView.class);
    protected final AnimationSelector animationsRegistry;
    boolean multianimation;
    protected UUID animationOfInterest;

    @Inject
    public AbstractAnimationBasedView(AnimationSelector animations) {
        this.animationsRegistry = animations;
    }

    public void traceChange(Trace currentTrace, boolean currentAnimationChanged) {
        if (this.animationOfInterest != null) {
            this.performTraceChange(this.animationsRegistry.getTrace(this.animationOfInterest));
        } else if (this.animationOfInterest == null && currentAnimationChanged) {
            this.performTraceChange(currentTrace);
        }
    }

    public abstract void performTraceChange(Trace var1);

    public Trace getCurrentTrace() {
        return this.animationOfInterest == null ? this.animationsRegistry.getCurrentTrace() : this.animationsRegistry.getTrace(this.animationOfInterest);
    }

    public void setAnimationOfInterest(UUID animationOfInterest) {
        this.animationOfInterest = animationOfInterest;
        this.performTraceChange(this.animationsRegistry.getTrace(animationOfInterest));
    }

    public UUID getAnimationOfInterest() {
        return this.animationOfInterest;
    }
}

