/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.List;
import java.util.Map;
import org.spockframework.mock.IDefaultResponse;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.MockImplementation;
import org.spockframework.mock.MockNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockConfiguration
implements IMockConfiguration {
    private final String name;
    private final Class<?> type;
    private final MockNature nature;
    private final MockImplementation implementation;
    private final List<Object> constructorArgs;
    private final IDefaultResponse defaultResponse;
    private final boolean global;
    private final boolean verified;
    private final boolean useObjenesis;

    public MockConfiguration(String name, Class<?> type, MockNature nature, MockImplementation implementation, Map<String, Object> options) {
        this.name = this.getOption(options, "name", String.class, name);
        this.type = this.getOption(options, "type", Class.class, type);
        this.nature = this.getOption(options, "nature", MockNature.class, nature);
        this.implementation = this.getOption(options, "implementation", MockImplementation.class, implementation);
        this.constructorArgs = this.getOption(options, "constructorArgs", List.class, null);
        this.defaultResponse = this.getOption(options, "defaultResponse", IDefaultResponse.class, this.nature.getDefaultResponse());
        this.global = this.getOption(options, "global", Boolean.class, false);
        this.verified = this.getOption(options, "verified", Boolean.class, this.nature.isVerified());
        this.useObjenesis = this.getOption(options, "useObjenesis", Boolean.class, this.nature.isUseObjenesis());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public MockNature getNature() {
        return this.nature;
    }

    @Override
    public MockImplementation getImplementation() {
        return this.implementation;
    }

    @Override
    public List<Object> getConstructorArgs() {
        return this.constructorArgs;
    }

    @Override
    public IDefaultResponse getDefaultResponse() {
        return this.defaultResponse;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public boolean isUseObjenesis() {
        return this.useObjenesis;
    }

    private <T> T getOption(Map<String, Object> options, String key, Class<T> type, T defaultValue) {
        return options.containsKey(key) ? type.cast(options.get(key)) : defaultValue;
    }
}

