/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.InteractionNotSatisfiedError;
import org.spockframework.util.Assert;
import org.spockframework.util.HashMultiset;
import org.spockframework.util.IMultiset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooFewInvocationsError
extends InteractionNotSatisfiedError {
    private final List<IMockInteraction> interactions;
    private final List<IMockInvocation> unmatchedInvocations;
    private String message;

    public TooFewInvocationsError(List<IMockInteraction> interactions, List<IMockInvocation> unmatchedInvocations) {
        Assert.notNull(interactions);
        Assert.that(interactions.size() > 0);
        this.interactions = interactions;
        this.unmatchedInvocations = unmatchedInvocations;
    }

    public synchronized String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        HashMultiset<IMockInvocation> unmatchedMultiInvocations = new HashMultiset<IMockInvocation>(this.unmatchedInvocations);
        StringBuilder builder = new StringBuilder();
        for (IMockInteraction interaction : this.interactions) {
            builder.append("Too few invocations for:\n\n");
            builder.append(interaction);
            builder.append("\n\n");
            List<ScoredInvocation> scoredInvocations = this.scoreInvocations(interaction, unmatchedMultiInvocations);
            builder.append("Unmatched invocations (ordered by similarity):\n\n");
            if (scoredInvocations.isEmpty()) {
                builder.append("None\n");
            } else {
                for (ScoredInvocation invocation : scoredInvocations) {
                    builder.append(invocation.count);
                    builder.append(" * ");
                    builder.append(invocation.invocation);
                    builder.append('\n');
                }
            }
            builder.append('\n');
        }
        this.message = builder.toString();
        return this.message;
    }

    private List<ScoredInvocation> scoreInvocations(IMockInteraction interaction, IMultiset<IMockInvocation> invocations) {
        ArrayList<ScoredInvocation> result = new ArrayList<ScoredInvocation>();
        for (Map.Entry<IMockInvocation, Integer> entry : invocations.entrySet()) {
            result.add(new ScoredInvocation(entry.getKey(), entry.getValue(), interaction.computeSimilarityScore(entry.getKey())));
        }
        Collections.sort(result);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScoredInvocation
    implements Comparable<ScoredInvocation> {
        final IMockInvocation invocation;
        final int count;
        final int score;

        private ScoredInvocation(IMockInvocation invocation, int count, int score) {
            this.invocation = invocation;
            this.count = count;
            this.score = score;
        }

        @Override
        public int compareTo(ScoredInvocation other) {
            return this.score - other.score;
        }
    }
}

