/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.model;

import java.util.EnumSet;
import org.spockframework.compiler.model.AnonymousBlock;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.CleanupBlock;
import org.spockframework.compiler.model.ExpectBlock;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.SetupBlock;
import org.spockframework.compiler.model.ThenBlock;
import org.spockframework.compiler.model.WhenBlock;
import org.spockframework.compiler.model.WhereBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BlockParseInfo {
    AND{

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return method.getLastBlock().getParseInfo().getSuccessors(method);
        }

        @Override
        public Block addNewBlock(Method method) {
            return method.getLastBlock();
        }
    }
    ,
    ANONYMOUS{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new AnonymousBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(SETUP, new BlockParseInfo[]{GIVEN, EXPECT, WHEN, CLEANUP, WHERE, METHOD_END});
        }
    }
    ,
    SETUP{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new SetupBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, new BlockParseInfo[]{EXPECT, WHEN, CLEANUP, WHERE, METHOD_END});
        }
    }
    ,
    GIVEN{

        @Override
        public Block addNewBlock(Method method) {
            return SETUP.addNewBlock(method);
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return SETUP.getSuccessors(method);
        }
    }
    ,
    EXPECT{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new ExpectBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, WHEN, CLEANUP, WHERE, METHOD_END);
        }
    }
    ,
    WHEN{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new WhenBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, THEN);
        }
    }
    ,
    THEN{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new ThenBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, new BlockParseInfo[]{EXPECT, WHEN, THEN, CLEANUP, WHERE, METHOD_END});
        }
    }
    ,
    CLEANUP{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new CleanupBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, WHERE, METHOD_END);
        }
    }
    ,
    WHERE{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new WhereBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, METHOD_END);
        }
    }
    ,
    METHOD_END{

        @Override
        public Block addNewBlock(Method method) {
            throw new UnsupportedOperationException("addNewBlock");
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            throw new UnsupportedOperationException("getSuccessors");
        }

        @Override
        public String toString() {
            return "end-of-method";
        }
    };


    public String toString() {
        return super.toString().toLowerCase();
    }

    public abstract Block addNewBlock(Method var1);

    public abstract EnumSet<BlockParseInfo> getSuccessors(Method var1);
}

