/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.upgrade;

import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.BecomesEqualTo;
import org.eventb.core.ast.BecomesMemberOf;
import org.eventb.core.ast.BecomesSuchThat;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.DefaultSimpleVisitor;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.upgrade.UpgradeResult;
import org.eventb.internal.core.upgrade.VersionUpgrader;

class AssignmentUpgrader
extends DefaultSimpleVisitor {
    private final VersionUpgrader upg;
    private final UpgradeResult<Assignment> result;
    private final FormulaFactory factory;

    public AssignmentUpgrader(VersionUpgrader upg, UpgradeResult<Assignment> result) {
        this.upg = upg;
        this.result = result;
        this.factory = result.getFactory();
    }

    @Override
    public void visitBecomesEqualTo(BecomesEqualTo assignment) {
        FreeIdentifier[] idents = assignment.getAssignedIdentifiers();
        Expression[] exprs = assignment.getExpressions();
        FreeIdentifier[] upgIdents = this.upgradeIdentifiers(idents);
        Expression[] upgExprs = new Expression[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            upgExprs[i] = this.upgradeChild(exprs[i]);
        }
        BecomesEqualTo upgAssignment = this.factory.makeBecomesEqualTo(upgIdents, upgExprs, null);
        this.result.setUpgradedFormula(upgAssignment);
    }

    @Override
    public void visitBecomesMemberOf(BecomesMemberOf assignment) {
        FreeIdentifier[] idents = assignment.getAssignedIdentifiers();
        FreeIdentifier[] upgIdents = this.upgradeIdentifiers(idents);
        Expression set = assignment.getSet();
        Expression upgSet = this.upgradeChild(set);
        BecomesMemberOf upgAssignment = this.factory.makeBecomesMemberOf(upgIdents[0], upgSet, null);
        this.result.setUpgradedFormula(upgAssignment);
    }

    @Override
    public void visitBecomesSuchThat(BecomesSuchThat assignment) {
        FreeIdentifier[] idents = assignment.getAssignedIdentifiers();
        FreeIdentifier[] upgIdents = this.upgradeIdentifiers(idents);
        BoundIdentDecl[] primedIdents = assignment.getPrimedIdents();
        BoundIdentDecl[] upgPrimed = new BoundIdentDecl[primedIdents.length];
        for (int i = 0; i < primedIdents.length; ++i) {
            upgPrimed[i] = this.upgradeChild(primedIdents[i]);
        }
        Predicate condition = assignment.getCondition();
        Predicate upgCondition = this.upgradeChild(condition);
        BecomesSuchThat upgAssignment = this.factory.makeBecomesSuchThat(upgIdents, upgPrimed, upgCondition, null);
        this.result.setUpgradedFormula(upgAssignment);
    }

    private FreeIdentifier[] upgradeIdentifiers(FreeIdentifier[] identifiers) {
        FreeIdentifier[] newIdents = new FreeIdentifier[identifiers.length];
        for (int i = 0; i < identifiers.length; ++i) {
            newIdents[i] = this.upgradeChild(identifiers[i]);
        }
        return newIdents;
    }

    private <T extends Formula<T>> T upgradeChild(T formula) {
        UpgradeResult localResult = new UpgradeResult(this.result);
        this.upg.upgrade(formula, localResult);
        VersionUpgrader.copyProblems(localResult, this.result);
        return localResult.getUpgradedFormula();
    }
}

