/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.typecheck;

import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ISealedTypeEnvironment;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.FreshNameSolver;
import org.eventb.internal.core.ast.GivenTypeHelper;
import org.eventb.internal.core.typecheck.SealedTypeEnvironment;
import org.eventb.internal.core.typecheck.TypeEnvironment;

public class TypeEnvironmentBuilder
extends TypeEnvironment
implements ITypeEnvironmentBuilder {
    public TypeEnvironmentBuilder(FormulaFactory ff) {
        super(ff);
    }

    public TypeEnvironmentBuilder(TypeEnvironment typenv) {
        super(typenv);
    }

    @Override
    public void add(FreeIdentifier freeIdent) {
        this.addName(freeIdent.getName(), freeIdent.getType());
    }

    @Override
    public void addAll(ITypeEnvironment other) {
        if (other.getFormulaFactory() != this.ff) {
            throw new IllegalArgumentException("Incompatible formula factory: " + other.getFormulaFactory() + ", should be: " + this.ff);
        }
        Map<String, Type> otherMap = ((TypeEnvironment)other).map;
        for (Map.Entry<String, Type> entry : otherMap.entrySet()) {
            this.addName(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void addAll(FreeIdentifier[] freeIdents) {
        for (FreeIdentifier freeIdent : freeIdents) {
            this.add(freeIdent);
        }
    }

    @Override
    public void addGivenSet(String name) {
        this.addName(name, this.ff.makePowerSetType(this.ff.makeGivenType(name)));
    }

    private void addGivenSet(GivenType type) {
        this.addName(type.getName(), this.ff.makePowerSetType(type));
    }

    protected void setName(String name, Type type) {
        if (!GivenTypeHelper.isGivenSet(name, type)) {
            Set<GivenType> givenTypes = type.getGivenTypes();
            for (GivenType givenType : givenTypes) {
                if (!name.equals(givenType.getName())) continue;
                throw new IllegalArgumentException("Trying to add an invalid self-referring type: " + name);
            }
            for (GivenType givenType : givenTypes) {
                this.addGivenSet(givenType);
            }
        }
        this.map.put(name, type);
    }

    @Override
    public void addName(String name, Type type) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        if (!this.getFormulaFactory().isValidIdentifierName(name)) {
            throw new IllegalArgumentException(name + " is an invalid identifier name in current language");
        }
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        if (type.getFactory() != this.ff) {
            throw new IllegalArgumentException("Invalid formula factory for (" + name + " : " + type + "): " + type.getFactory() + ", should be: " + this.ff);
        }
        Type oldType = this.internalGetType(name);
        if (oldType != null && !oldType.equals(type)) {
            throw new IllegalArgumentException("Trying to register an existing name with a different type");
        }
        if (oldType == null) {
            this.setName(name, type);
        }
    }

    protected Type internalGetType(String name) {
        return (Type)this.map.get(name);
    }

    private FreeIdentifier makeFreshIdentifier(BoundIdentDecl bIdent, FreshNameSolver solver) {
        String bName = bIdent.getName();
        String fName = solver.solve(bName);
        Type type = bIdent.getType();
        this.addName(fName, type);
        SourceLocation sloc = bIdent.getSourceLocation();
        return this.ff.makeFreeIdentifier(fName, sloc, type);
    }

    @Override
    public FreeIdentifier[] makeFreshIdentifiers(BoundIdentDecl[] bIdents) {
        int nbBoundIdentDecl = bIdents.length;
        FreeIdentifier[] result = new FreeIdentifier[nbBoundIdentDecl];
        FreshNameSolver solver = new FreshNameSolver(this);
        for (int i = 0; i < nbBoundIdentDecl; ++i) {
            result[i] = this.makeFreshIdentifier(bIdents[i], solver);
        }
        return result;
    }

    @Override
    public ISealedTypeEnvironment makeSnapshot() {
        return new SealedTypeEnvironment(this);
    }

    @Override
    public ITypeEnvironmentBuilder translate(FormulaFactory factory) {
        if (factory == this.ff) {
            return this;
        }
        return this.doTranslate(factory);
    }
}

