/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.typecheck;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BooleanType;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.IInferredTypeEnvironment;
import org.eventb.core.ast.ISealedTypeEnvironment;
import org.eventb.core.ast.ITypeCheckResult;
import org.eventb.core.ast.ITypeEnvironment;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.internal.core.ast.AbstractResult;
import org.eventb.internal.core.ast.GivenTypeHelper;
import org.eventb.internal.core.typecheck.InferredTypeEnvironment;
import org.eventb.internal.core.typecheck.SealedTypeEnvironment;
import org.eventb.internal.core.typecheck.TypeEnvironment;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class TypeCheckResult
extends AbstractResult
implements ITypeCheckResult {
    private final FormulaFactory factory;
    private final SealedTypeEnvironment initialTypeEnvironment;
    private final InferredTypeEnvironment inferredTypeEnvironment;
    private final List<TypeVariable> typeVariables;
    private final TypeUnifier unifier;

    public TypeCheckResult(ISealedTypeEnvironment typeEnvironment) {
        this.initialTypeEnvironment = (SealedTypeEnvironment)typeEnvironment;
        this.factory = this.initialTypeEnvironment.getFormulaFactory();
        this.unifier = new TypeUnifier(this);
        this.inferredTypeEnvironment = new InferredTypeEnvironment((ITypeEnvironment)this.initialTypeEnvironment);
        this.typeVariables = new ArrayList<TypeVariable>();
    }

    public final Type getIdentType(FreeIdentifier ident) {
        String name = ident.getName();
        Type result = this.initialTypeEnvironment.getType(name);
        if (result != null) {
            return result;
        }
        result = this.inferredTypeEnvironment.getType(name);
        if (result != null) {
            return result;
        }
        result = this.newFreshVariable(ident.getSourceLocation());
        this.inferredTypeEnvironment.addName(name, result);
        return result;
    }

    @Override
    public final IInferredTypeEnvironment getInferredEnvironment() {
        if (!this.isSuccess()) {
            return null;
        }
        return this.inferredTypeEnvironment;
    }

    @Override
    public final ITypeEnvironment getInitialTypeEnvironment() {
        return this.initialTypeEnvironment;
    }

    public final TypeUnifier getUnifier() {
        return this.unifier;
    }

    public final BooleanType makeBooleanType() {
        return this.factory.makeBooleanType();
    }

    public ParametricType makeParametricType(IExpressionExtension exprExt, Type ... typePrms) {
        return this.factory.makeParametricType(exprExt, typePrms);
    }

    public final GivenType makeGivenType(String name) {
        return this.factory.makeGivenType(name);
    }

    public final IntegerType makeIntegerType() {
        return this.factory.makeIntegerType();
    }

    public final PowerSetType makePowerSetType(Type base) {
        return this.factory.makePowerSetType(base);
    }

    public final ProductType makeProductType(Type left, Type right) {
        return this.factory.makeProductType(left, right);
    }

    public final PowerSetType makeRelationalType(Type left, Type right) {
        return this.factory.makeRelationalType(left, right);
    }

    public final TypeVariable newFreshVariable(SourceLocation location) {
        TypeVariable tv = new TypeVariable(this.factory, this.typeVariables.size(), location);
        this.typeVariables.add(tv);
        return tv;
    }

    public final void solveTypeVariables() {
        if (!this.isSuccess()) {
            return;
        }
        BitSet errorReported = new BitSet(this.typeVariables.size());
        boolean failed = false;
        for (int i = 0; i < this.typeVariables.size(); ++i) {
            TypeVariable tvi = this.typeVariables.get(i);
            if (tvi.getValue() != null) continue;
            failed = true;
            if (!errorReported.get(i) && tvi.hasSourceLocation()) {
                errorReported.set(i);
                this.addProblem(new ASTProblem(tvi.getSourceLocation(), ProblemKind.TypeUnknown, 1, new Object[0]));
            }
            for (int j = 0; j < this.typeVariables.size(); ++j) {
                TypeVariable tvj = this.typeVariables.get(j);
                if (errorReported.get(j) || !tvj.hasSourceLocation() || !this.unifier.occurs(tvi, tvj.getValue())) continue;
                errorReported.set(j);
                this.addProblem(new ASTProblem(tvj.getSourceLocation(), ProblemKind.TypeUnknown, 1, new Object[0]));
            }
        }
        if (failed && this.isSuccess()) {
            this.addProblem(new ASTProblem(null, ProblemKind.TypeCheckFailure, 1, new Object[0]));
        }
        if (!this.isSuccess()) {
            return;
        }
        this.inferredTypeEnvironment.solveVariables(this.unifier);
    }

    public final <T extends Formula<?>> void unify(Type left, Type right, T origin) {
        this.unifier.unify(left, right, origin);
    }

    public final FormulaFactory getFormulaFactory() {
        return this.factory;
    }

    public final <T extends Formula<?>> void addUnificationProblem(Type left, Type right, T origin) {
        SourceLocation loc = origin.getSourceLocation();
        int tag = origin.getTag();
        ASTProblem problem = null;
        if (left instanceof PowerSetType) {
            if (tag == 222) {
                problem = new ASTProblem(loc, ProblemKind.MinusAppliedToSet, 1, new Object[0]);
            } else if (tag == 307) {
                problem = new ASTProblem(loc, ProblemKind.MulAppliedToSet, 1, new Object[0]);
            }
        }
        if (problem == null) {
            problem = new ASTProblem(loc, ProblemKind.TypesDoNotMatch, 1, left, right);
        }
        this.addProblem(problem);
    }

    public void analyzeExpression(Expression expr) {
        this.analyzeType(expr.getType(), expr);
    }

    public void analyzeType(Type type, Formula<?> source) {
        for (GivenType given : type.getGivenTypes()) {
            this.add(given, source);
        }
    }

    private void add(GivenType type, Formula<?> source) {
        if (!this.checkGivenType(type, this.initialTypeEnvironment, source) && !this.checkGivenType(type, this.inferredTypeEnvironment, source)) {
            this.inferredTypeEnvironment.addGivenSet(type.getName());
        }
    }

    private boolean checkGivenType(GivenType type, TypeEnvironment typenv, Formula<?> source) {
        String name = type.getName();
        Type otherType = typenv.getType(name);
        if (otherType == null) {
            return false;
        }
        if (GivenTypeHelper.isGivenSet(name, otherType)) {
            return true;
        }
        if (otherType instanceof TypeVariable) {
            FormulaFactory ff = this.inferredTypeEnvironment.getFormulaFactory();
            this.unify(otherType, ff.makePowerSetType(type), source);
            return true;
        }
        this.addProblem(new ASTProblem(source.getSourceLocation(), ProblemKind.TypeNameUsedForRegularIdentifier, 1, name, otherType));
        return true;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("{ problems = {");
        str.append(super.toString());
        str.append("}");
        for (TypeVariable v : this.typeVariables) {
            str.append("\n  ");
            str.append(v.toString());
            str.append("=");
            Type val = v.getValue();
            str.append(val == null ? "?" : val);
        }
        str.append("}");
        return str.toString();
    }
}

