/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.internal.core.ast.extension.OperatorCoverage;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IPropertyParserInfo;

public class PropertyParserDB {
    private final Map<Properties, List<IPropertyParserInfo<? extends Formula<?>>>> map = new HashMap();

    public void add(IPropertyParserInfo<? extends Formula<?>> newParser) throws GenParser.OverrideException {
        OperatorCoverage newOpCover = newParser.getOperatorCoverage();
        Properties newProp = new Properties(newOpCover);
        List<IPropertyParserInfo<Formula<?>>> list = this.map.get(newProp);
        if (list == null) {
            list = new ArrayList();
            this.map.put(newProp, list);
        }
        for (IPropertyParserInfo<Formula<?>> parser : list) {
            OperatorCoverage opCover = parser.getOperatorCoverage();
            if (!newOpCover.conflictsWith(opCover)) continue;
            throw new GenParser.OverrideException("overriding a parser");
        }
        list.add(newParser);
    }

    public IOperatorInfo<? extends Formula<?>> getParser(IOperatorProperties operProps, String image, int tag, String opId, String groupId) {
        Properties prop = new Properties(operProps);
        List<IPropertyParserInfo<Formula<?>>> list = this.map.get(prop);
        if (list == null) {
            return null;
        }
        for (IPropertyParserInfo<Formula<?>> parserInfo : list) {
            OperatorCoverage opCover = parserInfo.getOperatorCoverage();
            if (!opCover.covers(operProps)) continue;
            return parserInfo.makeOpInfo(image, tag, opId, groupId);
        }
        return null;
    }

    private static final class Properties {
        private final IOperatorProperties.Notation notation;
        private final IOperatorProperties.FormulaType formulaType;
        private final boolean isAssociative;

        public Properties(IOperatorProperties operProps) {
            this(operProps.getNotation(), operProps.getFormulaType(), operProps.isAssociative());
        }

        public Properties(OperatorCoverage opCover) {
            this(opCover.getNotation(), opCover.getFormulaType(), opCover.isAssociative());
        }

        public Properties(IOperatorProperties.Notation notation, IOperatorProperties.FormulaType formulaType, boolean isAssociative) {
            this.notation = notation;
            this.formulaType = formulaType;
            this.isAssociative = isAssociative;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.formulaType.hashCode();
            result = 31 * result + (this.isAssociative ? 1231 : 1237);
            result = 31 * result + this.notation.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)obj;
            if (this.formulaType != other.formulaType) {
                return false;
            }
            if (this.isAssociative != other.isAssociative) {
                return false;
            }
            return this.notation == other.notation;
        }
    }
}

