/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser.operators;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eventb.internal.core.parser.operators.ExternalViewUtils;

public class Matrix {
    private final BitSet bits;
    private final int size;
    private final int offset;

    public Matrix(int size) {
        this(size, 0);
    }

    public Matrix(int size, int offset) {
        this.size = size;
        this.offset = offset;
        this.bits = new BitSet(size * size);
    }

    private void checkIndexes(int a, int b) {
        if (this.outOfBounds(a) || this.outOfBounds(b)) {
            throw new IndexOutOfBoundsException("Square Matrix of size " + this.size + " cannot accept (" + a + "," + b + ")");
        }
    }

    private boolean outOfBounds(int a) {
        return a < 0 || a >= this.size;
    }

    public void set(int a, int b) {
        this.checkIndexes(a -= this.offset, b -= this.offset);
        this.bits.set(a * this.size + b);
    }

    public boolean get(int a, int b) {
        return this.bits.get((a -= this.offset) * this.size + (b -= this.offset));
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.offset; i < this.size + this.offset; ++i) {
            for (int j = this.offset; j < this.size + this.offset; ++j) {
                if (this.get(i, j)) {
                    sb.append('X');
                    continue;
                }
                sb.append(' ');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public <T> Map<T, Set<T>> toRelationMap(ExternalViewUtils.Instantiator<Integer, T> inst) {
        HashMap relMap = new HashMap();
        for (int i = this.offset; i < this.size + this.offset; ++i) {
            T leftOp = inst.instantiate(i);
            HashSet<T> rightOps = new HashSet<T>();
            for (int j = this.offset; j < this.size + this.offset; ++j) {
                if (!this.get(i, j)) continue;
                T rightOp = inst.instantiate(j);
                rightOps.add(rightOp);
            }
            relMap.put(leftOp, rightOps);
        }
        return relMap;
    }
}

