/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.parser;

import java.util.Set;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.internal.core.ast.extension.CompatibilityMediator;
import org.eventb.internal.core.ast.extension.PriorityMediator;
import org.eventb.internal.core.parser.BMathV2;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;

public class ExtendedGrammar
extends BMathV2 {
    private final Set<IFormulaExtension> extensions;

    public ExtendedGrammar(Set<IFormulaExtension> extensions) {
        this.extensions = extensions;
    }

    @Override
    protected void addOperators() {
        super.addOperators();
        ExtendedExpression.init(this);
        ExtendedPredicate.init(this);
        try {
            for (IFormulaExtension extension : this.extensions) {
                String operatorImage = extension.getSyntaxSymbol();
                int kind = this.tokens.getOrAdd(operatorImage);
                if (this.isInitOperator(kind)) {
                    throw new GenParser.OverrideException("extension " + extension.getId() + " is overriding operator " + operatorImage);
                }
                IExtensionKind extKind = extension.getKind();
                int tag = FormulaFactory.getTag(extension);
                String operatorId = extension.getId();
                String groupId = extension.getGroupId();
                IOperatorInfo<? extends Formula<?>> parser = this.getParser(extKind.getProperties(), operatorImage, tag, operatorId, groupId);
                if (parser == null) {
                    throw new IllegalStateException("Unparseable extension kind: " + extKind);
                }
                this.addOperator(parser);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void addOperatorRelationships() {
        super.addOperatorRelationships();
        for (IFormulaExtension extension : this.extensions) {
            extension.addCompatibilities(new CompatibilityMediator(this));
            extension.addPriorities(new PriorityMediator(this));
        }
    }
}

