/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.lexer;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.internal.core.lexer.GenLexer;
import org.eventb.internal.core.lexer.ILexer;
import org.eventb.internal.core.lexer.Token;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.ParseResult;

public class Scanner {
    private final List<Token> list = new ArrayList<Token>();
    private ListIterator<Token> iterator = this.list.listIterator();
    private final int eofKind;
    private final ILexer lexer;

    public Scanner(String str, ParseResult result, AbstractGrammar grammar) {
        this(new GenLexer(str, result, grammar));
    }

    public Scanner(ILexer lexer) {
        this.lexer = lexer;
        this.eofKind = lexer.eofKind();
    }

    private Token getNextToken() {
        return this.lexer.nextToken();
    }

    public Token Scan() {
        this.ResetPeek();
        if (this.iterator.hasNext()) {
            Token temp = this.iterator.next();
            this.iterator.remove();
            return temp;
        }
        return this.getNextToken();
    }

    protected Token Peek() {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        Token result = this.getNextToken();
        this.iterator.add(result);
        return result;
    }

    protected void ResetPeek() {
        this.iterator = this.list.listIterator(0);
    }

    protected ParseResult getResult() {
        return this.lexer.getResult();
    }

    public static boolean isToken(FormulaFactory factory, String name, AbstractGrammar.DefaultToken tokenKind) {
        BMath grammar = (BMath)factory.getGrammar();
        ParseResult result = new ParseResult(factory, name);
        Scanner scanner = new Scanner(name, result, grammar);
        Token token = scanner.Peek();
        int kind = grammar.getKind(tokenKind);
        return !result.hasProblem() && token != null && token.kind == kind && token.val.equals(name);
    }

    public ScannerState save() {
        return new ScannerState(this.lexer.save(), this.list);
    }

    public void restore(ScannerState state) {
        this.lexer.restore(state.lexState);
        this.list.clear();
        this.list.addAll(new ArrayList<Token>(state.lookedAhead));
    }

    public boolean lookAheadFor(int searchedKind) {
        this.ResetPeek();
        Token peek = this.Peek();
        while (peek.kind != this.eofKind) {
            if (peek.kind == searchedKind) {
                return true;
            }
            peek = this.Peek();
        }
        return false;
    }

    public static class ScannerState {
        final GenLexer.LexState lexState;
        final List<Token> lookedAhead;

        public ScannerState(GenLexer.LexState lexState, List<Token> lookedAhead) {
            this.lexState = lexState;
            this.lookedAhead = new ArrayList<Token>(lookedAhead);
        }
    }
}

