/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.lexer;

public class LexStream {
    private final String toLex;
    private final int length;
    private int curPos;
    private int tokenStart;

    public LexStream(String toLex) {
        this.toLex = toLex;
        this.length = toLex.length();
        this.tokenStart = -1;
        this.curPos = 0;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public void setTokenStart(int tokenStart) {
        this.tokenStart = tokenStart;
    }

    public int getCurPos() {
        return this.curPos;
    }

    public void setCurPos(int curPos) {
        this.curPos = curPos;
    }

    public int curCodePoint() {
        return this.codePointAt(this.curPos);
    }

    public int codePointAt(int index) {
        return this.toLex.codePointAt(index);
    }

    public String getLexem() {
        return this.toLex.substring(this.tokenStart, this.curPos);
    }

    public void startNext() {
        this.tokenStart = this.curPos;
        this.goForward();
    }

    public boolean isEOF() {
        return this.curPos >= this.length;
    }

    public void goForward() {
        this.curPos = LexStream.nextCodePoint(this.toLex, this.curPos);
    }

    public void resetCurPos() {
        this.curPos = this.tokenStart;
        this.goForward();
    }

    public static int nextCodePoint(String str, int index) {
        int codePoint;
        do {
            codePoint = Character.codePointAt(str, index);
            ++index;
        } while (Character.isSupplementaryCodePoint(codePoint));
        return index;
    }
}

