/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import java.util.HashMap;
import java.util.Map;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.internal.core.ast.extension.ExtensionSignature;
import org.eventb.internal.core.ast.extension.ExtensionTranslation;
import org.eventb.internal.core.ast.extension.ExtensionTranslator;

public abstract class TranslatorRegistry<S extends ExtensionSignature, T extends ExtensionTranslator> {
    private final ExtensionTranslation translation;
    private final Map<S, T> translators = new HashMap<S, T>();

    public TranslatorRegistry(ExtensionTranslation translation) {
        this.translation = translation;
    }

    public T get(S signature) {
        ExtensionTranslator result = (ExtensionTranslator)this.translators.get(signature);
        if (result == null) {
            FreeIdentifier function = this.translation.makeFunction((ExtensionSignature)signature);
            result = this.newTranslator(function);
            this.translators.put(signature, result);
        }
        return (T)result;
    }

    protected abstract T newTranslator(FreeIdentifier var1);

    public static class ExprTranslatorRegistry
    extends TranslatorRegistry<ExtensionSignature.ExpressionExtSignature, ExtensionTranslator.ExpressionExtTranslator> {
        public ExprTranslatorRegistry(ExtensionTranslation translation) {
            super(translation);
        }

        @Override
        protected ExtensionTranslator.ExpressionExtTranslator newTranslator(FreeIdentifier function) {
            return new ExtensionTranslator.ExpressionExtTranslator(function);
        }
    }

    public static class PredTranslatorRegistry
    extends TranslatorRegistry<ExtensionSignature.PredicateExtSignature, ExtensionTranslator.PredicateExtTranslator> {
        public PredTranslatorRegistry(ExtensionTranslation translation) {
            super(translation);
        }

        @Override
        protected ExtensionTranslator.PredicateExtTranslator newTranslator(FreeIdentifier function) {
            return new ExtensionTranslator.PredicateExtTranslator(function);
        }
    }
}

