/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import org.eventb.core.ast.extension.IOperatorProperties;
import org.eventb.core.ast.extension.ITypeDistribution;
import org.eventb.internal.core.ast.extension.ArityCoverage;

public class OperatorCoverage {
    private final IOperatorProperties.Notation notation;
    private final IOperatorProperties.FormulaType formulaType;
    private final ArityCoverage exprArity;
    private final ArityCoverage predArity;
    private final ArityCoverage globalArity;
    private final boolean isAssociative;

    public OperatorCoverage(IOperatorProperties.Notation notation, IOperatorProperties.FormulaType formulaType, ArityCoverage exprArity, ArityCoverage predArity, ArityCoverage globalArity, boolean isAssociative) {
        this.notation = notation;
        this.formulaType = formulaType;
        this.exprArity = exprArity;
        this.predArity = predArity;
        this.globalArity = globalArity;
        this.isAssociative = isAssociative;
    }

    public boolean covers(IOperatorProperties properties) {
        ITypeDistribution childTypes = properties.getChildTypes();
        return this.notation == properties.getNotation() && this.formulaType == properties.getFormulaType() && this.exprArity.contains(childTypes.getExprArity()) && this.predArity.contains(childTypes.getPredArity()) && this.isAssociative == properties.isAssociative();
    }

    public boolean conflictsWith(OperatorCoverage other) {
        return this.notation == other.notation && this.formulaType == other.formulaType && !this.exprArity.isDisjoint(other.exprArity) && !this.predArity.isDisjoint(other.predArity) && !this.globalArity.isDisjoint(other.globalArity) && this.isAssociative == other.isAssociative;
    }

    public IOperatorProperties.Notation getNotation() {
        return this.notation;
    }

    public IOperatorProperties.FormulaType getFormulaType() {
        return this.formulaType;
    }

    public boolean isAssociative() {
        return this.isAssociative;
    }
}

