/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IExtensionTranslation;
import org.eventb.core.ast.ISealedTypeEnvironment;
import org.eventb.core.ast.ITypeEnvironmentBuilder;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.internal.core.ast.AbstractTranslation;
import org.eventb.internal.core.ast.DefaultTypeCheckingRewriter;
import org.eventb.internal.core.ast.FreshNameSolver;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.extension.ExtensionSignature;
import org.eventb.internal.core.ast.extension.ExtensionTranslator;
import org.eventb.internal.core.ast.extension.TranslatorRegistry;

public class ExtensionTranslation
extends AbstractTranslation
implements IExtensionTranslation {
    private final FormulaFactory trgFactory;
    private final ITypeEnvironmentBuilder trgTypenv;
    private final FreshNameSolver nameSolver;
    private final TranslatorRegistry.ExprTranslatorRegistry exprTranslators = new TranslatorRegistry.ExprTranslatorRegistry(this);
    private final TranslatorRegistry.PredTranslatorRegistry predTranslators = new TranslatorRegistry.PredTranslatorRegistry(this);
    private ITypeCheckingRewriter rewriter;

    public ExtensionTranslation(ISealedTypeEnvironment srcTypenv) {
        super(srcTypenv);
        this.trgFactory = ExtensionTranslation.computeTargetFactory(srcTypenv.getFormulaFactory());
        this.trgTypenv = srcTypenv.translate(this.trgFactory).makeBuilder();
        this.nameSolver = new FreshNameSolver(this.trgTypenv);
        this.rewriter = new ExtensionRewriter(this.trgFactory, this);
    }

    private static FormulaFactory computeTargetFactory(FormulaFactory fac) {
        Set<IFormulaExtension> extensions = fac.getExtensions();
        LinkedHashSet<IFormulaExtension> keptExtensions = new LinkedHashSet<IFormulaExtension>();
        for (IFormulaExtension extension : extensions) {
            if (extension.getOrigin() instanceof IDatatype) {
                keptExtensions.add(extension);
            }
            if (extension.conjoinChildrenWD()) continue;
            keptExtensions.add(extension);
        }
        return FormulaFactory.getInstance(keptExtensions);
    }

    public FormulaFactory getTargetFactory() {
        return this.trgFactory;
    }

    @Override
    public ISealedTypeEnvironment getTargetTypeEnvironment() {
        return this.trgTypenv.makeSnapshot();
    }

    public Expression translate(ExtendedExpression src, Expression[] newChildExprs, Predicate[] newChildPreds) {
        ExtensionSignature.ExpressionExtSignature signature = ExtensionSignature.getSignature(src);
        ExtensionTranslator.ExpressionExtTranslator translator = (ExtensionTranslator.ExpressionExtTranslator)this.exprTranslators.get(signature);
        return translator.translate(newChildExprs, newChildPreds);
    }

    public Predicate translate(ExtendedPredicate src, Expression[] newChildExprs, Predicate[] newChildPreds) {
        ExtensionSignature.PredicateExtSignature signature = ExtensionSignature.getSignature(src);
        ExtensionTranslator.PredicateExtTranslator translator = (ExtensionTranslator.PredicateExtTranslator)this.predTranslators.get(signature);
        return translator.translate(newChildExprs, newChildPreds);
    }

    public FreeIdentifier makeFunction(ExtensionSignature signature) {
        String baseName = this.makeBaseName(signature);
        String name = this.nameSolver.solve(baseName);
        Type type = signature.getFunctionalType().translate(this.trgFactory);
        FreeIdentifier ident = this.trgFactory.makeFreeIdentifier(name, null, type);
        this.trgTypenv.add(ident);
        return ident;
    }

    private String makeBaseName(ExtensionSignature signature) {
        IFormulaExtension extension = signature.getExtension();
        String id = extension.getId();
        if (this.trgFactory.isValidIdentifierName(id)) {
            return id;
        }
        return "ext";
    }

    @Override
    public ITypeCheckingRewriter getFormulaRewriter() {
        return this.rewriter;
    }

    public String toString() {
        return "Extension Translation for factory: " + this.srcTypenv.getFormulaFactory() + " in type environment: " + this.srcTypenv;
    }

    private static class ExtensionRewriter
    extends DefaultTypeCheckingRewriter {
        private ExtensionTranslation translation;

        public ExtensionRewriter(FormulaFactory targetFactory, ExtensionTranslation translation) {
            super(targetFactory);
            this.translation = translation;
        }

        @Override
        public Expression rewrite(ExtendedExpression src, boolean changed, Expression[] newChildExprs, Predicate[] newChildPreds) {
            if (!changed && this.ff == src.getFactory()) {
                return src;
            }
            if (src.getExtension().getOrigin() instanceof IDatatype) {
                return super.rewrite(src, changed, newChildExprs, newChildPreds);
            }
            return this.translation.translate(src, newChildExprs, newChildPreds);
        }

        @Override
        public Predicate rewrite(ExtendedPredicate src, boolean changed, Expression[] newChildExprs, Predicate[] newChildPreds) {
            if (!changed && this.ff == src.getFactory()) {
                return src;
            }
            return this.translation.translate(src, newChildExprs, newChildPreds);
        }
    }
}

