/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.extension;

import java.util.Arrays;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IFormulaExtension;

public abstract class ExtensionSignature {
    private static final int PRIME = 31;
    protected final FormulaFactory factory;
    private final IFormulaExtension extension;
    private final int numberOfPredicates;
    private final Type[] childTypes;

    public static ExpressionExtSignature getSignature(ExtendedExpression src) {
        return new ExpressionExtSignature(src);
    }

    public static PredicateExtSignature getSignature(ExtendedPredicate src) {
        return new PredicateExtSignature(src);
    }

    private static Type[] getChildTypes(IExtendedFormula src) {
        Expression[] childExprs = src.getChildExpressions();
        int length = childExprs.length;
        Type[] childTypes = new Type[length];
        for (int i = 0; i < length; ++i) {
            childTypes[i] = childExprs[i].getType();
        }
        return childTypes;
    }

    protected ExtensionSignature(IExtendedFormula src) {
        this.factory = ((Formula)((Object)src)).getFactory();
        this.extension = src.getExtension();
        this.numberOfPredicates = src.getChildPredicates().length;
        this.childTypes = ExtensionSignature.getChildTypes(src);
    }

    protected ExtensionSignature(FormulaFactory factory, IFormulaExtension extension, int numberOfPredicates, Type[] childTypes) {
        this.factory = factory;
        this.extension = extension;
        this.numberOfPredicates = numberOfPredicates;
        this.childTypes = childTypes;
    }

    public IFormulaExtension getExtension() {
        return this.extension;
    }

    public abstract Type getFunctionalType();

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.extension.hashCode();
        result = 31 * result + this.numberOfPredicates;
        result = 31 * result + Arrays.hashCode(this.childTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionSignature other = (ExtensionSignature)obj;
        return this.extension.equals(other.extension) && this.numberOfPredicates == other.numberOfPredicates && Arrays.equals(this.childTypes, other.childTypes);
    }

    protected Type makeDomainType() {
        Type result = null;
        for (Type childType : this.childTypes) {
            result = this.join(result, childType);
        }
        Type boolType = this.makeBooleanType();
        for (int i = 0; i < this.numberOfPredicates; ++i) {
            result = this.join(result, boolType);
        }
        return result;
    }

    private Type join(Type left, Type right) {
        if (left == null) {
            return right;
        }
        return this.factory.makeProductType(left, right);
    }

    protected Type makeBooleanType() {
        return this.factory.makeBooleanType();
    }

    protected Type makeRelationalType(Type left, Type right) {
        if (left == null) {
            return right;
        }
        return this.factory.makeRelationalType(left, right);
    }

    public static class ExpressionExtSignature
    extends ExtensionSignature {
        private final Type returnType;

        public ExpressionExtSignature(ExtendedExpression src) {
            super(src);
            this.returnType = src.getType();
        }

        public ExpressionExtSignature(FormulaFactory factory, IFormulaExtension extension, Type returnType, int numberOfPredicates, Type[] childTypes) {
            super(factory, extension, numberOfPredicates, childTypes);
            this.returnType = returnType;
        }

        @Override
        public Type getFunctionalType() {
            return this.makeRelationalType(this.makeDomainType(), this.returnType);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ExpressionExtSignature other = (ExpressionExtSignature)obj;
            return this.returnType.equals(other.returnType);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.returnType.hashCode();
            return result;
        }
    }

    public static class PredicateExtSignature
    extends ExtensionSignature {
        public PredicateExtSignature(ExtendedPredicate src) {
            super(src);
        }

        public PredicateExtSignature(FormulaFactory factory, IFormulaExtension extension, int numberOfPredicates, Type[] childTypes) {
            super(factory, extension, numberOfPredicates, childTypes);
        }

        @Override
        public Type getFunctionalType() {
            return this.makeRelationalType(this.makeDomainType(), this.makeBooleanType());
        }
    }
}

