/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.expanders;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.core.ast.expanders.ISmartFactory;

public class SmartFactory
implements ISmartFactory {
    protected final FormulaFactory ff;

    public SmartFactory(FormulaFactory ff) {
        this.ff = ff;
    }

    @Override
    public FormulaFactory getFormulaFactory() {
        return this.ff;
    }

    @Override
    public Predicate disjoint(Expression left, Expression right) {
        Expression leftMember = this.getSingletonMember(left);
        if (leftMember != null) {
            return this.not(this.in(leftMember, right));
        }
        Expression rightMember = this.getSingletonMember(right);
        if (rightMember != null) {
            return this.not(this.in(rightMember, left));
        }
        Type type = left.getType();
        return this.equals(this.inter(type, left, right), this.emptySet(type));
    }

    @Override
    public Expression getSingletonMember(Expression expr) {
        if (expr.getTag() != 5) {
            return null;
        }
        Expression[] members = ((SetExtension)expr).getMembers();
        if (members.length != 1) {
            return null;
        }
        return members[0];
    }

    @Override
    public Expression emptySet(Type type) {
        return this.ff.makeEmptySet(type, null);
    }

    @Override
    public Predicate equals(Expression left, Expression right) {
        return this.ff.makeRelationalPredicate(101, left, right, null);
    }

    @Override
    public Expression inter(Type type, Expression ... exprs) {
        switch (exprs.length) {
            case 0: {
                return type.getBaseType().toExpression();
            }
            case 1: {
                return exprs[0];
            }
        }
        return this.ff.makeAssociativeExpression(302, exprs, null);
    }

    @Override
    public Predicate in(Expression member, Expression set) {
        switch (set.getTag()) {
            case 5: {
                Expression[] children = ((SetExtension)set).getMembers();
                switch (children.length) {
                    case 0: {
                        return this.ff.makeLiteralPredicate(611, null);
                    }
                    case 1: {
                        return this.equals(member, children[0]);
                    }
                }
                break;
            }
            case 407: {
                return this.ff.makeLiteralPredicate(611, null);
            }
        }
        if (set.isATypeExpression()) {
            return this.ff.makeLiteralPredicate(610, null);
        }
        return this.ff.makeRelationalPredicate(107, member, set, null);
    }

    @Override
    public Predicate land(List<Predicate> preds) {
        switch (preds.size()) {
            case 0: {
                return this.ff.makeLiteralPredicate(610, null);
            }
            case 1: {
                return preds.get(0);
            }
        }
        return this.ff.makeAssociativePredicate(351, preds, null);
    }

    @Override
    public Predicate lor(List<Predicate> preds) {
        switch (preds.size()) {
            case 0: {
                return this.ff.makeLiteralPredicate(611, null);
            }
            case 1: {
                return preds.get(0);
            }
        }
        return this.ff.makeAssociativePredicate(352, preds, null);
    }

    @Override
    public Predicate not(Predicate pred) {
        if (pred.getTag() == 701) {
            return ((UnaryPredicate)pred).getChild();
        }
        return this.ff.makeUnaryPredicate(701, pred, null);
    }

    @Override
    public Expression union(Type type, Expression ... exprs) {
        switch (exprs.length) {
            case 0: {
                return this.emptySet(type);
            }
            case 1: {
                return exprs[0];
            }
        }
        Expression attempt = this.extensionSetMerge(exprs);
        if (attempt != null) {
            return attempt;
        }
        return this.ff.makeAssociativeExpression(301, exprs, null);
    }

    private Expression extensionSetMerge(Expression[] exprs) {
        LinkedHashSet<Expression> members = new LinkedHashSet<Expression>(exprs.length * 2);
        for (Expression expr : exprs) {
            if (!(expr instanceof SetExtension)) {
                return null;
            }
            SetExtension setExt = (SetExtension)expr;
            Expression[] subMembers = setExt.getMembers();
            members.addAll(Arrays.asList(subMembers));
        }
        return this.ff.makeSetExtension(members, null);
    }
}

