/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.expanders;

import java.util.ArrayList;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.Predicate;
import org.eventb.internal.core.ast.expanders.SmartFactory;

public class PartitionExpander
extends SmartFactory {
    private final Expression set;
    private final Expression[] components;

    public PartitionExpander(MultiplePredicate predicate) {
        super(predicate.getFactory());
        Expression[] children = predicate.getChildren();
        this.set = children[0];
        int nbComps = children.length - 1;
        this.components = new Expression[nbComps];
        System.arraycopy(children, 1, this.components, 0, nbComps);
    }

    public Predicate expand() {
        int initSize = 1 + this.components.length * this.components.length / 2;
        ArrayList<Predicate> conjuncts = new ArrayList<Predicate>(initSize);
        conjuncts.add(this.equals(this.set, this.union(this.set.getType(), this.components)));
        int end = this.components.length - 1;
        for (int i = 0; i < end; ++i) {
            for (int j = i + 1; j <= end; ++j) {
                conjuncts.add(this.disjoint(this.components[i], this.components[j]));
            }
        }
        return this.land(conjuncts);
    }
}

