/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.ArrayList;
import java.util.Arrays;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.ITypeConstructorExtension;
import org.eventb.core.ast.extension.ICompatibilityMediator;
import org.eventb.core.ast.extension.IExtendedFormula;
import org.eventb.core.ast.extension.IExtensionKind;
import org.eventb.core.ast.extension.IPriorityMediator;
import org.eventb.core.ast.extension.ITypeCheckMediator;
import org.eventb.core.ast.extension.ITypeMediator;
import org.eventb.core.ast.extension.IWDMediator;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.DatatypeBuilder;
import org.eventb.internal.core.ast.datatype.DatatypeHelper;

public class TypeConstructorExtension
implements ITypeConstructorExtension {
    private Datatype origin;
    private final String name;
    private final String[] formalNames;
    private final String id;
    private final String groupId;
    private final IExtensionKind kind;

    public TypeConstructorExtension(Datatype origin, DatatypeBuilder dtBuilder) {
        this.origin = origin;
        this.name = dtBuilder.getName();
        GivenType[] typeParams = dtBuilder.getTypeParameters();
        this.formalNames = new String[typeParams.length];
        for (int i = 0; i < typeParams.length; ++i) {
            this.formalNames[i] = typeParams[i].getName();
        }
        this.id = DatatypeHelper.computeId(this.name);
        this.groupId = DatatypeHelper.computeGroup(typeParams.length);
        this.kind = DatatypeHelper.computeKind(typeParams.length);
    }

    @Override
    public boolean conjoinChildrenWD() {
        return true;
    }

    @Override
    public Predicate getWDPredicate(IExtendedFormula formula, IWDMediator wdMediator) {
        return wdMediator.makeTrueWD();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSyntaxSymbol() {
        return this.name;
    }

    @Override
    public IExtensionKind getKind() {
        return this.kind;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void addPriorities(IPriorityMediator mediator) {
    }

    @Override
    public void addCompatibilities(ICompatibilityMediator mediator) {
    }

    @Override
    public Type typeCheck(ExtendedExpression expression, ITypeCheckMediator tcMediator) {
        ArrayList<Type> prmTypes = new ArrayList<Type>();
        for (Expression child : expression.getChildExpressions()) {
            Type alpha = tcMediator.newTypeVariable();
            PowerSetType prmType = tcMediator.makePowerSetType(alpha);
            tcMediator.sameType(prmType, child.getType());
            prmTypes.add(alpha);
        }
        return tcMediator.makePowerSetType(tcMediator.makeParametricType(this, prmTypes));
    }

    @Override
    public Type synthesizeType(Expression[] childExprs, Predicate[] childPreds, ITypeMediator mediator) {
        ArrayList<Type> prmTypes = new ArrayList<Type>();
        for (Expression child : childExprs) {
            Type childType = child.getType();
            if (childType == null) {
                return null;
            }
            Type baseType = childType.getBaseType();
            if (baseType == null) {
                return null;
            }
            prmTypes.add(baseType);
        }
        return mediator.makePowerSetType(mediator.makeParametricType(this, prmTypes));
    }

    @Override
    public boolean verifyType(Type proposedType, Expression[] childExprs, Predicate[] childPreds) {
        Type baseType = proposedType.getBaseType();
        if (!(baseType instanceof ParametricType)) {
            return false;
        }
        ParametricType genType = (ParametricType)baseType;
        if (genType.getExprExtension() != this) {
            return false;
        }
        Type[] typeParameters = genType.getTypeParameters();
        assert (childExprs.length == typeParameters.length);
        for (int i = 0; i < childExprs.length; ++i) {
            Type childType = childExprs[i].getType();
            if (typeParameters[i].equals(childType.getBaseType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isATypeConstructor() {
        return true;
    }

    @Override
    public Datatype getOrigin() {
        return this.origin;
    }

    @Override
    public String[] getFormalNames() {
        return (String[])this.formalNames.clone();
    }

    public int getNbParams() {
        return this.formalNames.length;
    }

    public int hashCode() {
        int prime = 31;
        return 31 * this.name.hashCode() + Arrays.hashCode(this.formalNames);
    }

    public boolean isSimilarTo(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeConstructorExtension other = (TypeConstructorExtension)obj;
        return this.name.equals(other.name) && Arrays.equals(this.formalNames, other.formalNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
        String sep = "[";
        for (String formalName : this.formalNames) {
            sb.append(sep);
            sep = ", ";
            sb.append(formalName);
        }
        if (this.formalNames.length != 0) {
            sb.append("]");
        }
    }
}

