/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import org.eventb.core.ast.BooleanType;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ITypeVisitor;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.Type;

public class ArgumentTypeChecker
implements ITypeVisitor {
    private final GivenType dtType;
    private boolean found;
    private int enclosingPowersets;

    public ArgumentTypeChecker(GivenType dtType) {
        this.dtType = dtType;
    }

    public void check(Type argType) {
        FormulaFactory dtFactory;
        FormulaFactory typeFactory = argType.getFactory();
        if (typeFactory != (dtFactory = this.dtType.getFactory())) {
            throw new IllegalArgumentException("The given argument type " + argType + " has an incompatible factory: " + typeFactory + " instead of the factory used to build the datatype: " + dtFactory);
        }
        this.enclosingPowersets = 0;
        this.found = false;
        argType.accept(this);
    }

    public boolean isBasic() {
        return !this.found;
    }

    @Override
    public void visit(BooleanType type) {
    }

    @Override
    public void visit(GivenType type) {
        if (this.dtType.equals(type)) {
            if (this.enclosingPowersets > 0) {
                throw new IllegalArgumentException("The datatype type occurs within a powerset");
            }
            this.found = true;
        }
    }

    @Override
    public void visit(IntegerType type) {
    }

    @Override
    public void visit(ParametricType type) {
        for (Type child : type.getTypeParameters()) {
            child.accept(this);
        }
    }

    @Override
    public void visit(PowerSetType type) {
        ++this.enclosingPowersets;
        type.getBaseType().accept(this);
        --this.enclosingPowersets;
    }

    @Override
    public void visit(ProductType type) {
        type.getLeft().accept(this);
        type.getRight().accept(this);
    }
}

