/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IFormulaRewriter;
import org.eventb.core.ast.IFormulaRewriter2;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.PredicateVariable;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.internal.core.ast.DefaultTypeCheckingRewriter;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;

public class SameTypeRewriter
implements ITypeCheckingRewriter {
    private final IFormulaRewriter rewriter;
    private final FormulaFactory factory;

    public SameTypeRewriter(FormulaFactory ff, IFormulaRewriter rewriter) {
        this.rewriter = rewriter;
        this.factory = ff;
    }

    @Override
    public boolean autoFlatteningMode() {
        return this.rewriter.autoFlatteningMode();
    }

    @Override
    public void enteringQuantifier(int nbOfDeclarations) {
        this.rewriter.enteringQuantifier(nbOfDeclarations);
    }

    @Override
    public FormulaFactory getFactory() {
        return this.factory;
    }

    @Override
    public void leavingQuantifier(int nbOfDeclarations) {
        this.rewriter.leavingQuantifier(nbOfDeclarations);
    }

    @Override
    public Expression rewrite(AssociativeExpression src, AssociativeExpression expr) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public Predicate rewrite(AssociativePredicate src, AssociativePredicate pred) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(pred));
    }

    @Override
    public Expression rewrite(AtomicExpression src) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(src));
    }

    @Override
    public Expression rewrite(BinaryExpression src, BinaryExpression expr) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public Predicate rewrite(BinaryPredicate src, BinaryPredicate pred) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(pred));
    }

    @Override
    public Expression rewrite(BoolExpression src, BoolExpression expr) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public BoundIdentDecl rewrite(BoundIdentDecl decl) {
        return decl;
    }

    @Override
    public Expression rewrite(BoundIdentifier src) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(src));
    }

    @Override
    public Expression rewrite(ExtendedExpression src, boolean changed, Expression[] newChildExprs, Predicate[] newChildPreds) {
        ExtendedExpression expr = changed ? this.getFactory().makeExtendedExpression(src.getExtension(), newChildExprs, newChildPreds, src.getSourceLocation(), src.getType()) : src;
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public Predicate rewrite(ExtendedPredicate src, boolean changed, Expression[] newChildExprs, Predicate[] newChildPreds) {
        ExtendedPredicate pred = changed ? this.getFactory().makeExtendedPredicate(src.getExtension(), newChildExprs, newChildPreds, src.getSourceLocation()) : src;
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(pred));
    }

    @Override
    public Expression rewrite(FreeIdentifier src) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(src));
    }

    @Override
    public Expression rewrite(IntegerLiteral src) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(src));
    }

    @Override
    public Predicate rewrite(LiteralPredicate src) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(src));
    }

    @Override
    public Predicate rewrite(MultiplePredicate src, MultiplePredicate pred) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(pred));
    }

    @Override
    public Predicate rewrite(PredicateVariable src) {
        if (!(this.rewriter instanceof IFormulaRewriter2)) {
            throw new IllegalArgumentException("The given rewriter shall support predicate variables");
        }
        IFormulaRewriter2 rewriter2 = (IFormulaRewriter2)this.rewriter;
        return DefaultTypeCheckingRewriter.checkReplacement(src, rewriter2.rewrite(src));
    }

    @Override
    public Expression rewrite(QuantifiedExpression src, QuantifiedExpression expr) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public Predicate rewrite(QuantifiedPredicate src, QuantifiedPredicate pred) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(pred));
    }

    @Override
    public Predicate rewrite(RelationalPredicate src, RelationalPredicate pred) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(pred));
    }

    @Override
    public Expression rewrite(SetExtension src, SetExtension expr) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public Expression rewriteToEmptySet(SetExtension src) {
        AtomicExpression expr = this.factory.makeEmptySet(src.getType(), src.getSourceLocation());
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public Predicate rewrite(SimplePredicate src, SimplePredicate pred) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(pred));
    }

    @Override
    public Expression rewrite(UnaryExpression src, boolean changed, Expression newChild) {
        UnaryExpression expr = changed ? this.getFactory().makeUnaryExpression(src.getTag(), newChild, src.getSourceLocation()) : src;
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public Expression rewrite(UnaryExpression src, IntegerLiteral expr) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(expr));
    }

    @Override
    public Predicate rewrite(UnaryPredicate src, UnaryPredicate pred) {
        return DefaultTypeCheckingRewriter.checkReplacement(src, this.rewriter.rewrite(pred));
    }
}

