/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.Arrays;

public class IntStack {
    private static final int DEFAULT_SIZE = 11;
    private int[] array = new int[11];
    private int index = -1;

    public boolean isEmpty() {
        return this.index < 0;
    }

    public void push(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Negative index " + i);
        }
        if (++this.index >= this.array.length) {
            int[] newArray = new int[this.array.length + 11];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        this.array[this.index] = i;
    }

    public void pop() {
        if (this.index < 0) {
            throw new IllegalStateException("Stack is empty");
        }
        --this.index;
    }

    public int top() {
        return this.array[this.index];
    }

    public void incrementTop() {
        int n = this.index;
        this.array[n] = this.array[n] + 1;
    }

    public int[] toArray() {
        int len = this.index + 1;
        int[] result = new int[len];
        System.arraycopy(this.array, 0, result, 0, len);
        return result;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

