/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast;

import java.util.ArrayList;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.Identifier;
import org.eventb.internal.core.ast.ArrayStream;
import org.eventb.internal.core.ast.MergingStream;

public abstract class IdentListMerger {
    protected final Class<?> itemClass;
    protected boolean errorFound = false;
    protected static final String infinity = "\uffff";

    protected IdentListMerger(Class<?> itemClass) {
        this.itemClass = itemClass;
    }

    protected static IdentListMerger buildMerger(ArrayList<? extends Identifier[]> lists, int first, int last) {
        assert (first < last);
        switch (last - first) {
            case 1: {
                return new ArrayStream(lists.get(first));
            }
            case 2: {
                return new MergingStream(new ArrayStream(lists.get(first)), new ArrayStream(lists.get(first + 1)));
            }
        }
        int mid = (first + last) / 2;
        return new MergingStream(IdentListMerger.buildMerger(lists, first, mid), IdentListMerger.buildMerger(lists, mid, last));
    }

    public static IdentListMerger makeMerger(ArrayList<? extends Identifier[]> lists) {
        assert (!lists.isEmpty());
        return IdentListMerger.buildMerger(lists, 0, lists.size());
    }

    public static <S extends Identifier> IdentListMerger makeMerger(S[] list1, S[] list2) {
        int length1 = list1.length;
        if (length1 == 0) {
            return new ArrayStream((Identifier[])list2);
        }
        int length2 = list2.length;
        if (length2 == 0) {
            return new ArrayStream((Identifier[])list1);
        }
        return new MergingStream(new ArrayStream((Identifier[])list1), new ArrayStream((Identifier[])list2));
    }

    public abstract boolean containsError();

    protected abstract Identifier[] getMaximalArray();

    public final FreeIdentifier[] getFreeMergedArray() {
        FreeIdentifier[] maxArray;
        int maxLength = this.getPotentialLength();
        Identifier[] result = new FreeIdentifier[maxLength];
        int length = this.buildMergedArray(result);
        if (length == (maxArray = (FreeIdentifier[])this.getMaximalArray()).length) {
            return maxArray;
        }
        if (length != maxLength) {
            FreeIdentifier[] temp = new FreeIdentifier[length];
            System.arraycopy(result, 0, temp, 0, length);
            result = temp;
        }
        return result;
    }

    public final BoundIdentifier[] getBoundMergedArray() {
        BoundIdentifier[] maxArray;
        int maxLength = this.getPotentialLength();
        Identifier[] result = new BoundIdentifier[maxLength];
        int length = this.buildMergedArray(result);
        if (length == (maxArray = (BoundIdentifier[])this.getMaximalArray()).length) {
            return maxArray;
        }
        if (length != maxLength) {
            BoundIdentifier[] temp = new BoundIdentifier[length];
            System.arraycopy(result, 0, temp, 0, length);
            result = temp;
        }
        return result;
    }

    private int buildMergedArray(Identifier[] result) {
        int index = 0;
        Identifier ident = this.getNext();
        while (ident != null) {
            result[index++] = ident;
            ident = this.getNext();
        }
        return index;
    }

    protected abstract Identifier getNext();

    protected abstract int getPotentialLength();
}

