/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.EnumSet;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.QuantifiedUtil;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.SubParsers;

class ToStringMediator
implements IToStringMediator {
    private static final char SPACE = ' ';
    private static final EnumSet<AbstractGrammar.DefaultToken> SPACED = EnumSet.of(AbstractGrammar.DefaultToken.MAPS_TO, AbstractGrammar.DefaultToken.MID);
    private static final String[] NO_NAME = new String[0];
    private final int kind;
    protected final AbstractGrammar grammar;
    protected final StringBuilder builder;
    protected final String[] boundNames;
    protected final boolean isRight;
    private final boolean withTypes;
    protected final KindMediator kindMed;

    protected ToStringMediator(int kind, AbstractGrammar grammar, StringBuilder builder, String[] boundNames, boolean isRight, boolean withTypes, KindMediator kindMed) {
        this.kind = kind;
        this.grammar = grammar;
        this.builder = builder;
        this.boundNames = boundNames;
        this.isRight = isRight;
        this.withTypes = withTypes;
        this.kindMed = kindMed;
    }

    public ToStringMediator(Formula<?> formula, StringBuilder builder, String[] boundNames, boolean withTypes, boolean isRight) {
        this.grammar = formula.getFactory().getGrammar();
        this.builder = builder;
        this.boundNames = boundNames;
        this.isRight = isRight;
        this.withTypes = withTypes;
        this.kindMed = new KindMediator(this.grammar);
        this.kind = formula.getKind(this.kindMed);
    }

    @Override
    public void append(AbstractGrammar.DefaultToken token) {
        boolean withSpaces = SPACED.contains((Object)token);
        if (withSpaces) {
            this.builder.append(' ');
        }
        this.builder.append(token.getImage());
        if (withSpaces) {
            this.builder.append(' ');
        }
    }

    @Override
    public void append(String string) {
        this.builder.append(string);
    }

    @Override
    public void subPrint(Formula<?> child, boolean isRightOvr) {
        this.subPrint(child, isRightOvr, NO_NAME);
    }

    private void subPrint(Formula<?> child, boolean isRightOvr, String[] addedBoundNames) {
        this.printChild(child, isRightOvr, addedBoundNames, this.withTypes);
    }

    @Override
    public void subPrintNoPar(Formula<?> child, boolean isRightOvr, String[] addedBoundNames) {
        this.subPrintNoPar(child, isRightOvr, addedBoundNames, this.withTypes);
    }

    @Override
    public void subPrint(Formula<?> child, boolean isRightOvr, String[] addedBoundNames, boolean withTypesOvr) {
        this.printChild(child, isRightOvr, addedBoundNames, withTypesOvr);
    }

    private void subPrintNoPar(Formula<?> child, boolean isRightOvr, String[] addedBoundNames, boolean withTypesOvr) {
        int childKind = child.getKind(this.kindMed);
        this.printFormula(child, childKind, isRightOvr, addedBoundNames, withTypesOvr, false);
    }

    @Override
    public void subPrintWithPar(Formula<?> child) {
        int childKind = child.getKind(this.kindMed);
        this.printFormula(child, childKind, false, NO_NAME, this.withTypes, true);
    }

    private void printChild(Formula<?> child, boolean isRightOvr, String[] addedBoundNames, boolean withTypesOvr) {
        int childKind = child.getKind(this.kindMed);
        boolean needsParen = withTypesOvr && ToStringMediator.isTypePrintable(child) ? true : this.needsParentheses(childKind, isRightOvr);
        this.printFormula(child, childKind, isRightOvr, addedBoundNames, withTypesOvr, needsParen);
    }

    protected boolean needsParentheses(int childKind, boolean isRightOvr) {
        return this.grammar.needsParentheses(isRightOvr, childKind, this.kind);
    }

    private final void printFormula(Formula<?> formula, int formulaKind, boolean isRightOvr, String[] addedBoundNames, boolean withTypesOvr, boolean withParen) {
        if (withParen) {
            this.builder.append('(');
        }
        this.printFormula(formula, formulaKind, isRightOvr, addedBoundNames, withTypesOvr);
        if (withParen) {
            this.builder.append(')');
        }
    }

    @Override
    public void forward(Formula<?> formula) {
        int formulaKind = formula.getKind(this.kindMed);
        this.printFormula(formula, formulaKind, this.isRight, NO_NAME, this.withTypes);
    }

    private String[] addBound(String[] addedBoundNames) {
        if (addedBoundNames.length == 0) {
            return this.boundNames;
        }
        return QuantifiedUtil.catenateBoundIdentLists(this.boundNames, addedBoundNames);
    }

    @Override
    public String[] getBoundNames() {
        return (String[])this.boundNames.clone();
    }

    private void printFormula(Formula<?> formula, int formulaKind, boolean isRightOvr, String[] addedBoundNames, boolean withTypesOvr) {
        String[] newBoundNames = this.addBound(addedBoundNames);
        this.printWithBinding(formula, formulaKind, isRightOvr, withTypesOvr, newBoundNames);
    }

    private void printWithBinding(Formula<?> formula, int formulaKind, boolean isRightOvr, boolean withTypesOvr, String[] newBoundNames) {
        if (withTypesOvr && ToStringMediator.isTypePrintable(formula)) {
            int oftype = this.grammar.getKind(AbstractGrammar.DefaultToken.OFTYPE);
            IToStringMediator mediator = this.makeInstance(oftype, isRightOvr, withTypesOvr, newBoundNames);
            SubParsers.OFTYPE_PARSER.toString(mediator, (Expression)formula);
            return;
        }
        IToStringMediator mediator = this.makeInstance(formulaKind, isRightOvr, withTypesOvr, newBoundNames);
        formula.toString(mediator);
    }

    protected IToStringMediator makeInstance(int formulaKind, boolean isRightOvr, boolean withTypesOvr, String[] newBoundNames) {
        return new ToStringMediator(formulaKind, this.grammar, this.builder, newBoundNames, isRightOvr, withTypesOvr, this.kindMed);
    }

    @Override
    public void appendImage(int lexKind) {
        boolean spaced = this.grammar.isOperator(lexKind) && this.grammar.isSpaced(lexKind);
        this.appendImage(lexKind, spaced);
    }

    @Override
    public void appendImage(int lexKind, boolean withSpaces) {
        String image = this.grammar.getImage(lexKind);
        if (withSpaces) {
            this.builder.append(' ');
        }
        this.builder.append(image);
        if (withSpaces) {
            this.builder.append(' ');
        }
    }

    @Override
    public void appendBoundIdent(int boundIndex) {
        String image = ToStringMediator.resolveIndex(boundIndex, this.boundNames);
        if (image == null) {
            this.builder.append("[[");
            this.builder.append(boundIndex);
            this.builder.append("]]");
        } else {
            this.builder.append(image);
        }
    }

    private static String resolveIndex(int index, String[] boundIdents) {
        if (index < boundIdents.length) {
            return boundIdents[boundIdents.length - index - 1];
        }
        return null;
    }

    @Override
    public boolean isWithTypes() {
        return this.withTypes;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    private static boolean isTypePrintable(Formula<?> toPrint) {
        switch (toPrint.getTag()) {
            case 407: 
            case 410: 
            case 411: 
            case 412: {
                return toPrint.isTypeChecked();
            }
        }
        if (toPrint instanceof ExtendedExpression) {
            return ((ExtendedExpression)toPrint).isAtomic();
        }
        return false;
    }

    @Override
    public AbstractGrammar getGrammar() {
        return this.grammar;
    }
}

