/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class RelationalPredicate
extends Predicate {
    private final Expression left;
    private final Expression right;
    private static final int FIRST_TAG = 101;
    private static final String EQUAL_ID = "equal";
    private static final String NOTEQUAL_ID = "Not Equal";
    private static final String LT_ID = "Lower Than";
    private static final String LE_ID = "lower or equal";
    private static final String GT_ID = "greater than";
    private static final String GE_ID = "Greater or Equal";
    private static final String IN_ID = "In";
    private static final String NOTIN_ID = "Not In";
    private static final String SUBSET_ID = "Subset";
    private static final String NOTSUBSET_ID = "Not Subset";
    private static final String SUBSETEQ_ID = "Subset or Equal";
    private static final String NOTSUBSETEQ_ID = "Not Subset or Equal";
    public static final int TAGS_LENGTH = Operators.values().length;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected RelationalPredicate(Expression left, Expression right, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, RelationalPredicate.combineHashCodes(left.hashCode(), right.hashCode()));
        this.left = left;
        this.right = right;
        FormulaChecks.ensureTagInRange(tag, 101, TAGS_LENGTH);
        this.ensureSameFactory(this.left, this.right);
        this.setPredicateVariableCache(this.left, this.right);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        IdentListMerger freeIdentMerger = IdentListMerger.makeMerger((Identifier[])this.left.freeIdents, (Identifier[])this.right.freeIdents);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = IdentListMerger.makeMerger((Identifier[])this.left.boundIdents, (Identifier[])this.right.boundIdents);
        this.boundIdents = boundIdentMerger.getBoundMergedArray();
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        if (!this.left.isTypeChecked() || !this.right.isTypeChecked()) {
            return;
        }
        Type leftType = this.left.getType();
        Type rightType = this.right.getType();
        switch (this.getTag()) {
            case 101: 
            case 102: {
                if (leftType.equals(rightType)) break;
                return;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                if (leftType instanceof IntegerType && rightType instanceof IntegerType) break;
                return;
            }
            case 107: 
            case 108: {
                Type alpha = rightType.getBaseType();
                if (alpha != null && alpha.equals(leftType)) break;
                return;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                Type alpha = leftType.getBaseType();
                if (alpha != null && alpha.equals(rightType.getBaseType())) break;
                return;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.typeChecked = true;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 101];
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]\n" + this.left.getSyntaxTree(boundNames, tabs + "\t") + this.right.getSyntaxTree(boundNames, tabs + "\t");
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        this.left.isLegible(result);
        this.right.isLegible(result);
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        RelationalPredicate other = (RelationalPredicate)formula;
        return this.left.equals(other.left) && this.right.equals(other.right);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
        this.left.typeCheck(result, quantifiedIdentifiers);
        this.right.typeCheck(result, quantifiedIdentifiers);
        switch (this.getTag()) {
            case 101: 
            case 102: {
                result.unify(this.left.getType(), this.right.getType(), this);
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                IntegerType type = result.makeIntegerType();
                result.unify(this.left.getType(), type, this);
                result.unify(this.right.getType(), type, this);
                break;
            }
            case 107: 
            case 108: {
                result.unify(this.right.getType(), result.makePowerSetType(this.left.getType()), this);
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                TypeVariable alpha = result.newFreshVariable(null);
                PowerSetType type = result.makePowerSetType(alpha);
                result.unify(this.left.getType(), type, this);
                result.unify(this.right.getType(), type, this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        this.left.solveType(unifier);
        this.right.solveType(unifier);
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        this.left.collectFreeIdentifiers(freeIdentSet);
        this.right.collectFreeIdentifiers(freeIdentSet);
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        this.left.collectNamesAbove(names, boundNames, offset);
        this.right.collectNamesAbove(names, boundNames, offset);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 101: {
                goOn = visitor.enterEQUAL(this);
                break;
            }
            case 102: {
                goOn = visitor.enterNOTEQUAL(this);
                break;
            }
            case 103: {
                goOn = visitor.enterLT(this);
                break;
            }
            case 104: {
                goOn = visitor.enterLE(this);
                break;
            }
            case 105: {
                goOn = visitor.enterGT(this);
                break;
            }
            case 106: {
                goOn = visitor.enterGE(this);
                break;
            }
            case 107: {
                goOn = visitor.enterIN(this);
                break;
            }
            case 108: {
                goOn = visitor.enterNOTIN(this);
                break;
            }
            case 109: {
                goOn = visitor.enterSUBSET(this);
                break;
            }
            case 110: {
                goOn = visitor.enterNOTSUBSET(this);
                break;
            }
            case 111: {
                goOn = visitor.enterSUBSETEQ(this);
                break;
            }
            case 112: {
                goOn = visitor.enterNOTSUBSETEQ(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (goOn) {
            goOn = this.left.accept(visitor);
        }
        if (goOn) {
            switch (this.getTag()) {
                case 101: {
                    goOn = visitor.continueEQUAL(this);
                    break;
                }
                case 102: {
                    goOn = visitor.continueNOTEQUAL(this);
                    break;
                }
                case 103: {
                    goOn = visitor.continueLT(this);
                    break;
                }
                case 104: {
                    goOn = visitor.continueLE(this);
                    break;
                }
                case 105: {
                    goOn = visitor.continueGT(this);
                    break;
                }
                case 106: {
                    goOn = visitor.continueGE(this);
                    break;
                }
                case 107: {
                    goOn = visitor.continueIN(this);
                    break;
                }
                case 108: {
                    goOn = visitor.continueNOTIN(this);
                    break;
                }
                case 109: {
                    goOn = visitor.continueSUBSET(this);
                    break;
                }
                case 110: {
                    goOn = visitor.continueNOTSUBSET(this);
                    break;
                }
                case 111: {
                    goOn = visitor.continueSUBSETEQ(this);
                    break;
                }
                case 112: {
                    goOn = visitor.continueNOTSUBSETEQ(this);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (goOn) {
            goOn = this.right.accept(visitor);
        }
        switch (this.getTag()) {
            case 101: {
                return visitor.exitEQUAL(this);
            }
            case 102: {
                return visitor.exitNOTEQUAL(this);
            }
            case 103: {
                return visitor.exitLT(this);
            }
            case 104: {
                return visitor.exitLE(this);
            }
            case 105: {
                return visitor.exitGT(this);
            }
            case 106: {
                return visitor.exitGE(this);
            }
            case 107: {
                return visitor.exitIN(this);
            }
            case 108: {
                return visitor.exitNOTIN(this);
            }
            case 109: {
                return visitor.exitSUBSET(this);
            }
            case 110: {
                return visitor.exitNOTSUBSET(this);
            }
            case 111: {
                return visitor.exitSUBSETEQ(this);
            }
            case 112: {
                return visitor.exitNOTSUBSETEQ(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitRelationalPredicate(this);
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        Expression newLeft = (Expression)this.left.rewrite(rewriter);
        Expression newRight = (Expression)this.right.rewrite(rewriter);
        RelationalPredicate before = newLeft == this.left && newRight == this.right ? this : rewriter.getFactory().makeRelationalPredicate(this.getTag(), newLeft, newRight, this.getSourceLocation());
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        this.left.inspect(acc);
        if (acc.allSkipped()) {
            return;
        }
        acc.nextChild();
        this.right.inspect(acc);
        acc.leaveChildren();
    }

    public Expression getChild(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw RelationalPredicate.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        indexes.push(0);
        IPosition pos = this.left.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.incrementTop();
        pos = this.right.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        Expression newLeft = this.left;
        Expression newRight = this.right;
        switch (index) {
            case 0: {
                newLeft = rewriter.rewrite(this.left);
                break;
            }
            case 1: {
                newRight = rewriter.rewrite(this.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Position is outside the formula");
            }
        }
        return this.getFactory().makeRelationalPredicate(this.getTag(), newLeft, newRight, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<RelationalPredicate>
    {
        OP_EQUAL("=", "equal", StandardGroup.RELOP_PRED, 101),
        OP_NOTEQUAL("\u2260", "Not Equal", StandardGroup.RELOP_PRED, 102),
        OP_LT("<", "Lower Than", StandardGroup.RELOP_PRED, 103),
        OP_LE("\u2264", "lower or equal", StandardGroup.RELOP_PRED, 104),
        OP_GT(">", "greater than", StandardGroup.RELOP_PRED, 105),
        OP_GE("\u2265", "Greater or Equal", StandardGroup.RELOP_PRED, 106),
        OP_IN("\u2208", "In", StandardGroup.RELOP_PRED, 107),
        OP_NOTIN("\u2209", "Not In", StandardGroup.RELOP_PRED, 108),
        OP_SUBSET("\u2282", "Subset", StandardGroup.RELOP_PRED, 109),
        OP_NOTSUBSET("\u2284", "Not Subset", StandardGroup.RELOP_PRED, 110),
        OP_SUBSETEQ("\u2286", "Subset or Equal", StandardGroup.RELOP_PRED, 111),
        OP_NOTSUBSETEQ("\u2288", "Not Subset or Equal", StandardGroup.RELOP_PRED, 112);

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<RelationalPredicate> makeParser(int kind) {
            return new SubParsers.RelationalPredicateInfix(kind, this.tag);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

