/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Identifier;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.QuantifiedHelper;
import org.eventb.core.ast.QuantifiedUtil;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.AbstractGrammar;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;
import org.eventb.internal.core.typecheck.TypeVariable;

public class QuantifiedExpression
extends Expression {
    private final BoundIdentDecl[] quantifiedIdentifiers;
    private final Expression expr;
    private final Predicate pred;
    private final Form form;
    private static final int FIRST_TAG = 801;
    private static final String CSET_ID = "Comprehension Set";
    private static final String LAMBDA_ID = "Lambda";
    private static final String QUNION_ID = "Quantified Union";
    private static final String QINTER_ID = "Quantified Intersection";
    public static final int TAGS_LENGTH = 3;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return QuantifiedExpression.getOperator(this.getTag(), this.form);
    }

    private static Operators getOperator(int tagOvr, Form formOvr) {
        switch (tagOvr) {
            case 803: {
                switch (formOvr) {
                    case Explicit: {
                        return Operators.OP_CSET_EXPL;
                    }
                    case Implicit: {
                        return Operators.OP_CSET_IMPL;
                    }
                    case Lambda: {
                        return Operators.OP_CSET_LAMBDA;
                    }
                }
                throw QuantifiedExpression.newIllegalForm(formOvr);
            }
            case 801: {
                switch (formOvr) {
                    case Explicit: {
                        return Operators.OP_QUNION_EXPL;
                    }
                    case Implicit: {
                        return Operators.OP_QUNION_IMPL;
                    }
                }
                throw QuantifiedExpression.newIllegalForm(formOvr);
            }
            case 802: {
                switch (formOvr) {
                    case Explicit: {
                        return Operators.OP_QINTER_EXPL;
                    }
                    case Implicit: {
                        return Operators.OP_QINTER_IMPL;
                    }
                }
                throw QuantifiedExpression.newIllegalForm(formOvr);
            }
        }
        throw QuantifiedExpression.newIllegalForm(formOvr);
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator;
        HashSet<String> usedNames = new HashSet<String>();
        String[] boundNames = mediator.getBoundNames();
        this.expr.collectNamesAbove(usedNames, boundNames, this.quantifiedIdentifiers.length);
        boolean exprIsClosed = usedNames.size() == 0;
        this.pred.collectNamesAbove(usedNames, boundNames, this.quantifiedIdentifiers.length);
        String[] localNames = QuantifiedUtil.resolveIdents(this.quantifiedIdentifiers, usedNames, this.getFactory());
        switch (this.form) {
            case Lambda: {
                operator = this.getOperator();
                break;
            }
            case Implicit: {
                if (exprIsClosed && !mediator.isWithTypes()) {
                    operator = this.getOperator();
                    break;
                }
                operator = QuantifiedExpression.getOperator(this.getTag(), Form.Explicit);
                break;
            }
            case Explicit: {
                operator = QuantifiedExpression.getOperator(this.getTag(), Form.Explicit);
                break;
            }
            default: {
                assert (false);
                operator = null;
            }
        }
        int kind = mediator.getKind();
        operator.makeParser(kind, localNames).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    private static IllegalStateException newIllegalForm(Form form) {
        return new IllegalStateException("Illegal form for quantified expression: " + (Object)((Object)form));
    }

    protected QuantifiedExpression(Expression expr, Predicate pred, BoundIdentDecl[] boundIdentifiers, int tag, SourceLocation location, Form form, FormulaFactory ff) {
        super(tag, ff, location, QuantifiedExpression.combineHashCodes(boundIdentifiers.length, pred.hashCode(), expr.hashCode()));
        this.quantifiedIdentifiers = boundIdentifiers;
        this.expr = expr;
        this.pred = pred;
        FormulaChecks.ensureTagInRange(tag, 801, 3);
        FormulaChecks.ensureMinLength(boundIdentifiers, 1);
        this.ensureSameFactory(this.quantifiedIdentifiers);
        this.ensureSameFactory(this.pred, this.expr);
        this.setPredicateVariableCache(this.pred, this.expr);
        this.synthesizeType(null);
        this.form = this.filterForm(form);
    }

    @Override
    protected void synthesizeType(Type givenType) {
        Type resultType;
        int length = this.quantifiedIdentifiers.length;
        Formula[] children = new Formula[length + 2];
        System.arraycopy(this.quantifiedIdentifiers, 0, children, 0, length);
        children[length] = this.pred;
        children[length + 1] = this.expr;
        IdentListMerger freeIdentMerger = QuantifiedExpression.mergeFreeIdentifiers((Formula[])children);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        IdentListMerger boundIdentMerger = IdentListMerger.makeMerger((Identifier[])this.pred.boundIdents, (Identifier[])this.expr.boundIdents);
        BoundIdentifier[] boundIdentsBelow = boundIdentMerger.getBoundMergedArray();
        this.boundIdents = QuantifiedHelper.getBoundIdentsAbove(boundIdentsBelow, this.quantifiedIdentifiers, this.getFactory());
        if (freeIdentMerger.containsError() || boundIdentMerger.containsError()) {
            return;
        }
        if (!QuantifiedHelper.checkBoundIdentTypes(boundIdentsBelow, this.quantifiedIdentifiers)) {
            return;
        }
        if (!this.pred.isTypeChecked() || !this.expr.isTypeChecked()) {
            return;
        }
        Type exprType = this.expr.getType();
        switch (this.getTag()) {
            case 801: 
            case 802: {
                Type alpha = exprType.getBaseType();
                if (alpha != null) {
                    resultType = exprType;
                    break;
                }
                return;
            }
            case 803: {
                resultType = this.getFactory().makePowerSetType(exprType);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.setFinalType(resultType, givenType);
    }

    private Form filterForm(Form inputForm) {
        switch (inputForm) {
            case Lambda: {
                PatternChecker checker = new PatternChecker(this.quantifiedIdentifiers.length);
                if (this.getTag() == 803 && checker.verify(this.expr)) {
                    return Form.Lambda;
                }
            }
            case Implicit: {
                if (!this.isValidImplicitExpr()) break;
                return Form.Implicit;
            }
        }
        return Form.Explicit;
    }

    private boolean isValidImplicitExpr() {
        if (this.expr.getSyntacticallyFreeIdentifiers().length != 0) {
            return false;
        }
        BoundIdentifier[] bids = this.expr.getBoundIdentifiers();
        return bids.length == this.quantifiedIdentifiers.length && bids[bids.length - 1].getBoundIndex() == bids.length - 1;
    }

    public Form getForm() {
        return this.form;
    }

    public BoundIdentDecl[] getBoundIdentDecls() {
        return (BoundIdentDecl[])this.quantifiedIdentifiers.clone();
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String typeName = this.getType() != null ? " [type: " + this.getType().toString() + "]" : "";
        String[] boundNamesBelow = QuantifiedUtil.catenateBoundIdentLists(boundNames, this.quantifiedIdentifiers);
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + ", " + this.form.toString() + "]" + typeName + "\n" + QuantifiedHelper.getSyntaxTreeQuantifiers(boundNames, tabs + "\t", this.quantifiedIdentifiers) + this.expr.getSyntaxTree(boundNamesBelow, tabs + "\t") + this.pred.getSyntaxTree(boundNamesBelow, tabs + "\t");
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        LegibilityResult resultCopy = new LegibilityResult(result);
        for (BoundIdentDecl decl : this.quantifiedIdentifiers) {
            decl.isLegible(resultCopy);
        }
        this.pred.isLegible(resultCopy);
        this.expr.isLegible(resultCopy);
        for (ASTProblem problem : resultCopy.getProblems()) {
            result.addProblem(problem);
        }
    }

    @Override
    boolean equalsInternalExpr(Expression expression) {
        QuantifiedExpression other = (QuantifiedExpression)expression;
        return QuantifiedHelper.areEqualDecls(this.quantifiedIdentifiers, other.quantifiedIdentifiers) && this.expr.equals(other.expr) && this.pred.equals(other.pred);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdents) {
        PowerSetType resultType;
        for (BoundIdentDecl decl : this.quantifiedIdentifiers) {
            decl.typeCheck(result, quantifiedIdents);
        }
        BoundIdentDecl[] newQuantifiers = QuantifiedUtil.catenateBoundIdentLists(quantifiedIdents, this.quantifiedIdentifiers);
        this.pred.typeCheck(result, newQuantifiers);
        this.expr.typeCheck(result, newQuantifiers);
        switch (this.getTag()) {
            case 801: 
            case 802: {
                TypeVariable alpha = result.newFreshVariable(null);
                resultType = result.makePowerSetType(alpha);
                result.unify(this.expr.getType(), resultType, this);
                break;
            }
            case 803: {
                resultType = result.makePowerSetType(this.expr.getType());
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.setTemporaryType(resultType, result);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        for (BoundIdentDecl ident : this.quantifiedIdentifiers) {
            ident.solveType(unifier);
        }
        this.expr.solveType(unifier);
        this.pred.solveType(unifier);
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        switch (this.form) {
            case Explicit: 
            case Lambda: {
                this.pred.collectFreeIdentifiers(freeIdentSet);
                this.expr.collectFreeIdentifiers(freeIdentSet);
                break;
            }
            case Implicit: {
                this.expr.collectFreeIdentifiers(freeIdentSet);
                this.pred.collectFreeIdentifiers(freeIdentSet);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Set<String> collectNamesAbove(String[] boundNames) {
        HashSet<String> result = new HashSet<String>();
        this.expr.collectNamesAbove(result, boundNames, this.quantifiedIdentifiers.length);
        this.pred.collectNamesAbove(result, boundNames, this.quantifiedIdentifiers.length);
        return result;
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        int newOffset = offset + this.quantifiedIdentifiers.length;
        this.pred.collectNamesAbove(names, boundNames, newOffset);
        this.expr.collectNamesAbove(names, boundNames, newOffset);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 801: {
                goOn = visitor.enterQUNION(this);
                break;
            }
            case 802: {
                goOn = visitor.enterQINTER(this);
                break;
            }
            case 803: {
                goOn = visitor.enterCSET(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        for (int i = 0; goOn && i < this.quantifiedIdentifiers.length; ++i) {
            goOn = this.quantifiedIdentifiers[i].accept(visitor);
            if (!goOn) continue;
            goOn = this.acceptContinue(visitor);
        }
        if (goOn) {
            goOn = this.pred.accept(visitor);
        }
        if (goOn) {
            goOn = this.acceptContinue(visitor);
        }
        if (goOn) {
            goOn = this.expr.accept(visitor);
        }
        switch (this.getTag()) {
            case 801: {
                return visitor.exitQUNION(this);
            }
            case 802: {
                return visitor.exitQINTER(this);
            }
            case 803: {
                return visitor.exitCSET(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitQuantifiedExpression(this);
    }

    private boolean acceptContinue(IVisitor visitor) {
        switch (this.getTag()) {
            case 801: {
                return visitor.continueQUNION(this);
            }
            case 802: {
                return visitor.continueQINTER(this);
            }
            case 803: {
                return visitor.continueCSET(this);
            }
        }
        assert (false);
        return true;
    }

    @Override
    protected Expression rewrite(ITypeCheckingRewriter rewriter) {
        BoundIdentDecl[] newDecls = QuantifiedHelper.rewriteDecls(this.quantifiedIdentifiers, rewriter);
        int nbOfBoundIdentDecls = this.quantifiedIdentifiers.length;
        rewriter.enteringQuantifier(nbOfBoundIdentDecls);
        Predicate newPred = (Predicate)this.pred.rewrite(rewriter);
        Expression newExpr = (Expression)this.expr.rewrite(rewriter);
        rewriter.leavingQuantifier(nbOfBoundIdentDecls);
        QuantifiedExpression before = newDecls == this.quantifiedIdentifiers && newPred == this.pred && newExpr == this.expr ? this : rewriter.getFactory().makeQuantifiedExpression(this.getTag(), newDecls, newPred, newExpr, this.getSourceLocation(), this.form);
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        for (BoundIdentDecl decl : this.quantifiedIdentifiers) {
            decl.inspect(acc);
            if (acc.allSkipped()) break;
            acc.nextChild();
        }
        if (!acc.allSkipped()) {
            this.pred.inspect(acc);
        }
        acc.nextChild();
        if (!acc.allSkipped()) {
            this.expr.inspect(acc);
        }
        acc.leaveChildren();
    }

    @Override
    public Formula<?> getChild(int index) {
        if (index < this.quantifiedIdentifiers.length) {
            return this.quantifiedIdentifiers[index];
        }
        switch (index -= this.quantifiedIdentifiers.length) {
            case 0: {
                return this.pred;
            }
            case 1: {
                return this.expr;
            }
        }
        throw QuantifiedExpression.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return this.quantifiedIdentifiers.length + 2;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        IPosition pos;
        if (this.form == Form.Explicit) {
            indexes.push(0);
            for (BoundIdentDecl decl : this.quantifiedIdentifiers) {
                pos = decl.getPosition(sloc, indexes);
                if (pos != null) {
                    return pos;
                }
                indexes.incrementTop();
            }
        } else {
            indexes.push(this.quantifiedIdentifiers.length);
        }
        pos = this.pred.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.incrementTop();
        if (this.form != Form.Lambda) {
            pos = this.expr.getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
        } else {
            BinaryExpression maplet = (BinaryExpression)this.expr;
            indexes.push(0);
            pos = maplet.getLeft().getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.incrementTop();
            pos = maplet.getRight().getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.pop();
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Expression rewriteChild(int index, SingleRewriter rewriter) {
        BoundIdentDecl[] newDecls = this.quantifiedIdentifiers;
        Predicate newPred = this.pred;
        Expression newExpr = this.expr;
        int length = this.quantifiedIdentifiers.length;
        if (index < length) {
            newDecls = (BoundIdentDecl[])this.quantifiedIdentifiers.clone();
            newDecls[index] = rewriter.rewrite(this.quantifiedIdentifiers[index]);
        } else if (index == length) {
            newPred = rewriter.rewrite(this.pred);
        } else if (index == length + 1) {
            newExpr = rewriter.rewrite(this.expr);
        } else {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        return this.getFactory().makeQuantifiedExpression(this.getTag(), newDecls, newPred, newExpr, this.getSourceLocation(), this.form);
    }

    @Override
    public boolean isWDStrict() {
        return false;
    }

    private static enum Operators implements IOperatorInfo<QuantifiedExpression>
    {
        OP_QUNION_EXPL("\u22c3", "Quantified Union", StandardGroup.QUANTIFICATION){

            @Override
            public SubParsers.IQuantifiedParser<QuantifiedExpression> makeParser(int kind) {
                return new SubParsers.ExplicitQuantExpr(kind, 801);
            }
        }
        ,
        OP_QUNION_IMPL("\u22c3", "Quantified Union", StandardGroup.QUANTIFICATION){

            @Override
            public SubParsers.IQuantifiedParser<QuantifiedExpression> makeParser(int kind) {
                return new SubParsers.ImplicitQuantExpr(kind, 801);
            }
        }
        ,
        OP_QINTER_EXPL("\u22c2", "Quantified Intersection", StandardGroup.QUANTIFICATION){

            @Override
            public SubParsers.IQuantifiedParser<QuantifiedExpression> makeParser(int kind) {
                return new SubParsers.ExplicitQuantExpr(kind, 802);
            }
        }
        ,
        OP_QINTER_IMPL("\u22c2", "Quantified Intersection", StandardGroup.QUANTIFICATION){

            @Override
            public SubParsers.IQuantifiedParser<QuantifiedExpression> makeParser(int kind) {
                return new SubParsers.ImplicitQuantExpr(kind, 802);
            }
        }
        ,
        OP_CSET_EXPL(AbstractGrammar.DefaultToken.LBRACE.getImage(), "Comprehension Set", StandardGroup.BRACE_SETS){

            @Override
            public SubParsers.IQuantifiedParser<QuantifiedExpression> makeParser(int kind) {
                return new SubParsers.CSetExplicit(kind);
            }
        }
        ,
        OP_CSET_IMPL(AbstractGrammar.DefaultToken.LBRACE.getImage(), "Comprehension Set", StandardGroup.BRACE_SETS){

            @Override
            public SubParsers.IQuantifiedParser<QuantifiedExpression> makeParser(int kind) {
                return new SubParsers.CSetImplicit(kind);
            }
        }
        ,
        OP_CSET_LAMBDA("\u03bb", "Lambda", StandardGroup.QUANTIFICATION){

            @Override
            public SubParsers.IQuantifiedParser<QuantifiedExpression> makeParser(int kind) {
                return new SubParsers.CSetLambda(kind);
            }
        };

        private final String image;
        private final String id;
        private final String groupId;

        private Operators(String image, String id, StandardGroup group) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public boolean isSpaced() {
            return false;
        }

        public IParserPrinter<QuantifiedExpression> makeParser(int kind, String[] localNames) {
            IParserPrinter<QuantifiedExpression> parser = this.makeParser(kind);
            ((SubParsers.IQuantifiedParser)parser).setLocalNames(localNames);
            return parser;
        }
    }

    private static class PatternChecker {
        private int expectedIndex;

        public PatternChecker(int nbBoundIdentDecls) {
            this.expectedIndex = nbBoundIdentDecls - 1;
        }

        public boolean verify(Expression expr) {
            if (expr.getTag() != 201) {
                return false;
            }
            Expression pattern = ((BinaryExpression)expr).getLeft();
            return this.traverse(pattern) && this.expectedIndex == -1;
        }

        private boolean traverse(Expression pattern) {
            switch (pattern.getTag()) {
                case 201: {
                    BinaryExpression maplet = (BinaryExpression)pattern;
                    return this.traverse(maplet.getLeft()) && this.traverse(maplet.getRight());
                }
                case 3: {
                    BoundIdentifier ident = (BoundIdentifier)pattern;
                    return ident.getBoundIndex() == this.expectedIndex--;
                }
            }
            return false;
        }
    }

    public static enum Form {
        Lambda,
        Implicit,
        Explicit;

    }
}

